/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IndexType;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="25.2.14")
@CheckID(value="R.1403")
@CheckName(value="R.1403")
@CheckLabel(labels={RuleLabel.AGGREGATE_DATA_TYPE, RuleLabel.ARRAY, RuleLabel.ASSIGNMENT, RuleLabel.RANGE})
@CheckTitle(value="Do not assign different endianness arrays")
@CheckDescription(value="This check flags assignments where the left part array has different endianess declaration then the right part.\n\nExample:\nbit [7:0] A [0:3];\nbit [7:0] B [3:0];\nbit [7:0] C [0:3];\nA = B;  \t\t\t\t\t// not allowed\nA = C;\t\t\t\t\t// allowed\n\nCheck supports pre-waiving.")
public class Check_R_1403
extends OVMComplianceCheck {
    private static final String ERROR_MESSAGE = "Arrays ''{0}'' and ''{1}'' have different endianess declarations!";

    public Check_R_1403(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject == null) {
            return;
        }
        this.fOVMProject.getRfProject().visitHidObject(this.fOVMProject.getRfProject(), new AssignmentVisitor());
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private class AssignmentVisitor
    implements IHidVisitor<RfHidOperator> {
        private ParserPath parserPath;
        private RfNamedElement scope;

        private AssignmentVisitor() {
        }

        public boolean visit(RfHidOperator hidOperator) {
            Boolean isRangeAscending;
            if (hidOperator == null) {
                return true;
            }
            if (Check_R_1403.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            Check_R_1403.this.notifyCheckAlive();
            if (this.scope.isPredefined()) {
                return true;
            }
            if (!hidOperator.hasOccurrence(HidQualifierCache.ALL_SIMPLE_ASSIGN_QUALIFIERS) && !hidOperator.hasOccurrence(HidOperatorQualifier.IS_PORT_CONNECTION)) {
                return true;
            }
            IHidObject lhValue = hidOperator.getLHValue();
            IHidObject rhValue = hidOperator.getFirstRHValue();
            if (!(lhValue instanceof RfHid) || !(rhValue instanceof RfHid)) {
                return true;
            }
            IRfNamedElement lhElement = ((RfHid)lhValue).getElement();
            IRfNamedElement rhElement = ((RfHid)rhValue).getElement();
            if (!(lhElement instanceof RfField) || !(rhElement instanceof RfField)) {
                return true;
            }
            RfField lhField = (RfField)lhElement;
            List<IHidObject> lhRange = this.getArrayDimentions(lhField);
            if (lhRange.isEmpty()) {
                return true;
            }
            RfField rhField = (RfField)rhElement;
            List<IHidObject> rhRange = this.getArrayDimentions(rhField);
            if (rhRange.isEmpty()) {
                return true;
            }
            ArrayList<Boolean> rangeLeftPart = new ArrayList<Boolean>();
            ArrayList<Boolean> rangeRightPart = new ArrayList<Boolean>();
            for (IHidObject range : lhRange) {
                isRangeAscending = this.isAscending(range);
                if (isRangeAscending == null) {
                    return true;
                }
                rangeLeftPart.add(isRangeAscending);
            }
            for (IHidObject range : rhRange) {
                isRangeAscending = this.isAscending(range);
                if (isRangeAscending == null) {
                    return true;
                }
                rangeRightPart.add(isRangeAscending);
            }
            if (rangeLeftPart.isEmpty() || rangeRightPart.isEmpty()) {
                return true;
            }
            if (rangeLeftPart.equals(rangeRightPart)) {
                return true;
            }
            Check_R_1403.this.addHit(this.parserPath, (HidOccurrence)hidOperator.getOccurrence(), MessageFormat.format(Check_R_1403.ERROR_MESSAGE, lhField, rhField));
            return true;
        }

        private Boolean isAscending(IHidObject rangeObject) {
            if (rangeObject instanceof RfHidOperator) {
                if (((RfHidOperator)rangeObject).isRangeOrPartSelect()) {
                    List<Integer> range = this.convertOperatorToListRange((RfHidOperator)rangeObject);
                    if (range == null || range.size() != 2) {
                        return null;
                    }
                    if (range.get(0) <= range.get(1)) {
                        return true;
                    }
                }
            } else {
                if (rangeObject instanceof RfHidImplicit) {
                    return true;
                }
                return null;
            }
            return false;
        }

        private List<Integer> convertOperatorToListRange(RfHidOperator range) {
            ArrayList<Integer> rangeResults = new ArrayList<Integer>();
            IHidObject lhValueRange = range.getLHValue();
            IHidObject rhValueRange = range.getFirstRHValue();
            if (!(lhValueRange instanceof RfHidImplicit) || !(rhValueRange instanceof RfHidImplicit)) {
                return null;
            }
            try {
                int intLeftPart = Integer.parseInt(((RfHidImplicit)lhValueRange).getName());
                int intRightPart = Integer.parseInt(((RfHidImplicit)rhValueRange).getName());
                rangeResults.add(intLeftPart);
                rangeResults.add(intRightPart);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            return rangeResults;
        }

        private List<IHidObject> getArrayDimentions(RfAssociatedType field) {
            ArrayList<IHidObject> allRanges = new ArrayList<IHidObject>();
            DataType dataType = field.getDataType();
            if (dataType == null) {
                return allRanges;
            }
            List<IndexType> dimensions = this.getDimensions(dataType);
            if (dimensions == null || dimensions.isEmpty()) {
                return allRanges;
            }
            for (IndexType dimension : dimensions) {
                IHidObject rangeObj = dimension.getRangeObject();
                if (rangeObj == null) continue;
                allRanges.add(rangeObj);
            }
            return allRanges;
        }

        private List<IndexType> getDimensions(DataType datatype) {
            ArrayList<IndexType> allDimensions = new ArrayList<IndexType>();
            if (datatype.getPackedDimension() != null) {
                allDimensions.addAll(datatype.getPackedDimension());
            }
            if (datatype.getUnpackedDimension() != null) {
                allDimensions.addAll(datatype.getUnpackedDimension());
            }
            return allDimensions;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }

        public void setHolder(IHidHolder holder) {
            this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
        }
    }
}

