/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="25.2.16")
@CheckID(value="R.1404")
@CheckName(value="R.1404")
@CheckLabel(labels={RuleLabel.OPERATOR, RuleLabel.COMPARISON})
@CheckTitle(value="Do not use arithmetic operations in comparisons")
@CheckDescription(value="This check flags comparisons that contain arithmetic operations.\n\nExample:\nlogic out;\nlogic [3:0] a, b;\nint c;\n\nassign out = a == (b + 1); // not allowed\nassign out = c == (2 * 3 + 100); // allowed iff skipComparisonsWithImplicits\n\nCheck supports pre-waiving.")
public class Check_R_1404
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="If true, the check skips comparisons where at least one of the operands contains only implicit values. Default value: false", name="skipComparisonsWithImplicits", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean skipComparisonsWithImplicits;
    private static final Set<Integer> OPERATOR_TYPE_TOKENS = new HashSet<Integer>(Arrays.asList(482, 483, 484, 485, 502, 504, 486, 487, 488, 489));

    public Check_R_1404(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject == null) {
            return;
        }
        this.fOVMProject.getRfProject().visitHidObject(null, new ArithmeticComparisonVisitor());
    }

    public boolean checkOperator(RfHidOperator operator) {
        int operatorType = operator.getOperatorType();
        return (OPERATOR_TYPE_TOKENS.contains(operatorType) || operator.isCaseItemCondition()) && !operator.isAssignment();
    }

    public boolean isArithmetic(IHidObject hidObject) {
        if (!(hidObject instanceof RfHidOperator)) {
            return false;
        }
        RfHidOperator operator = (RfHidOperator)hidObject;
        IHidObject lhOperand = operator.getLHValue();
        ListContainer rhValues = operator.getRHValues();
        if (operator.getOperatorKind() != IHidOperatorConstants.OperatorKind.UNARY_OPERATOR && (operator.isArithmetic() || operator.isModulo())) {
            return true;
        }
        if (this.isArithmetic(lhOperand)) {
            return true;
        }
        if (rhValues != null) {
            for (IHidObject rhValue : rhValues) {
                if (!this.isArithmetic(rhValue)) continue;
                return true;
            }
        }
        return false;
    }

    private Boolean checkIfHidObjectContainsNonImplicits(IHidObject hidObject) {
        Collection<IHidObject> flattenedHids;
        if (hidObject instanceof RfHidOperator) {
            flattenedHids = this.flattenToHidsFromOperator((RfHidOperator)hidObject);
            if (flattenedHids == null) {
                return null;
            }
        } else {
            flattenedHids = Arrays.asList(hidObject);
        }
        return flattenedHids.stream().anyMatch(hid -> !(hid instanceof RfHidImplicit));
    }

    private Collection<IHidObject> flattenToHidsFromOperator(RfHidOperator operator) {
        ArrayList<IHidObject> flattenedHids = new ArrayList<IHidObject>();
        Set flattenOP = HidUtils.flattenToOperators((IHidOperator)operator);
        for (IHidOperator op : flattenOP) {
            if (!(op instanceof RfHidOperator)) {
                return null;
            }
            operator = (RfHidOperator)op;
            if (!(operator.getLHValue() instanceof RfHidOperator) && !operator.isVLOGConcatenation(true)) {
                flattenedHids.add(operator.getLHValue());
            }
            if (operator.getOperatorKind() != IHidOperatorConstants.OperatorKind.BINARY_OPERATOR) continue;
            if (operator.getRHValues() == null) {
                return null;
            }
            for (IHidObject operand : operator.getRHValues()) {
                if (operand instanceof RfHidOperator) continue;
                flattenedHids.add(operand);
            }
        }
        return flattenedHids;
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private class ArithmeticComparisonVisitor
    implements IHidVisitor<RfHidOperator> {
        private ParserPath parserPath;

        private ArithmeticComparisonVisitor() {
        }

        public boolean visit(RfHidOperator operator) {
            if (!Check_R_1404.this.checkOperator(operator)) {
                return true;
            }
            if (Check_R_1404.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            Check_R_1404.this.notifyCheckAlive();
            IHidObject lhHidObject = operator.getLHValue();
            IHidObject rhHidObject = operator.getFirstRHValue();
            if (lhHidObject == null || rhHidObject == null) {
                return true;
            }
            if (!(!Check_R_1404.this.skipComparisonsWithImplicits || Check_R_1404.this.checkIfHidObjectContainsNonImplicits(rhHidObject).booleanValue() && Check_R_1404.this.checkIfHidObjectContainsNonImplicits(lhHidObject).booleanValue())) {
                return true;
            }
            if (rhHidObject instanceof RfHidOperator && Check_R_1404.this.isArithmetic(rhHidObject) || lhHidObject instanceof RfHidOperator && Check_R_1404.this.isArithmetic(lhHidObject)) {
                Check_R_1404.this.addHit(this.parserPath, (HidOccurrence)operator.getOccurrence(), "Comparison " + HidUtils.toNiceString((IHidObject)operator) + " contains arithmetic operations!");
            }
            return true;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }
    }
}

