/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Set;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfProject;

@CheckVersion(value="25.3.19")
@CheckID(value="R.1405")
@CheckName(value="R.1405")
@CheckLabel(labels={RuleLabel.NAME, RuleLabel.STYLING})
@CheckTitle(value="Automatic variables naming pattern")
@CheckDescription(value="Explicitly declared automatic variables should be named after the specified patterns.\n\nExample when automaticNamePatterns is \".*_a\":\n\nautomatic int var_a;   // allowed\nautomatic int my_var;   // not allowed\n\nCheck supports pre-waiving.")
public class Check_R_1405
extends OVMComplianceCheck {
    @CheckParameter(defaultValue=".*_a", description="Comma separated list of allowed patterns for the name of the explicitly declared automatic variables.", name="automaticNamePatterns", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_REGEX)
    private Set<Pattern> pAutomaticNamePatterns;

    public Check_R_1405(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject == null) {
            return;
        }
        RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null) {
            return;
        }
        IRfNamedElementVisitor visitor = namedElement -> {
            if (!(namedElement instanceof RfField)) {
                return true;
            }
            if (namedElement.isPredefined()) {
                return true;
            }
            this.notifyCheckAlive();
            if (namedElement.getDeclaration() == null) {
                return true;
            }
            if (this.checkPreWaivers(namedElement.getDeclaration().getParserPath())) {
                return true;
            }
            if (!namedElement.hasStorageAutomaticQualifier() && !namedElement.hasObjectAutomaticQualifier()) {
                return true;
            }
            for (Pattern pattern : this.pAutomaticNamePatterns) {
                if (!pattern.matcher(namedElement.getName()).matches()) continue;
                return true;
            }
            this.addHit(namedElement, "The automatic variable '" + LintUtils.getNamedElementFullName(namedElement) + "' does not follow the specified name patterns!");
            return true;
        };
        this.fOVMProject.getRfProject().accept(visitor);
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

