/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="25.3.22")
@CheckID(value="R.1406")
@CheckName(value="R.1406")
@CheckLabel(labels={RuleLabel.MESSAGING, RuleLabel.METHOD, RuleLabel.VERIFICATION})
@CheckTitle(value="Banned verbosity for xvm_report_info messages.")
@CheckDescription(value="Do not use xvm_report_info method with <bannedVerbosity> verbosity.\n\nXVM example for default banned verbosity 'XVM_NONE':\nxvm_report_info(\"ID\", \"MSG\", XVM_NONE); // not allowed\nxvm_report_info(\"ID\", \"MSG\", XVM_HIGH); // allowed\n\nCheck supports pre-waiving.")
public class Check_R_1406
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of XVM verbosities. When empty, XVM_NONE will be the checked verbosity", name="bannedVerbosity", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pBannedVerbosity;
    @CheckParameter(defaultValue="false", description="When true only xvm_report_info messages from loops are checked.", name="checkOnlyLoops", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pCheckOnlyLoops;
    private String verbosityDefaultValue;
    private static Set<String> ovmVerbosity = new HashSet<String>(Arrays.asList("OVM_NONE", "OVM_LOW", "OVM_MEDIUM", "OVM_HIGH", "OVM_FULL", "OVM_DEBUG"));
    private static Set<String> uvmVerbosity = new HashSet<String>(Arrays.asList("UVM_NONE", "UVM_LOW", "UVM_MEDIUM", "UVM_HIGH", "UVM_FULL", "UVM_DEBUG"));
    private Set<String> targetMethods;

    public Check_R_1406(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void configure() {
        super.configure();
        if (this.pBannedVerbosity.isEmpty()) {
            this.pBannedVerbosity.add(OVMUtils.prependCapitalizedLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_NONE"));
        }
        for (String verbosity : this.pBannedVerbosity) {
            if (this.fOVMProject.getLibraryKind() == 1) {
                if (ovmVerbosity.contains(verbosity)) continue;
                this.signalParamError("Invalid verbosity: '" + verbosity + "'!", true);
                continue;
            }
            if (this.fOVMProject.getLibraryKind() != 2 || uvmVerbosity.contains(verbosity)) continue;
            this.signalParamError("Invalid verbosity: '" + verbosity + "'!", true);
        }
        this.targetMethods = new HashSet<String>();
        if (this.fOVMProject.getLibraryKind() == 1) {
            this.targetMethods.add("ovm_pkg::ovm_report_object.ovm_report_info");
            this.targetMethods.add("ovm_pkg::ovm_report_info");
            this.verbosityDefaultValue = "OVM_MEDIUM";
        } else if (this.fOVMProject.getLibraryKind() == 2) {
            this.targetMethods.add("uvm_pkg::uvm_report_info");
            this.targetMethods.add("uvm_pkg::uvm_report_catcher.uvm_report_info");
            this.targetMethods.add("uvm_pkg::uvm_report_object.uvm_report_info");
            this.targetMethods.add("uvm_pkg::uvm_sequence_item.uvm_report_info");
            this.verbosityDefaultValue = "UVM_MEDIUM";
        }
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(null, new RfHidVisitor(){
            IRfNamedElement scope;

            public void setScope(IRfNamedElement scope) {
                this.scope = scope;
            }

            public boolean visit(RfHid hidObject) {
                if (!hidObject.isMethodCall(false)) {
                    return true;
                }
                if (Check_R_1406.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                Check_R_1406.this.notifyCheckAlive();
                IRfNamedElement element = hidObject.getElement();
                String hidFullName = LintUtils.getHidFullName((IHid)hidObject);
                if (!(element instanceof RfFunction)) {
                    return true;
                }
                if (!Check_R_1406.this.targetMethods.contains(hidFullName)) {
                    return true;
                }
                if (Check_R_1406.this.pCheckOnlyLoops && !this.isInLoop()) {
                    return true;
                }
                List methodCalls = MethodCallUtils.getMethodCalls((IHid)hidObject);
                for (MethodCall methodCall : methodCalls) {
                    RfHid rfHid;
                    IHidObject iHidObject;
                    if (methodCall.argumentValuesMapRaw == null || methodCall.argumentValuesMapRaw.isEmpty()) continue;
                    IHidObject value = null;
                    for (Map.Entry entry : methodCall.argumentValuesMapRaw.entrySet()) {
                        if (entry.getKey() == null || !((IRfFieldElement)entry.getKey()).getName().equals("verbosity")) continue;
                        value = (IHidObject)entry.getValue();
                        break;
                    }
                    if (value == null && Check_R_1406.this.pBannedVerbosity.contains(Check_R_1406.this.verbosityDefaultValue)) {
                        Check_R_1406.this.addHit(this.parserPath, hidObject, "Method '" + hidFullName + "' called with banned verbosity: '" + Check_R_1406.this.verbosityDefaultValue + "'!");
                    }
                    if (!((iHidObject = value) instanceof RfHid) || (rfHid = (RfHid)iHidObject) != (RfHid)iHidObject || !Check_R_1406.this.pBannedVerbosity.contains(rfHid.getName())) continue;
                    Check_R_1406.this.addHit(this.parserPath, hidObject, "Method '" + hidFullName + "' called with banned verbosity: '" + rfHid.getName() + "'!");
                }
                return true;
            }

            private boolean isInLoop() {
                if (this.scope == null || !(this.scope instanceof RfNamedElement)) {
                    return false;
                }
                RfNamedElement enclosingScope = (RfNamedElement)this.scope;
                while (enclosingScope instanceof RfActionBlock) {
                    if (((RfActionBlock)enclosingScope).isLoop()) {
                        return true;
                    }
                    enclosingScope = enclosingScope.getEnclosingScope();
                }
                return false;
            }
        });
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

