/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;
import ro.amiq.vlogdt.utils.Utils;

@CheckVersion(value="25.3.22")
@CheckID(value="R.1407")
@CheckName(value="R.1407")
@CheckLabel(labels={RuleLabel.MESSAGING, RuleLabel.METHOD, RuleLabel.BUILD_PHASE, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not use xvm_report_fatal method during build phase")
@CheckDescription(value="Do not use xvm_report_fatal method during build phase because it automatically causes a fatal error before entering run phase,\ntherefore, any further build errors would be hidden.\nUse xvm_report_error instead, as it allows phases after the build phase to continue.\n\nExample:\nvirtual function void build_phase(uvm_phase phase);\n  super.build_phase(phase);\n    uvm_report_fatal(\"ID\", \"error\"); // Not allowed\n    call_uvm_report_fatal();\n  endfunction : build_phase\n\n  function call_uvm_report_fatal();\n    uvm_report_fatal(\"ID\", \"error\"); // Also not allowed\n  endfunction\n\n  function other_function();\n    uvm_report_fatal(\"ID\", \"error\"); // Allowed\n  endfunction\n\nCheck supports pre-waiving.")
public class Check_R_1407
extends OVMComplianceCheck {
    private String xvmBuildPhaseMethodName;
    private Set<String> targetMethods;
    private Map<FileLineCall, List<DVTPair<RfFunction, String>>> callStacksForMethodCall;
    private Set<RfClass> visitedClasses;

    public Check_R_1407(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void configure() {
        super.configure();
        this.targetMethods = new HashSet<String>();
        this.xvmBuildPhaseMethodName = this.fOVMProject.getBuildPhaseMethodName();
        if (this.fOVMProject.getLibraryKind() == 1) {
            this.targetMethods.add("ovm_pkg::ovm_report_object.ovm_report_fatal");
            this.targetMethods.add("ovm_pkg::ovm_report_fatal");
        } else if (this.fOVMProject.getLibraryKind() == 2) {
            this.targetMethods.add("uvm_pkg::uvm_report_fatal");
            this.targetMethods.add("uvm_pkg::uvm_report_catcher.uvm_report_fatal");
            this.targetMethods.add("uvm_pkg::uvm_report_object.uvm_report_fatal");
            this.targetMethods.add("uvm_pkg::uvm_sequence_item.uvm_report_fatal");
        }
    }

    @Override
    public void performCheckImpl() {
        this.callStacksForMethodCall = new HashMap<FileLineCall, List<DVTPair<RfFunction, String>>>();
        this.visitedClasses = new HashSet<RfClass>();
        String XVMComponentName = String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg::")) + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_component");
        RfClass baseComponentClass = this.fOVMProject.getRfProject().getClass(XVMComponentName, true);
        if (baseComponentClass != null) {
            this.checkClass(baseComponentClass);
        }
        this.applyHits();
    }

    private void checkClass(RfClass currentClass) {
        Set<RfClass> classes;
        if (currentClass == null) {
            return;
        }
        if (this.visitedClasses.contains(currentClass)) {
            return;
        }
        this.visitedClasses.add(currentClass);
        RfFileDef file = currentClass.getFile();
        if (file == null) {
            return;
        }
        this.notifyCheckAlive();
        if (!this.fOVMProject.isOVMElement(currentClass) && !this.checkPreWaivers(file.getParserPath())) {
            RfFunction function = currentClass.getFunctionWithPrefix(this.xvmBuildPhaseMethodName, 1, 2, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            if (function == null || function.isEmpty()) {
                return;
            }
            HashSet<RfFunction> visitedFunctions = new HashSet<RfFunction>();
            ArrayList<DVTPair<RfFunction, String>> functionCallTree = new ArrayList<DVTPair<RfFunction, String>>();
            visitedFunctions.add(function);
            functionCallTree.add(new DVTPair((Object)function, (Object)""));
            function.visitHidObject(this.fOVMProject.getRfProject(), new FunctionHidVisitor(visitedFunctions, currentClass, functionCallTree));
        }
        if ((classes = currentClass.getChildren()) == null || classes.isEmpty()) {
            return;
        }
        for (RfClass eachClass : classes) {
            this.checkClass(eachClass);
        }
    }

    private void addCallStackInformation(ParserPath parserPath, RfHid hid, List<DVTPair<RfFunction, String>> callStack) {
        FileLineCall hidInformation = new FileLineCall(parserPath, hid.getOccurrence(), HidUtils.toNiceString((IHidObject)hid));
        if (this.callStacksForMethodCall.get(hidInformation) != null && this.callStacksForMethodCall.get(hidInformation).size() < callStack.size()) {
            return;
        }
        ArrayList<DVTPair> newList = new ArrayList<DVTPair>();
        for (DVTPair<RfFunction, String> element : callStack) {
            newList.add(new DVTPair((Object)((RfFunction)element.getKey()), (Object)((String)element.getValue())));
        }
        this.callStacksForMethodCall.put(hidInformation, newList);
    }

    private void applyHits() {
        for (Map.Entry<FileLineCall, List<DVTPair<RfFunction, String>>> hitInformation : this.callStacksForMethodCall.entrySet()) {
            ParserPath file = hitInformation.getKey().file();
            HidOccurrence methodCall = hitInformation.getKey().methodCall();
            String methodName = hitInformation.getKey().name();
            List<DVTPair<RfFunction, String>> smallestStack = hitInformation.getValue();
            this.addHit(file, methodCall, this.getFailMessage(methodName, smallestStack));
        }
    }

    protected String getFailMessage(String methodCall, List<DVTPair<RfFunction, String>> functionCallTree) {
        String message = String.valueOf(methodCall) + " is used during build phase!";
        StringBuilder callStack = new StringBuilder();
        int index = 0;
        for (DVTPair<RfFunction, String> pair : functionCallTree) {
            if (index == functionCallTree.size() - 1) break;
            callStack.append("\n" + index + ": ").append((String)pair.getValue());
            ++index;
        }
        if (callStack.length() != 0) {
            message = String.valueOf(message) + " Call stack: " + callStack.toString();
        }
        return message;
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    @Override
    public void clean() {
        super.clean();
        if (this.callStacksForMethodCall != null) {
            this.callStacksForMethodCall.clear();
        }
        if (this.visitedClasses != null) {
            this.visitedClasses.clear();
        }
    }

    private record FileLineCall(ParserPath file, HidOccurrence methodCall, String name) {
    }

    private final class FunctionHidVisitor
    extends RfHidVisitor {
        private ArrayList<DVTPair<RfFunction, String>> functionCallStack;
        private Set<RfFunction> visitedFunctions;
        private RfClass classScope;

        private FunctionHidVisitor(Set<RfFunction> visitedFunctions, RfClass classScope, ArrayList<DVTPair<RfFunction, String>> functionCallStack) {
            this.functionCallStack = functionCallStack;
            this.classScope = classScope;
            this.visitedFunctions = visitedFunctions;
        }

        public boolean visit(RfHid hidObject) {
            RfFunction tempFunction;
            if (!hidObject.isMethodCall(false)) {
                return true;
            }
            IRfNamedElement element = hidObject.getElement();
            if (!(element instanceof RfFunction) || element.isPredefined()) {
                return true;
            }
            if (Check_R_1407.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            String hidFullName = LintUtils.getHidFullName((IHid)hidObject);
            if (Check_R_1407.this.targetMethods.contains(hidFullName)) {
                Check_R_1407.this.addCallStackInformation(this.parserPath, hidObject, this.functionCallStack);
                return true;
            }
            RfFunction function = (RfFunction)element;
            if (Check_R_1407.this.fOVMProject.isOVMElement(function)) {
                return true;
            }
            RfClass methodCallScope = this.getMethodCallScope(hidObject);
            if (methodCallScope == null) {
                methodCallScope = this.classScope;
            }
            if (function.isVirtual() && (tempFunction = LintUtils.getValidVirtualFunction(function, hidObject, methodCallScope)) != null) {
                function = tempFunction;
            }
            if (this.visitedFunctions.contains(function)) {
                return true;
            }
            this.visitedFunctions.add(function);
            String message = this.getMessage(hidObject, function);
            this.functionCallStack.get(this.functionCallStack.size() - 1).setValue((Object)message);
            this.functionCallStack.add((DVTPair<RfFunction, String>)new DVTPair((Object)function, (Object)""));
            function.visitHidObject(Check_R_1407.this.fOVMProject.getRfProject(), new FunctionHidVisitor(this.visitedFunctions, methodCallScope, this.functionCallStack));
            this.functionCallStack.remove(this.functionCallStack.size() - 1);
            return true;
        }

        private RfClass getMethodCallScope(RfHid hidObject) {
            if (LintUtils.isSuper(hidObject)) {
                return null;
            }
            if (hidObject.getParentAccess() == null) {
                return null;
            }
            HidAccess parentAccess = hidObject.getParentAccess();
            if (parentAccess.getParentHid() == null) {
                return null;
            }
            Hid parentHid = parentAccess.getParentHid();
            if (!(parentHid instanceof RfHid)) {
                return null;
            }
            IRfNamedElement parentElement = parentHid.getElement();
            if (!(parentElement instanceof RfAssociatedType)) {
                return null;
            }
            RfNamedElement parentElementType = LintUtils.getAssociatedFinalType((RfAssociatedType)parentElement);
            if (parentElementType instanceof RfClass) {
                return (RfClass)parentElementType;
            }
            return null;
        }

        public String getMessage(RfHid hid, RfFunction function) {
            RfFunction caller = (RfFunction)this.functionCallStack.get(this.functionCallStack.size() - 1).getKey();
            String link = Check_R_1407.this.link(String.valueOf(Utils.getInstance().getFileName(this.parserPath.path)) + ":" + hid.getOccurrence().getLine(), this.parserPath.path, hid.getOccurrence().getLine());
            String message = String.valueOf(Check_R_1407.this.link(caller)) + "() - calls " + function + "() in " + link;
            return message;
        }

        @Override
        public Class<RfHid> getType() {
            return RfHid.class;
        }
    }
}

