/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import ro.amiq.dvt.diagrams.fsm.model.FSMModel;
import ro.amiq.dvt.fsm.convert.FSMConverter;
import ro.amiq.dvt.fsm.model.IFSMModel;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;

@CheckVersion(value="25.3.21")
@CheckID(value="R.1408")
@CheckName(value="R.1408")
@CheckLabel(labels={RuleLabel.NAME, RuleLabel.STYLING, RuleLabel.MODULE, RuleLabel.FSM})
@CheckTitle(value="FSM state variables naming pattern")
@CheckDescription(value="This rule checks the names of the variables used for changing FSM states.\nThe state variable must match the stateNamePattern.\nThe current state variable must match the currentStateNamePattern.\nThe next state variable must match the nextStateNamePattern.\n\nImplementation notes:\nFor FSM with no next state variable, only the state variable is checked.\n2-state FSM is not checked.\n\nCheck supports pre-waiving.")
public class Check_R_1408
extends OVMComplianceCheck {
    @CheckParameter(defaultValue=".*_state", description="", name="stateNamePatterns", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_REGEX)
    private Set<Pattern> pStateNamePattern;
    @CheckParameter(defaultValue=".*_current_state", description="", name="currentStateNamePatterns", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_REGEX)
    private Set<Pattern> pCurrentStateNamePattern;
    @CheckParameter(defaultValue=".*_next_state", description="", name="nextStateNamePatterns", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_REGEX)
    private Set<Pattern> pNextStateNamePattern;

    public Check_R_1408(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        NullProtectedList<RfNamedElement> allModules = this.fOVMProject.getAllModules();
        for (RfNamedElement module : allModules) {
            Map varWithModels;
            if (!(module instanceof RfModule)) continue;
            this.notifyCheckAlive();
            if (module.getFile() == null || this.checkPreWaivers(module.getFile().getParserPath()) || (varWithModels = FSMConverter.convert((IRfNamedElement)module, (int)4, (long)200L, (IProgressMonitor)new NullProgressMonitor())) == null || varWithModels.isEmpty()) continue;
            for (Map.Entry varWithModel : varWithModels.entrySet()) {
                boolean foundMatch;
                IRfFieldElement stateVar;
                IFSMModel fsmModel = (IFSMModel)varWithModel.getValue();
                if (!(fsmModel instanceof FSMModel) || !((stateVar = fsmModel.getStateVar()) instanceof RfField)) continue;
                IRfFieldElement nextStateVar = fsmModel.getNextStateVar();
                Collection states = ((FSMModel)fsmModel).getStates();
                if (states == null || states.isEmpty() || states.size() == 2) continue;
                String stateVarName = ((RfField)stateVar).getName();
                if (nextStateVar == null || nextStateVar.equals(stateVar)) {
                    foundMatch = false;
                    for (Pattern pattern : this.pStateNamePattern) {
                        if (!pattern.matcher(stateVarName).matches()) continue;
                        foundMatch = true;
                        break;
                    }
                    if (foundMatch) continue;
                    this.addHit((RfField)stateVar, "State variable name '" + LintUtils.getNamedElementFullName((RfField)stateVar) + "' does not match any of the specified patterns!");
                    continue;
                }
                foundMatch = false;
                for (Pattern pattern : this.pCurrentStateNamePattern) {
                    if (!pattern.matcher(stateVarName).matches()) continue;
                    foundMatch = true;
                    break;
                }
                if (!foundMatch) {
                    this.addHit((RfField)stateVar, "Current state variable name '" + LintUtils.getNamedElementFullName((RfField)stateVar) + "' does not match any of the specified patterns!");
                }
                if (!(nextStateVar instanceof RfField)) continue;
                String nextStateVarName = ((RfField)nextStateVar).getName();
                foundMatch = false;
                for (Pattern pattern : this.pNextStateNamePattern) {
                    if (!pattern.matcher(nextStateVarName).matches()) continue;
                    foundMatch = true;
                    break;
                }
                if (foundMatch) continue;
                this.addHit((RfField)nextStateVar, "Next state variable name '" + LintUtils.getNamedElementFullName((RfField)nextStateVar) + "' does not match any of the specified patterns!");
            }
        }
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

