/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedField;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="25.3.22")
@CheckID(value="R.1410")
@CheckName(value="R.1410")
@CheckLabel(labels={RuleLabel.MESSAGING, RuleLabel.METHOD, RuleLabel.FORMAT_SPECIFIER})
@CheckTitle(value="Do not use get_name() methods or %m with XVM report methods")
@CheckDescription(value="Do not use the XVM get_name() methods or $sformatf with a format string containing %m with XVM report methods as the report methods automatically print the full hierarchy.\n\nExamples:\nuvm_report_info(get_full_name(), \"some info message\", UVM_LOW) \t\t// not allowed\nuvm_report_info(\"ID\", $sformatf(\"some message %m\", obj), UVM_LOW) // not allowed\nuvm_report_info(\"ID\", $sformatf(\"some message \"), UVM_LOW) \t\t// allowed\n\nCheck supports pre-waiving.")
public class Check_R_1410
extends OVMComplianceCheck {
    private static final String SFORMATF = "$sformatf";
    @CheckParameter(defaultValue="get_full_name, get_name, get_type_name", description="Comma separated list of banned methods names.", name="bannedMethods", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected Set<String> pBannedMethods;
    private HashSet<String> reportMethods;
    private static String PATTERN_ARGUMENT = ".*[^%]%[mM].*";

    public Check_R_1410(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void configure() {
        super.configure();
        this.reportMethods = new HashSet();
        if (this.fOVMProject.getLibraryKind() == 1) {
            this.reportMethods.add("ovm_pkg::ovm_report_object.ovm_report_info");
            this.reportMethods.add("ovm_pkg::ovm_report_object.ovm_report_warning");
            this.reportMethods.add("ovm_pkg::ovm_report_object.ovm_report_error");
            this.reportMethods.add("ovm_pkg::ovm_report_object.ovm_report_fatal");
            this.reportMethods.add("ovm_pkg::ovm_report_info");
            this.reportMethods.add("ovm_pkg::ovm_report_warning");
            this.reportMethods.add("ovm_pkg::ovm_report_error");
            this.reportMethods.add("ovm_pkg::ovm_report_fatal");
        } else if (this.fOVMProject.getLibraryKind() == 2) {
            this.reportMethods.add("uvm_pkg::uvm_report_info");
            this.reportMethods.add("uvm_pkg::uvm_report_warning");
            this.reportMethods.add("uvm_pkg::uvm_report_error");
            this.reportMethods.add("uvm_pkg::uvm_report_fatal");
            this.reportMethods.add("uvm_pkg::uvm_report_catcher.uvm_report_info");
            this.reportMethods.add("uvm_pkg::uvm_report_catcher.uvm_report_warning");
            this.reportMethods.add("uvm_pkg::uvm_report_catcher.uvm_report_error");
            this.reportMethods.add("uvm_pkg::uvm_report_catcher.uvm_report_fatal");
            this.reportMethods.add("uvm_pkg::uvm_report_object.uvm_report_info");
            this.reportMethods.add("uvm_pkg::uvm_report_object.uvm_report_warning");
            this.reportMethods.add("uvm_pkg::uvm_report_object.uvm_report_error");
            this.reportMethods.add("uvm_pkg::uvm_report_object.uvm_report_fatal");
            this.reportMethods.add("uvm_pkg::uvm_sequence_item.uvm_report_info");
            this.reportMethods.add("uvm_pkg::uvm_sequence_item.uvm_report_warning");
            this.reportMethods.add("uvm_pkg::uvm_sequence_item.uvm_report_error");
            this.reportMethods.add("uvm_pkg::uvm_sequence_item.uvm_report_fatal");
            this.reportMethods.add("uvm_pkg::uvm_report_message.set_report_message");
        }
    }

    @Override
    public void performCheckImpl() {
        RfHidVisitor callVisitor = new RfHidVisitor(){

            public boolean visit(RfHid rfHid) {
                String fileName = LintUtils.getFileShortName(this.parserPath.path);
                if (Check_R_1410.this.fOVMProject.isOVMFile(fileName)) {
                    return true;
                }
                if (Check_R_1410.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                IRfNamedElement element = rfHid.getElement();
                if (element == null || !(element instanceof RfFunction)) {
                    return true;
                }
                Check_R_1410.this.notifyCheckAlive();
                if (!Check_R_1410.this.reportMethods.contains(LintUtils.getHidFullName((IHid)rfHid))) {
                    return true;
                }
                List methodCalls = MethodCallUtils.getMethodCalls((IHid)rfHid);
                if (methodCalls == null || methodCalls.isEmpty()) {
                    return true;
                }
                for (MethodCall methodCall : methodCalls) {
                    Map argumentValuesMapRaw = methodCall.argumentValuesMapRaw;
                    if (argumentValuesMapRaw == null || argumentValuesMapRaw.isEmpty()) continue;
                    ArrayList<IHidObject> values = new ArrayList<IHidObject>(argumentValuesMapRaw.values());
                    this.checkForBannedMethods(values, LintUtils.getNamedElementFullName((RfNamedElement)element));
                }
                return true;
            }

            private void checkForBannedMethods(List<IHidObject> hidObjects, String methodName) {
                Set hids = HidUtils.flattenToHids(hidObjects, (Set)HidFlatteningOption.IMPLICITS_AND_SELECT_OBJECTS_EXCLUDED);
                for (IHid hid : hids) {
                    List methodCalls;
                    RfHid rfHid;
                    IRfNamedElement element;
                    if (!(hid instanceof RfHid) || (element = (rfHid = (RfHid)hid).getElement()) == null || !(element instanceof RfFunction)) continue;
                    RfFunction function = (RfFunction)element;
                    if (Check_R_1410.this.pBannedMethods.contains(function.getName())) {
                        Hid parentAccess = rfHid.getParentHid();
                        if (parentAccess != null && !"this".equals(parentAccess.getName())) continue;
                        Check_R_1410.this.addHit(this.parserPath, rfHid, "Do not use '" + LintUtils.getNamedElementFullName(function) + "()' in the arguments of " + methodName + "!");
                        continue;
                    }
                    if (!function.getName().equals(Check_R_1410.SFORMATF) || (methodCalls = MethodCallUtils.getMethodCalls((IHid)rfHid)) == null || methodCalls.isEmpty()) continue;
                    for (MethodCall methodCall : methodCalls) {
                        String nameValue;
                        Iterator iterator;
                        Map.Entry formatString;
                        Map argumentValuesMapRaw = methodCall.argumentValuesMapRaw;
                        if (argumentValuesMapRaw == null || argumentValuesMapRaw.isEmpty() || !((formatString = (iterator = argumentValuesMapRaw.entrySet().iterator()).next()).getKey() instanceof RfPredefinedField) || !((IRfFieldElement)formatString.getKey()).getName().equals("format_string") || !(formatString.getValue() instanceof RfHidImplicit) || !(nameValue = ((RfHidImplicit)formatString.getValue()).getName()).matches(PATTERN_ARGUMENT)) continue;
                        Check_R_1410.this.addHit(this.parserPath, rfHid, "Do not use '$sformatf(\"%m\")' in the arguments of " + methodName + "!");
                    }
                }
            }
        };
        this.fOVMProject.getRfProject().visitHidObject(null, callVisitor);
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

