/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.text.MessageFormat;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfConstraint;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="25.3.22")
@CheckID(value="R.1411")
@CheckName(value="R.1411")
@CheckLabel(labels={RuleLabel.CONCATENATION, RuleLabel.CONSTRAINT, RuleLabel.FUNCTIONAL})
@CheckTitle(value="Do not use concatenations of multiple elements where constraint sets are expected")
@CheckDescription(value="This rule flags usages of multiple element concatenations where constraint sets are expected inside constraints.\nConcatenations of multiple elements can easily be confused for constraint sets.\nUsing such concatenations where constraint sets are expected will only use one of the elements of the concatenation as a constraint, not all of them.\nThis will ensure the constraint behaves as intended.\n\nExamples:\n\nconstraint concatenation_constraint {\n\tif (a == 0) {b == 1, c == 2};\t\t// not allowed\n}\n\nconstraint set_constraint {\n\tif (a == 0) {b == 1; c == 2;}\t\t// allowed\n}\n\nCheck supports pre-waiving.")
public class Check_R_1411
extends OVMComplianceCheck {
    private static final String ERROR_MESSAGE = "Concatenation of multiple elements: {0} found where a constraint set is expected in {1}!";

    public Check_R_1411(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null) {
            return;
        }
        RfConstraint[] allConstraints = rfProject.getAllConstraints();
        if (allConstraints != null && allConstraints.length > 0) {
            RfConstraint[] rfConstraintArray = allConstraints;
            int n = allConstraints.length;
            int n2 = 0;
            while (n2 < n) {
                RfConstraint constraint = rfConstraintArray[n2];
                constraint.visitHidObject(rfProject, (IHidVisitor<?>)new ConstraintVisitor(null, constraint));
                ++n2;
            }
        }
        this.fOVMProject.getRfProject().visitHidObject(this.fOVMProject.getRfProject(), (IHidVisitor<?>)new HidOperatorVisitor(null){

            public boolean visit(HidOperator operator) {
                if (!operator.isWithClauseConstraint()) {
                    return true;
                }
                IHidObject constraint = operator.getLHValue();
                constraint.visitHidObject((IRfSingleLangProject)Check_R_1411.this.fOVMProject.getRfProject(), (IHidVisitor)new ConstraintVisitor(null, null, this.parserPath));
                return true;
            }
        });
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private class ConstraintVisitor
    extends HidOperatorVisitor {
        private RfConstraint constraint;

        public ConstraintVisitor(HidOperatorQualifier[] qualifiers, RfConstraint constraint) {
            super(qualifiers);
            this.constraint = constraint;
        }

        public ConstraintVisitor(HidOperatorQualifier[] qualifiers, RfConstraint constraint, ParserPath parserPath) {
            super(qualifiers);
            this.constraint = constraint;
            this.parserPath = parserPath;
        }

        public boolean visit(HidOperator operator) {
            if (Check_R_1411.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            if (!operator.isIfElseStatement() && !operator.isForeachStatement()) {
                return true;
            }
            Check_R_1411.this.notifyCheckAlive();
            ListContainer rhValues = operator.getRHValues();
            for (IHidObject rhValue : rhValues) {
                ListContainer concatenationElements;
                RfHidOperator rhOperator;
                if (!(rhValue instanceof RfHidOperator) || !(rhOperator = (RfHidOperator)rhValue).isVLOGConcatenation(false) || (concatenationElements = rhOperator.getRHValues()) == null || concatenationElements.size() < 2) continue;
                Check_R_1411.this.addHit(this.parserPath, (HidOccurrence)rhOperator.getOccurrence(), MessageFormat.format(Check_R_1411.ERROR_MESSAGE, HidUtils.toNiceString((IHidObject)rhOperator), this.constraint != null ? "constraint " + this.constraint.getName() : "inline constraint"), true);
            }
            return true;
        }
    }
}

