/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractCaseCheck;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;

@CheckVersion(value="26.1.1")
@CheckID(value="R.1412")
@CheckName(value="R.1412")
@CheckLabel(labels={RuleLabel.OPERATOR})
@CheckTitle(value="Only use casez")
@CheckDescription(value="Do not use case or casex statements, use casez instead.\n\nExamples:\n\ncasex (c) // not allowed\n    1: $display(\"1\");\n    2: $display(\"2\");\n    3: $display(\"3\");\n    default: $display(\"default\");\nendcase\n\ncase (c) // not allowed\n    1: $display(\"1\");\n    2: $display(\"2\");\n    3: $display(\"3\");\n    default: $display(\"default\");\nendcase\n\ncasez (c) // allowed\n    1: $display(\"1\");\n    2: $display(\"2\");\n    3: $display(\"3\");\n    default: $display(\"default\");\nendcase\n\nCheck supports pre-waiving.")
public class Check_R_1412
extends AbstractCaseCheck {
    public Check_R_1412(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected void checkCaseBlock(RfActionBlock caseBlock) {
        if (caseBlock.isCasex()) {
            this.addHit(caseBlock, "Banned usage of casex statement, use casez instead!");
        } else if (caseBlock.isSimpleCase()) {
            this.addHit(caseBlock, "Banned usage of case statement, use casez instead!");
        }
    }
}

