/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractCaseCheck;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;

@CheckVersion(value="26.1.1")
@CheckID(value="R.1413")
@CheckName(value="R.1413")
@CheckLabel(labels={RuleLabel.OPERATOR})
@CheckTitle(value="Case statements must have priority or unique")
@CheckDescription(value="Case statements without the priority or unique qualifiers might cause ambiguity for overlapping cases or values not matching any case.\n\nExamples:\n\ncase (c) // not allowed\n  [...]\nendcase\n\nunique case (c) // allowed\n  [...]\nendcase\n\npriority case (c) // allowed\n  [...]\nendcase\n\nCheck supports pre-waiving.")
public class Check_R_1413
extends AbstractCaseCheck {
    public Check_R_1413(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected void checkCaseBlock(RfActionBlock caseBlock) {
        if (!caseBlock.isCase()) {
            return;
        }
        if (!caseBlock.isUnique() && !caseBlock.isPriority()) {
            this.addHit(caseBlock, "Case statement without unique or priority!");
        }
    }
}

