/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="26.1.2")
@CheckID(value="R.1414")
@CheckName(value="R.1414")
@CheckLabel(labels={RuleLabel.CONSTRAINT, RuleLabel.RANDOMIZATION, RuleLabel.ARRAY, RuleLabel.PREDEFINED_METHOD})
@CheckTitle(value="Do not constrain the size of associative arrays")
@CheckDescription(value="Acording to section 18.4 of the LRM, it's not allowed to constrain the size of an associative array.\n\nExample:\nrand integer arr[int];\n\nconstraint constraint_name {\n    arr.size() == 10;             // NOT ALLOWED\n}\n\nCheck supports pre-waiving.")
public class Check_R_1414
extends OVMComplianceCheck {
    public Check_R_1414(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement constraint : this.fOVMProject.getAllConstraints()) {
            RfDefElement declaration = constraint.getDeclaration();
            if (declaration != null && this.fOVMProject.getProjectWaivers().pathIsPrewaived(declaration.getParserPath(), this)) continue;
            this.notifyCheckAlive();
            constraint.visitHidObject(null, (IHidVisitor<?>)new ConstraintVisitor(null));
        }
        this.fOVMProject.getRfProject().visitHidObject(this.fOVMProject.getRfProject(), (IHidVisitor<?>)new HidOperatorVisitor(null){

            /*
             * WARNING - void declaration
             */
            public boolean visit(HidOperator operator) {
                void constraintOperator;
                IHidObject constraint;
                if (!operator.isWithClauseConstraint()) {
                    return true;
                }
                if (Check_R_1414.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                Check_R_1414.this.notifyCheckAlive();
                IHidObject iHidObject = constraint = operator.getLHValue();
                if (!(iHidObject instanceof RfHidOperator var3_4)) {
                    return true;
                }
                ListContainer rhValues = constraintOperator.getRHValues();
                if (rhValues == null) {
                    return true;
                }
                ConstraintVisitor visitor = new ConstraintVisitor(null);
                visitor.setParserPath(this.parserPath);
                for (IHidObject rhOperator : rhValues) {
                    rhOperator.visitHidObject((IRfSingleLangProject)Check_R_1414.this.fOVMProject.getRfProject(), (IHidVisitor)visitor);
                }
                return true;
            }
        });
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private class ConstraintVisitor
    extends HidOperatorVisitor {
        public ConstraintVisitor(HidOperatorQualifier[] qualifiers) {
            super(qualifiers);
        }

        public boolean visit(HidOperator operator) {
            HidOperator hidOperator = operator;
            if (!(hidOperator instanceof RfHidOperator) || (var2_3 = (RfHidOperator)hidOperator) != (RfHidOperator)var3_2) {
                return true;
            }
            if (hidOperator.getOperatorKind() != IHidOperatorConstants.OperatorKind.BINARY_OPERATOR) {
                return true;
            }
            if (!(hidOperator.isEqualityOrInequality() || hidOperator.isLessThan() || hidOperator.isGreaterThan() || hidOperator.isLessThanOrEqual() || hidOperator.isGreaterThanOrEqual() || hidOperator.isInside() || hidOperator.isDistribution())) {
                return true;
            }
            IHidObject lhValue = hidOperator.getLHValue();
            if (lhValue instanceof RfHidAccess var5_6) {
                this.checkHid((RfHidAccess)lhHid);
            }
            if (( instanceOfPatternExpressionValue = (rhValue = hidOperator.getFirstRHValue())) instanceof RfHidAccess && (var8_9 = (RfHidAccess) instanceOfPatternExpressionValue) == (RfHidAccess) instanceOfPatternExpressionValue) {
                this.checkHid((RfHidAccess)rhHid);
            }
            return true;
        }

        private void checkHid(RfHidAccess hidAccess) {
            Hid hidobject = hidAccess.getParentHid();
            Hid hid = hidobject;
            if (!(hid instanceof RfHid) || (var3_4 = (RfHid)hid) != (RfHid)hid || !hid.isMethodCall(false)) {
                return;
            }
            IRfNamedElement element = hid.getElement();
            if (!(element instanceof RfPredefinedFunction var6_7)) {
                return;
            }
            if (!"size".equals(predefinedFunction.getName())) {
                return;
            }
            Hid parentHid = hid.getParentHid();
            if (parentHid == null) {
                return;
            }
            IRfNamedElement parentElement = parentHid.getElement();
            if (!(parentElement instanceof RfField var10_11)) {
                return;
            }
            IRfNamedElement fieldType = parentField.getAssociatedType();
            if (fieldType instanceof RfListType var13_14 && list.isAssociativeArray()) {
                Check_R_1414.this.addHit(this.parserPath, (RfHid)hid, "Illegal size constrain for associative array '" + LintUtils.getNamedElementFullName((RfNamedElement)parentField));
            }
        }
    }
}

