/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.ruleset;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.SAXParseException;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.XMLException;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.api.impl.APIUtils;
import ro.amiq.vlogdt.linter.ruleset.RulesetCategoryModel;
import ro.amiq.vlogdt.linter.ruleset.RulesetKind;
import ro.amiq.vlogdt.linter.ruleset.RulesetModel;
import ro.amiq.vlogdt.linter.ruleset.RulesetXMLParser;
import ro.amiq.vlogdt.linter.utils.OVMUtils;

public class DefaultRuleset {
    public static List<RulesetCategoryModel> getFor(OVMProject ovmProject) {
        ArrayList<RulesetCategoryModel> categories = new ArrayList<RulesetCategoryModel>();
        RulesetKind rulesetKind = ovmProject.getConfiguration().getRulesetKind();
        if (!APIUtils.isDebugCustomRules()) {
            return DefaultRuleset.getForRulesetKind(rulesetKind, ovmProject, null);
        }
        return categories;
    }

    public static void addChecksToIncludedCategory(OVMProject ovmProject, RulesetCategoryModel parentCategory) {
        RulesetKind rulesetKind = ovmProject.getLibraryKind() == 2 ? RulesetKind.VERISSIMO_ALL_UVM : RulesetKind.VERISSIMO_ALL_OVM;
        DefaultRuleset.getForRulesetKind(rulesetKind, ovmProject, parentCategory);
    }

    private static List<RulesetCategoryModel> getForRulesetKind(RulesetKind rulesetKind, OVMProject ovmProject, RulesetCategoryModel parentCategory) {
        List<RulesetCategoryModel> categories = new ArrayList<RulesetCategoryModel>();
        URL url = null;
        url = rulesetKind == RulesetKind.CUSTOM ? OVMUtils.getDefaultRulesetURL(RulesetKind.getFullRulesetFor(ovmProject.getLibraryKind() == 2 ? "uvm" : "ovm")) : OVMUtils.getDefaultRulesetURL(rulesetKind);
        try {
            RulesetXMLParser parser = RulesetXMLParser.newParser(ovmProject, url, true);
            RulesetModel model = parser.load(parentCategory);
            categories = model.getCategories();
        }
        catch (SAXParseException e) {
            throw new XMLException((Throwable)e, url.getFile());
        }
        catch (XMLException e) {
            throw e;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return categories;
    }
}

