/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.ruleset;

import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.ruleset.ErrorCheck;

public class DuplicateNameErrorCheck
extends ErrorCheck {
    private final String fRulename;
    public static final String ID = "DUPLICATE_NAME_ERROR";

    public DuplicateNameErrorCheck(OVMProject oVMProject, OVMComplianceCategory category, String name) {
        super(oVMProject, category);
        this.fRulename = name;
        this.setName(null);
        this.setTitle(null);
        this.setDescription(null);
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public void setName(String name) {
        if (this.fRulename == null) {
            super.setName("?");
        } else if (name == null) {
            super.setName(this.getDefaultName());
        } else {
            super.setName(String.valueOf(name) + " (?)");
        }
    }

    @Override
    public void setTitle(String title) {
        if (this.fRulename == null) {
            super.setTitle("Nonexistent ID used");
        } else {
            super.setTitle(this.getDefaultTitle());
        }
    }

    @Override
    public void setDescription(String description) {
        if (this.fRulename == null) {
            super.setDescription("Rule ID doesn't exist. Rule is disabled!");
        } else {
            super.setDescription(this.getDefaultDescription());
        }
    }

    @Override
    public String getDefaultName() {
        return String.valueOf(this.fRulename) + " (?)";
    }

    @Override
    public String getDefaultDescription() {
        return "Rule with name '" + this.fRulename + "' already exists in rulepool!  Rule is disabled!";
    }

    @Override
    public String getDefaultTitle() {
        return "Duplicated rule name '" + this.fRulename + "'";
    }

    @Override
    public boolean isEnabled() {
        return false;
    }

    @Override
    public void performCheckImpl() {
    }
}

