/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.ruleset;

import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.ruleset.ErrorCheck;

public class NonExistentIdErrorCheck
extends ErrorCheck {
    public static final String ID = "NONEXISTENT_ID_ERROR";
    private final String fNonExistentID;

    public NonExistentIdErrorCheck(OVMProject oVMProject, OVMComplianceCategory category, String id) {
        super(oVMProject, category);
        this.fNonExistentID = id;
        this.setName(null);
        this.setTitle(null);
        this.setDescription(null);
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public void setName(String name) {
        if (this.fNonExistentID == null) {
            super.setName("?");
        } else if (name == null) {
            super.setName(this.getDefaultName());
        } else {
            super.setName(String.valueOf(name) + " (?)");
        }
    }

    @Override
    public void setTitle(String title) {
        if (this.fNonExistentID == null) {
            super.setTitle("Nonexistent ID used");
        } else {
            super.setTitle(this.getDefaultTitle());
        }
    }

    @Override
    public void setDescription(String description) {
        if (this.fNonExistentID == null) {
            super.setDescription("Rule ID doesn't exist. Rule is disabled!");
        } else {
            super.setDescription(this.getDefaultDescription());
        }
    }

    @Override
    public String getDefaultName() {
        return String.valueOf(this.fNonExistentID) + " (?)";
    }

    @Override
    public String getDefaultDescription() {
        return "Rule with ID '" + this.fNonExistentID + "' doesn't exist. Rule is disabled!";
    }

    @Override
    public String getDefaultTitle() {
        return "Nonexistent rule ID " + this.fNonExistentID;
    }

    @Override
    public boolean isEnabled() {
        return false;
    }

    @Override
    public void performCheckImpl() {
    }
}

