/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.ruleset;

import java.util.ArrayList;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.api.impl.CustomRulesLoader;
import ro.amiq.vlogdt.linter.api.impl.InternalCustomRulesLoader;
import ro.amiq.vlogdt.linter.ruleset.InternalRulesLoader;
import ro.amiq.vlogdt.linter.ruleset.NonExistentIdErrorCheck;

public enum RuleFactory {
    INSTANCE;

    private final InternalRulesLoader fInternalRulesLoader = new InternalRulesLoader();
    private final InternalCustomRulesLoader fInternalCustomRulesLoader = new InternalCustomRulesLoader();
    private final CustomRulesLoader fCustomRulesLoader;

    private RuleFactory() {
        ArrayList<String> existingIDs = new ArrayList<String>();
        existingIDs.addAll(this.fInternalRulesLoader.getIDs());
        existingIDs.addAll(this.fInternalCustomRulesLoader.getIDs());
        this.fCustomRulesLoader = new CustomRulesLoader(existingIDs);
    }

    public OVMComplianceCheck createRule(String id, OVMProject ovmProject, OVMComplianceCategory category) {
        OVMComplianceCheck rule = null;
        rule = this.fInternalRulesLoader.createRule(id, ovmProject, category);
        if (rule == null) {
            rule = this.fInternalCustomRulesLoader.createRule(id, ovmProject, category);
        }
        if (rule == null) {
            rule = this.fCustomRulesLoader.createRule(id, ovmProject, category);
        }
        if (rule == null) {
            rule = new NonExistentIdErrorCheck(ovmProject, category, id);
        }
        return rule;
    }

    public ArrayList<OVMComplianceCategory> getCustomRulesCategory(OVMProject ovmProject) {
        return this.fCustomRulesLoader.getCustomRulesCategory(ovmProject);
    }
}

