/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.ruleset;

import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xml.sax.SAXParseException;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.dvt.utils.XMLException;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.api.impl.CustomRulesTestRuleset;
import ro.amiq.vlogdt.linter.ruleset.DefaultRuleset;
import ro.amiq.vlogdt.linter.ruleset.RuleFactory;
import ro.amiq.vlogdt.linter.ruleset.RulesetCategoryModel;
import ro.amiq.vlogdt.linter.ruleset.RulesetComponent;
import ro.amiq.vlogdt.linter.ruleset.RulesetConfiguration;
import ro.amiq.vlogdt.linter.ruleset.RulesetConvertor;
import ro.amiq.vlogdt.linter.ruleset.RulesetKind;
import ro.amiq.vlogdt.linter.ruleset.RulesetModel;
import ro.amiq.vlogdt.linter.ruleset.RulesetXMLParser;
import ro.amiq.vlogdt.linter.utils.OVMUtils;

public class Ruleset {
    private OVMProject fOVMProject;
    private File fFile;

    public void initialize(OVMProject project) throws IllegalArgumentException {
        this.fOVMProject = project;
        if (this.fOVMProject == null) {
            throw new IllegalArgumentException("OVMProject can't be null");
        }
        if (this.fOVMProject.getProject() == null) {
            throw new IllegalArgumentException("IProject can't be null");
        }
        this.fFile = this.fOVMProject.getConfiguration().getRulesetFile();
    }

    private RulesetModel loadFromFile() {
        RulesetModel rulesetModel = null;
        if (this.fOVMProject == null || this.fFile == null) {
            return null;
        }
        if (!this.fFile.exists()) {
            return null;
        }
        LinkedHashMap<String, RulesetXMLParser> fileParsersMap = new LinkedHashMap<String, RulesetXMLParser>();
        LinkedHashMap<String, List<String>> inexistentFiles = new LinkedHashMap<String, List<String>>();
        LinkedHashMap<String, List<String>> invalidSinces = new LinkedHashMap<String, List<String>>();
        RulesetXMLParser.resetUnresolvedVariables();
        String canonicalPath = RulesetXMLParser.resolvePath(this.fFile.toURI().getPath(), null, false);
        RulesetXMLParser mainParser = RulesetXMLParser.createParsers(fileParsersMap, this.fOVMProject, canonicalPath, null, inexistentFiles, invalidSinces);
        Map<String, List<String>> unresolvedVariables = RulesetXMLParser.getUnresolvedVariables();
        OVMUtils.parseProblem(this.fOVMProject.getProject(), unresolvedVariables, "unresolved environment variables", true, true);
        OVMUtils.parseProblem(this.fOVMProject.getProject(), inexistentFiles, "non existent files", true, true);
        OVMUtils.parseProblem(this.fOVMProject.getProject(), invalidSinces, "invalid since format (valid date format is yyyy-MM-dd, valid version format is MM.M.m)", true, true);
        try {
            rulesetModel = this.createModel(mainParser);
            if (rulesetModel != null && rulesetModel.getCategories().isEmpty() && this.fOVMProject.getConfiguration().getRulesetKind() == RulesetKind.CUSTOM) {
                String message = mainParser.getIncludedParsers().isEmpty() ? "No 'category' elements detected in this ruleset!" : "No 'category' elements detected in either this ruleset or included ones!";
                SAXParseException exception = new SAXParseException(message, this.fFile.getAbsolutePath(), this.fFile.getAbsolutePath(), 0, 0);
                throw new XMLException((Throwable)exception, this.fFile.getAbsolutePath());
            }
        }
        catch (XMLException e) {
            throw e;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return rulesetModel;
    }

    private RulesetModel createModel(RulesetXMLParser parser) throws Exception {
        if (parser == null) {
            return null;
        }
        RulesetModel modelResult = new RulesetModel();
        Map<RulesetXMLParser, Integer> includedParsersMap = parser.getIncludedParsers();
        for (Map.Entry<RulesetXMLParser, Integer> includedParser : includedParsersMap.entrySet()) {
            RulesetModel model = this.createModel(includedParser.getKey());
            Integer line = includedParser.getValue();
            model.getCategories().forEach(category -> category.setOrderIndex(line));
            modelResult.addConfiguration(model.getConfiguration(), this.fFile.getAbsolutePath());
            modelResult.addCategories(model.getCategories());
        }
        RulesetModel load = parser.load(null);
        modelResult.addConfiguration(load.getConfiguration(), this.fFile.getAbsolutePath());
        modelResult.addCategories(load.getCategories());
        modelResult.getCategories().sort((c1, c2) -> Integer.compare(c1.getOrderIndex(), c2.getOrderIndex()));
        return modelResult;
    }

    public void load() {
        ArrayList<OVMComplianceCheck> projectChecks = this.fOVMProject.getChecks();
        ArrayList<OVMComplianceCategory> projectCategories = this.fOVMProject.getComplianceCategories();
        RulesetConfiguration rulesetConfiguration = this.fOVMProject.getRulesetConfiguration();
        for (OVMComplianceCheck check : projectChecks) {
            check.clean();
        }
        projectChecks.clear();
        projectCategories.clear();
        RulesetModel rulesetModel = null;
        List<OVMComplianceCategory> rulesetCategories = null;
        RulesetKind rulesetKind = this.fOVMProject.getConfiguration().getRulesetKind();
        if (CustomRulesTestRuleset.isSet()) {
            rulesetCategories = CustomRulesTestRuleset.load(this.fOVMProject);
        } else {
            rulesetModel = this.loadFromFile();
            if (rulesetModel != null) {
                List<RulesetCategoryModel> categoriesModels;
                Map<String, DVTPair<Integer, Integer>> threadDumpRules = null;
                Set<String> histogramDumpRules = null;
                RulesetConfiguration configuration = rulesetModel.getConfiguration();
                if (configuration != null) {
                    if (configuration.getArchitecture() != null) {
                        List<RulesetComponent> components = configuration.getArchitecture().getComponents();
                        Enum duplicate = null;
                        EnumSet<RulesetComponent.ComponentType> seen = EnumSet.noneOf(RulesetComponent.ComponentType.class);
                        for (RulesetComponent obj : components) {
                            if (seen.add(obj.getType())) continue;
                            duplicate = obj.getType();
                            break;
                        }
                        if (duplicate != null) {
                            SAXParseException exception = new SAXParseException("Duplicate configuration component with the same type " + duplicate.toString() + "!", this.fFile.getAbsolutePath(), this.fFile.getAbsolutePath(), 0, 0);
                            throw new XMLException((Throwable)exception, this.fFile.getAbsolutePath());
                        }
                    }
                    rulesetConfiguration.setArchitecture(configuration.getArchitecture());
                    rulesetConfiguration.setSkipFiles(configuration.getSkipFiles());
                    rulesetConfiguration.setSkipElements(configuration.getSkipElements());
                    rulesetConfiguration.setAnnotationManager(configuration.getAnnotationManager());
                    rulesetConfiguration.setIncludeHTMLCode(configuration.getIncludeHTMLCode());
                    rulesetConfiguration.setIncludeCreationDate(configuration.getIncludeCreationDate());
                    rulesetConfiguration.setHasEffortEstimation(configuration.getHasEffortEstimation());
                    rulesetConfiguration.setSessionTimeout(configuration.getSessionTimeout());
                    rulesetConfiguration.setProcessTimeout(configuration.getProcessTimeout());
                    threadDumpRules = configuration.getThreadDumpRules();
                    histogramDumpRules = configuration.getHistogramDumpRules();
                }
                if ((categoriesModels = rulesetModel.getCategories()) != null) {
                    rulesetCategories = RulesetConvertor.convertModelToCategories(this.fOVMProject, categoriesModels, threadDumpRules, histogramDumpRules);
                }
                rulesetModel.clean();
            }
            if (rulesetCategories == null && rulesetKind == RulesetKind.CUSTOM) {
                SAXParseException exception = new SAXParseException("There was an error reading the XML file, no rules detected!", this.fFile.getAbsolutePath(), this.fFile.getAbsolutePath(), 0, 0);
                throw new XMLException((Throwable)exception, this.fFile.getAbsolutePath());
            }
        }
        if (rulesetCategories == null) {
            rulesetCategories = RulesetConvertor.convertModelToCategories(this.fOVMProject, DefaultRuleset.getFor(this.fOVMProject), null, null);
            rulesetCategories.addAll(RuleFactory.INSTANCE.getCustomRulesCategory(this.fOVMProject));
        }
        projectCategories.addAll(rulesetCategories);
        for (OVMComplianceCategory category : projectCategories) {
            ArrayList<OVMComplianceCheck> checks = category.getChecks();
            if (checks == null) continue;
            for (OVMComplianceCheck check : checks) {
                check.configure();
                projectChecks.add(check);
            }
        }
    }

    public File getRulesetFile() {
        return this.fFile;
    }

    public void setRulesetFile(File rulesetFile) {
        this.fFile = rulesetFile;
    }
}

