/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.ruleset;

import java.util.ArrayList;
import java.util.Date;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.ruleset.RulesetCheckModel;

public class RulesetCategoryModel {
    private String fName;
    private String fDescription;
    private int fOrderIndex;
    private List<RulesetCheckModel> fCheckModels;
    private Map<FilterField, Predicate<OVMComplianceCheck>> fFiltersMap;

    public RulesetCategoryModel(String name, String description, int line) {
        this(name, description, line, new EnumMap<FilterField, Predicate<OVMComplianceCheck>>(FilterField.class));
    }

    public RulesetCategoryModel(String name, String description, int line, Map<FilterField, Predicate<OVMComplianceCheck>> filtersMap) {
        this.fName = name;
        this.fDescription = description;
        this.fOrderIndex = line;
        this.fCheckModels = new ArrayList<RulesetCheckModel>();
        this.fFiltersMap = filtersMap;
    }

    public String getName() {
        return this.fName;
    }

    public String getDescription() {
        return this.fDescription;
    }

    public int getOrderIndex() {
        return this.fOrderIndex;
    }

    public void setOrderIndex(int orderIndex) {
        this.fOrderIndex = orderIndex;
    }

    public List<RulesetCheckModel> getCheckModels() {
        return this.fCheckModels;
    }

    public void addCheckModel(RulesetCheckModel ruleModel) {
        this.fCheckModels.add(ruleModel);
    }

    public Map<FilterField, Predicate<OVMComplianceCheck>> getFiltersMap() {
        return this.fFiltersMap;
    }

    public void setFiltersMap(Map<FilterField, Predicate<OVMComplianceCheck>> filtersMap) {
        this.fFiltersMap = filtersMap;
    }

    public void addFilterField(FilterField field, Predicate<OVMComplianceCheck> value) {
        this.fFiltersMap.put(field, value);
    }

    public void clean() {
        if (this.fFiltersMap != null) {
            this.fFiltersMap.clear();
        }
        if (this.fCheckModels != null) {
            this.fCheckModels.forEach(check -> check.clean());
            this.fCheckModels.clear();
        }
    }

    public static enum FilterField {
        DATE(Date.class),
        VERSION(String.class),
        LABEL(RuleLabel.class);

        private final Class<?> type;

        private FilterField(Class<?> type) {
            this.type = type;
        }

        public Class<?> getType() {
            return this.type;
        }
    }
}

