/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.ruleset;

import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;
import org.xml.sax.SAXParseException;
import ro.amiq.dvt.utils.XMLException;
import ro.amiq.vlogdt.linter.CheckStatus;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.ruleset.RulesetCategoryModel;

public abstract class RulesetCheckModel {
    private String name;
    private String title;
    private String description;
    private String descriptionAppend;
    private Boolean autoCorrectEnabled;
    private Boolean autoCorrectSkipSanityChecks;
    private CheckStatus severity;
    private String includePrewaiver;
    private String excludePrewaiver;
    private Integer timeout;
    private Integer effort;
    private Map<String, String> properties;
    private Map<String, String> propertiesAppend;
    private Map<String, String> autocorrectInputs;
    private int line;
    private Element element;
    private String filePath;
    private RulesetCategoryModel categoryModel;

    protected RulesetCheckModel(Element element, RulesetCategoryModel categoryModel) {
        this.categoryModel = categoryModel;
        this.element = element;
        this.properties = new HashMap<String, String>();
        this.propertiesAppend = new HashMap<String, String>();
        this.autocorrectInputs = new HashMap<String, String>();
    }

    public abstract OVMComplianceCheck applyToCheck(OVMProject var1, OVMComplianceCategory var2, OVMComplianceCheck var3);

    protected OVMComplianceCheck applyToCheck(OVMComplianceCheck check) {
        if (this.name != null) {
            check.setName(this.name);
        }
        if (this.title != null) {
            check.setTitle(this.title);
        }
        if (this.description != null) {
            check.setDescription(this.description);
        }
        if (this.descriptionAppend != null) {
            check.setDescriptionAppend(this.descriptionAppend);
        }
        if (this.severity != null) {
            check.setSeverity(this.severity);
        }
        check.setRulesetEnabled(this.severity != CheckStatus.DISABLED);
        if (this.effort != null) {
            check.setEffort(this.effort);
        }
        if (this.timeout != null) {
            check.setTimeout(this.timeout);
        }
        if (!check.isAutocorrectable()) {
            if (this.autoCorrectEnabled != null && this.autoCorrectEnabled.booleanValue() || this.autoCorrectSkipSanityChecks != null && this.autoCorrectSkipSanityChecks.booleanValue()) {
                SAXParseException exception = new SAXParseException("Check '" + check.getName() + "' does not support autocorrecting", this.getFilePath(), this.getFilePath(), this.getLine(), 0);
                throw new XMLException((Throwable)exception, this.getFilePath());
            }
        } else {
            if (this.autoCorrectEnabled != null) {
                check.setAutoCorrectEnabled(this.autoCorrectEnabled);
            }
            if (this.autoCorrectSkipSanityChecks != null) {
                check.setAutoCorrectSkipSanityChecks(this.autoCorrectSkipSanityChecks);
            }
        }
        check.setPreWaiver(this.includePrewaiver, this.excludePrewaiver);
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            if (!check.isValidParameter(entry.getKey())) {
                SAXParseException exception = new SAXParseException("Element '" + this.element.getNodeName() + "' contains parameter with invalid key '" + entry.getKey() + "'", this.getFilePath(), this.getFilePath(), this.getLine(), 0);
                throw new XMLException((Throwable)exception, this.getFilePath());
            }
            check.setProperty(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : this.propertiesAppend.entrySet()) {
            if (!check.isValidParameter(entry.getKey())) {
                SAXParseException exception = new SAXParseException("Element '" + this.element.getNodeName() + "' contains parameter with invalid key '" + entry.getKey() + "'", this.getFilePath(), this.getFilePath(), this.getLine(), 0);
                throw new XMLException((Throwable)exception, this.getFilePath());
            }
            check.setPropertyAppend(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : this.autocorrectInputs.entrySet()) {
            if (!check.isValidAutofixParameter(entry.getKey())) {
                SAXParseException exception = new SAXParseException("Element '" + this.element.getNodeName() + "' contains autofix input with invalid key '" + entry.getKey() + "'", this.getFilePath(), this.getFilePath(), this.getLine(), 0);
                throw new XMLException((Throwable)exception, this.getFilePath());
            }
            check.setAutoCorrectInput(entry.getKey(), entry.getValue());
        }
        return check;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CheckStatus getSeverity() {
        return this.severity;
    }

    public void setSeverity(CheckStatus severity) {
        this.severity = severity;
    }

    public Integer getEffort() {
        return this.effort;
    }

    public void setEffort(Integer effort) {
        this.effort = effort;
    }

    public String getIncludePrewaiver() {
        return this.includePrewaiver;
    }

    public String getExcludePrewaiver() {
        return this.excludePrewaiver;
    }

    public void setIncludePrewaiver(String includePrewaiver) {
        this.includePrewaiver = includePrewaiver;
    }

    public void setExcludePrewaiver(String excludePrewaiver) {
        this.excludePrewaiver = excludePrewaiver;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public void addProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public Map<String, String> getPropertiesAppend() {
        return this.propertiesAppend;
    }

    public void setPropertiesAppend(Map<String, String> propertiesAppend) {
        this.propertiesAppend = propertiesAppend;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public Boolean isAutoCorrectEnabled() {
        return this.autoCorrectEnabled;
    }

    public void setAutoCorrectEnabled(Boolean autoCorrectEnabled) {
        this.autoCorrectEnabled = autoCorrectEnabled;
    }

    public Boolean isAutoCorrectBypassSanityCheckEnabled() {
        return this.autoCorrectSkipSanityChecks;
    }

    public void setAutoCorrectSkipSanityChecksEnabled(Boolean autoCorrectSkipSanityChecks) {
        this.autoCorrectSkipSanityChecks = autoCorrectSkipSanityChecks;
    }

    public Map<String, String> getAutocorrectInputs() {
        return this.autocorrectInputs;
    }

    public void setAutocorrectInputs(Map<String, String> autocorrectInputs) {
        this.autocorrectInputs = autocorrectInputs;
    }

    public Element getElement() {
        return this.element;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getDescriptionAppend() {
        return this.descriptionAppend;
    }

    public void setDescriptionAppend(String descriptionAppend) {
        this.descriptionAppend = descriptionAppend;
    }

    public RulesetCategoryModel getCategoryModel() {
        return this.categoryModel;
    }

    public void setCategoryModel(RulesetCategoryModel categoryModel) {
        this.categoryModel = categoryModel;
    }

    public void clean() {
        if (this.properties != null) {
            this.properties.clear();
        }
        if (this.propertiesAppend != null) {
            this.propertiesAppend.clear();
        }
        if (this.autocorrectInputs != null) {
            this.autocorrectInputs.clear();
        }
        this.categoryModel = null;
    }
}

