/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.ruleset;

import java.util.Arrays;
import ro.amiq.dvt.utils.DVTStringUtil;

public class RulesetComponent {
    private ComponentType fType;
    private String fBaseClass;

    public ComponentType getType() {
        return this.fType;
    }

    public void setType(ComponentType type) {
        this.fType = type;
    }

    public String getBaseClass() {
        return this.fBaseClass;
    }

    public void setBaseClass(String baseClass) {
        this.fBaseClass = baseClass;
    }

    public static enum ComponentType {
        AGENT,
        DRIVER,
        MONITOR,
        ENVIRONMENT,
        SCOREBOARD,
        COVERAGE_COLLECTOR,
        SEQUENCE_ITEM,
        SEQUENCER,
        SEQUENCE,
        TESTBENCH,
        TEST,
        CONFIGURATION_OBJECT,
        ACTIVE_COMPONENT,
        REACTIVE_COMPONENT;


        public static ComponentType from(String n) {
            if (n == null) {
                return null;
            }
            ComponentType[] componentTypeArray = ComponentType.values();
            int n2 = componentTypeArray.length;
            int n3 = 0;
            while (n3 < n2) {
                ComponentType name = componentTypeArray[n3];
                if (name.toString().equalsIgnoreCase(n.trim())) {
                    return name;
                }
                ++n3;
            }
            return null;
        }

        public static String valuesList() {
            return DVTStringUtil.join(Arrays.asList(ComponentType.values()), (String)",");
        }
    }
}

