/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.ruleset;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xml.sax.SAXParseException;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.dvt.utils.XMLException;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.ruleset.RulesetCategoryModel;
import ro.amiq.vlogdt.linter.ruleset.RulesetCheckModel;

public final class RulesetConvertor {
    private RulesetConvertor() {
    }

    public static List<OVMComplianceCategory> convertModelToCategories(OVMProject project, List<RulesetCategoryModel> categoriesModel, Map<String, DVTPair<Integer, Integer>> threadDumpRules, Set<String> histogramDumpRules) {
        LinkedHashMap<String, OVMComplianceCategory> categoriesResult = new LinkedHashMap<String, OVMComplianceCategory>();
        if (categoriesModel == null) {
            return Collections.emptyList();
        }
        HashMap<String, OVMComplianceCheck> rulesByName = new HashMap<String, OVMComplianceCheck>();
        for (RulesetCategoryModel categoryModel : categoriesModel) {
            if (categoryModel == null || categoryModel.getName() == null) continue;
            OVMComplianceCategory existingCategory = (OVMComplianceCategory)categoriesResult.get(categoryModel.getName());
            OVMComplianceCategory category = existingCategory != null ? existingCategory : new OVMComplianceCategory(categoryModel.getName(), categoryModel.getDescription());
            List<RulesetCheckModel> checkModels = categoryModel.getCheckModels();
            if (checkModels == null || checkModels.isEmpty()) continue;
            RulesetConvertor.createRulesAndApplyOverrides(project, rulesByName, category, checkModels);
            RulesetConvertor.activateProfilingForThreadDumpRules(threadDumpRules, rulesByName);
            RulesetConvertor.activateProfilingForHistogramDumpRules(histogramDumpRules, rulesByName);
            if (existingCategory != null) continue;
            categoriesResult.put(category.getName(), category);
        }
        return new ArrayList<OVMComplianceCategory>(categoriesResult.values());
    }

    private static void createRulesAndApplyOverrides(OVMProject project, Map<String, OVMComplianceCheck> rulesByName, OVMComplianceCategory category, List<RulesetCheckModel> checkModels) {
        Iterator<RulesetCheckModel> iterator = checkModels.iterator();
        while (iterator.hasNext()) {
            RulesetCheckModel checkModel;
            OVMComplianceCheck existingCheck = (checkModel = iterator.next()).getName() != null ? rulesByName.get(checkModel.getName()) : null;
            OVMComplianceCheck rule = checkModel.applyToCheck(project, category, existingCheck);
            if (rule == null || existingCheck != null) continue;
            if (rulesByName.containsKey(rule.getName())) {
                SAXParseException exception = new SAXParseException("Duplicate rule with the same name " + rule.getName() + " in the " + category.getName() + " category!", checkModel.getFilePath(), checkModel.getFilePath(), checkModel.getLine(), 0);
                throw new XMLException((Throwable)exception, checkModel.getFilePath());
            }
            rulesByName.put(rule.getName(), rule);
        }
    }

    private static void activateProfilingForThreadDumpRules(Map<String, DVTPair<Integer, Integer>> threadDumpRules, Map<String, OVMComplianceCheck> rulesByName) {
        if (threadDumpRules == null) {
            return;
        }
        for (Map.Entry<String, DVTPair<Integer, Integer>> entry : threadDumpRules.entrySet()) {
            OVMComplianceCheck check = rulesByName.get(entry.getKey());
            if (check == null) continue;
            check.activateProfiling((Integer)entry.getValue().getKey(), (Integer)entry.getValue().getValue());
        }
    }

    private static void activateProfilingForHistogramDumpRules(Set<String> histogramDumpRules, Map<String, OVMComplianceCheck> rulesByName) {
        if (histogramDumpRules == null) {
            return;
        }
        for (String entry : histogramDumpRules) {
            OVMComplianceCheck check = rulesByName.get(entry);
            if (check == null) continue;
            check.activateHistogramDump();
        }
    }
}

