/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.ruleset;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.w3c.dom.Element;
import org.xml.sax.SAXParseException;
import ro.amiq.dvt.utils.XMLException;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.ruleset.RuleFactory;
import ro.amiq.vlogdt.linter.ruleset.RulesetCategoryModel;
import ro.amiq.vlogdt.linter.ruleset.RulesetCheckModel;

public class RulesetDeclarationCheckModel
extends RulesetCheckModel {
    private String id;
    private boolean allowOverride;
    private Map<String, List<String>> annotationsByTagIdMap;

    public RulesetDeclarationCheckModel(Element element, RulesetCategoryModel parentCategory) {
        super(element, parentCategory);
        this.setAllowOverride(true);
    }

    @Override
    public OVMComplianceCheck applyToCheck(OVMProject ovmProject, OVMComplianceCategory category, OVMComplianceCheck existingCheck) {
        if (existingCheck != null) {
            SAXParseException exception = new SAXParseException("Duplicate rule with the same name " + this.getName() + " in the " + category.getName() + " category!", this.getFilePath(), this.getFilePath(), this.getLine(), 0);
            throw new XMLException((Throwable)exception, this.getFilePath());
        }
        OVMComplianceCheck rule = RuleFactory.INSTANCE.createRule(this.id, ovmProject, category);
        if (rule == null) {
            SAXParseException exception = new SAXParseException("Unable to create rule with specified id: " + this.id, this.getFilePath(), this.getFilePath(), this.getLine(), 0);
            throw new XMLException((Throwable)exception, this.getFilePath());
        }
        rule = super.applyToCheck(rule);
        rule.setAllowOverride(this.allowOverride);
        if (this.annotationsByTagIdMap != null) {
            rule.setAnnotationsByTagIdMap(new LinkedHashMap<String, List<String>>(this.annotationsByTagIdMap));
        }
        if (this.isFilteredCheck(rule)) {
            category.removeCheck(rule);
            return null;
        }
        return rule;
    }

    private boolean isFilteredCheck(OVMComplianceCheck rule) {
        if (this.getCategoryModel() == null) {
            return true;
        }
        Map<RulesetCategoryModel.FilterField, Predicate<OVMComplianceCheck>> filtersMap = this.getCategoryModel().getFiltersMap();
        if (filtersMap == null) {
            return false;
        }
        for (Map.Entry<RulesetCategoryModel.FilterField, Predicate<OVMComplianceCheck>> entry : filtersMap.entrySet()) {
            Predicate<OVMComplianceCheck> predicate = entry.getValue();
            if (predicate == null || !predicate.test(rule)) continue;
            return true;
        }
        return false;
    }

    public Map<String, List<String>> getAnnotationsByTagIdMap() {
        return this.annotationsByTagIdMap;
    }

    public void setAnnotationsByTagIdMap(Map<String, List<String>> annotationsByTagIdMap) {
        this.annotationsByTagIdMap = annotationsByTagIdMap;
    }

    public boolean isAllowOverride() {
        return this.allowOverride;
    }

    public void setAllowOverride(boolean allowOverride) {
        this.allowOverride = allowOverride;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void clean() {
        if (this.annotationsByTagIdMap != null) {
            this.annotationsByTagIdMap.clear();
        }
        super.clean();
    }
}

