/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.ruleset;

import ro.amiq.dvt.linter.ruleset.DVTRulesetKind;

public enum RulesetKind implements DVTRulesetKind
{
    VERISSIMO_ALL_OVM("All OVM Rules", "verissimo", "verissimo_all_ovm_ruleset.xml", "Verissimo_All_OVM_Ruleset_Doc.html"),
    VERISSIMO_ALL_UVM("All Rules", "verissimo", "verissimo_all_uvm_ruleset.xml", "Verissimo_All_UVM_Ruleset_Doc.html"),
    VERISSIMO_BASIC_OVM("Basic OVM Rules", "verissimo", "verissimo_basic_ovm_ruleset.xml", "Verissimo_Basic_OVM_Ruleset_Doc.html"),
    VERISSIMO_BASIC_UVM("Basic Rules", "verissimo", "verissimo_basic_uvm_ruleset.xml", "Verissimo_Basic_UVM_Ruleset_Doc.html"),
    SV_OVM_COMPLIANCE("OVM Compliance Rules", "ovm_compliance", "verissimo_compliance_ovm_ruleset.xml", "Verissimo_Compliance_OVM_Ruleset_Doc.html"),
    SV_UVM_COMPLIANCE("UVM Compliance Rules", "uvm_compliance", "verissimo_compliance_uvm_ruleset.xml", "Verissimo_Compliance_UVM_Ruleset_Doc.html"),
    VERISSIMO_RTL("RTL Rules", "verissimo", "verissimo_rtl_ruleset.xml", "Verissimo_RTL_Ruleset_Doc.html"),
    VERISSIMO_DEAD_CODE("Dead Code Rules", "verissimo", "verissimo_dead_code_ruleset.xml", "Verissimo_Dead_Code_Ruleset_Doc.html"),
    VERISSIMO_UVM_IEEE("UVM IEEE 1800.2-2020 Compliance Rules", "verissimo", "verissimo_uvm_ieee_ruleset.xml", "Verissimo_UVM_IEEE_Ruleset_Doc.html"),
    VERISSIMO_PERFORMANCE("Performance Rules", "verissimo", "verissimo_performance_ruleset.xml", "Verissimo_Performance_Ruleset_Doc.html"),
    VERISSIMO_NON_STANDARD("Non Standard Rules", "verissimo", "verissimo_non_standard_ruleset.xml", "Verissimo_Non_Standard_Ruleset_Doc.html"),
    IMPORT_FROM_HTML("Import from HTML report", "verissimo", "verissimo_dummy_ruleset.xml", "Verissimo_Dummy_Ruleset_Doc.html"),
    CUSTOM("Custom Ruleset", "verissimo", "", "Verissimo_Custom_Ruleset_Doc.html");

    private static final String OVM_MODE = "ovm";
    private final String fName;
    private final String fPrefix;
    private final String fXML;
    private final String fHTML;

    private RulesetKind(String name, String prefix, String xml, String html) {
        this.fName = name;
        this.fPrefix = prefix;
        this.fXML = xml;
        this.fHTML = html;
    }

    public String getXML() {
        return this.fXML;
    }

    public String getHMTL() {
        return this.fHTML;
    }

    public String getName() {
        return this.fName;
    }

    public static RulesetKind[] getAll() {
        return new RulesetKind[]{VERISSIMO_BASIC_UVM, VERISSIMO_BASIC_OVM, VERISSIMO_RTL, VERISSIMO_DEAD_CODE, VERISSIMO_UVM_IEEE, VERISSIMO_PERFORMANCE, SV_UVM_COMPLIANCE, SV_OVM_COMPLIANCE, VERISSIMO_ALL_UVM, VERISSIMO_ALL_OVM, VERISSIMO_NON_STANDARD, IMPORT_FROM_HTML, CUSTOM};
    }

    public static RulesetKind[] getForLintConfig() {
        return new RulesetKind[]{VERISSIMO_BASIC_UVM, VERISSIMO_RTL, VERISSIMO_DEAD_CODE, VERISSIMO_UVM_IEEE, VERISSIMO_PERFORMANCE, SV_UVM_COMPLIANCE, VERISSIMO_ALL_UVM, VERISSIMO_NON_STANDARD, CUSTOM};
    }

    public static RulesetKind getComplianceRulesetFor(String mode) {
        return OVM_MODE.equalsIgnoreCase(mode) ? SV_OVM_COMPLIANCE : SV_UVM_COMPLIANCE;
    }

    public static RulesetKind getBasicRulesetFor(String mode) {
        return OVM_MODE.equalsIgnoreCase(mode) ? VERISSIMO_BASIC_OVM : VERISSIMO_BASIC_UVM;
    }

    public static RulesetKind getRtlRulesetFor() {
        return VERISSIMO_RTL;
    }

    public static RulesetKind getDeadCodeRulesetFor() {
        return VERISSIMO_DEAD_CODE;
    }

    public static RulesetKind getUVMIEEERulesetFor() {
        return VERISSIMO_UVM_IEEE;
    }

    public static RulesetKind getPerformanceRulesetFor() {
        return VERISSIMO_PERFORMANCE;
    }

    public static RulesetKind getNonStandardRulesetFor() {
        return VERISSIMO_NON_STANDARD;
    }

    public static RulesetKind getFullRulesetFor(String mode) {
        return OVM_MODE.equalsIgnoreCase(mode) ? VERISSIMO_ALL_OVM : VERISSIMO_ALL_UVM;
    }

    public static RulesetKind getPrefered() {
        return RulesetKind.getBasicRulesetFor("uvm");
    }

    public static RulesetKind getCustom() {
        return CUSTOM;
    }

    public boolean isPredefined() {
        return this != CUSTOM;
    }

    public static boolean isPredefined(String kind) {
        RulesetKind rulesetKind = RulesetKind.from(kind);
        return rulesetKind != null && rulesetKind != CUSTOM;
    }

    public String getPrefix() {
        return this.fPrefix;
    }

    public String toString() {
        return this.fName;
    }

    public static RulesetKind from(String name) {
        if (name == null) {
            return null;
        }
        RulesetKind[] rulesetKindArray = RulesetKind.getAll();
        int n = rulesetKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            RulesetKind kind = rulesetKindArray[n2];
            if (kind.toString().equals(name.trim())) {
                return kind;
            }
            ++n2;
        }
        return null;
    }

    public static RulesetKind from(String name, boolean uvmToOvm) {
        RulesetKind uvmKind = RulesetKind.from(name);
        if (!uvmToOvm || uvmKind == null) {
            return uvmKind;
        }
        switch (uvmKind) {
            case VERISSIMO_ALL_UVM: {
                return VERISSIMO_ALL_OVM;
            }
            case VERISSIMO_BASIC_UVM: {
                return VERISSIMO_BASIC_OVM;
            }
            case SV_UVM_COMPLIANCE: {
                return SV_OVM_COMPLIANCE;
            }
        }
        return uvmKind;
    }
}

