/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.ruleset;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xml.sax.SAXParseException;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.XMLException;
import ro.amiq.vlogdt.linter.annotations.AnnotationManager;
import ro.amiq.vlogdt.linter.ruleset.RulesetArchitecture;
import ro.amiq.vlogdt.linter.ruleset.RulesetCategoryModel;
import ro.amiq.vlogdt.linter.ruleset.RulesetConfiguration;

public class RulesetModel {
    private List<RulesetCategoryModel> fCategories = new LinkedList<RulesetCategoryModel>();
    private RulesetConfiguration fConfiguration;

    public List<RulesetCategoryModel> getCategories() {
        return this.fCategories;
    }

    public void addCategory(RulesetCategoryModel category) {
        this.fCategories.add(category);
    }

    public void addCategories(List<RulesetCategoryModel> categories) {
        this.fCategories.addAll(categories);
    }

    public RulesetConfiguration getConfiguration() {
        return this.fConfiguration;
    }

    public void setConfiguration(RulesetConfiguration configuration) {
        this.fConfiguration = configuration;
    }

    public void addConfiguration(RulesetConfiguration configuration, String errorPath) throws XMLException {
        if (configuration == null) {
            return;
        }
        if (this.fConfiguration == null) {
            this.setConfiguration(configuration);
        } else if (configuration.isOverrideConfig()) {
            if (this.fConfiguration.isOverrideConfig()) {
                SAXParseException exception = new SAXParseException("Multiple 'override-configuration' elements included!", errorPath, errorPath, 0, 0);
                throw new XMLException((Throwable)exception, errorPath);
            }
            this.setConfiguration(configuration);
        } else if (!this.fConfiguration.isOverrideConfig()) {
            Set<String> newHistogramDumpRules;
            Map<String, DVTPair<Integer, Integer>> newThreadDumpRules;
            int newProcessTimeout;
            int newSessionTimeout;
            String newSkipElements;
            AnnotationManager newAnnotationManager;
            RulesetArchitecture newArchitecture = configuration.getArchitecture();
            if (newArchitecture != null) {
                if (this.fConfiguration.getArchitecture() != null) {
                    this.fConfiguration.getArchitecture().addComponents(newArchitecture.getComponents());
                } else {
                    this.fConfiguration.setArchitecture(newArchitecture);
                }
            }
            if ((newAnnotationManager = configuration.getAnnotationManager()) != null) {
                if (this.fConfiguration.getAnnotationManager() != null) {
                    this.fConfiguration.getAnnotationManager().addAnnotations(newAnnotationManager.getAnnotations());
                } else {
                    this.fConfiguration.setAnnotationManager(newAnnotationManager);
                }
            }
            this.fConfiguration.setIncludeHTMLCode(this.fConfiguration.getIncludeHTMLCode() || configuration.getIncludeHTMLCode());
            this.fConfiguration.setIncludeCreationDate(this.fConfiguration.getIncludeCreationDate() || configuration.getIncludeCreationDate());
            this.fConfiguration.setHasEffortEstimation(this.fConfiguration.getHasEffortEstimation() || configuration.getHasEffortEstimation());
            String newSkipFiles = configuration.getSkipFiles();
            if (newSkipFiles != null) {
                this.fConfiguration.setSkipFiles(newSkipFiles);
            }
            if ((newSkipElements = configuration.getSkipElements()) != null) {
                this.fConfiguration.setSkipElements(newSkipElements);
            }
            if ((newSessionTimeout = configuration.getSessionTimeout()) != 0) {
                this.fConfiguration.setSessionTimeout(newSessionTimeout);
            }
            if ((newProcessTimeout = configuration.getProcessTimeout()) != 0) {
                this.fConfiguration.setProcessTimeout(newProcessTimeout);
            }
            if ((newThreadDumpRules = configuration.getThreadDumpRules()) != null && !newThreadDumpRules.isEmpty()) {
                if (this.fConfiguration.getThreadDumpRules() != null) {
                    this.fConfiguration.getThreadDumpRules().putAll(newThreadDumpRules);
                } else {
                    this.fConfiguration.setThreadDumpRules(newThreadDumpRules);
                }
            }
            if ((newHistogramDumpRules = configuration.getHistogramDumpRules()) != null && !newHistogramDumpRules.isEmpty()) {
                if (this.fConfiguration.getHistogramDumpRules() != null) {
                    this.fConfiguration.getHistogramDumpRules().addAll(newHistogramDumpRules);
                } else {
                    this.fConfiguration.setHistogramDumpRules(newHistogramDumpRules);
                }
            }
        }
    }

    public void clean() {
        if (this.fConfiguration != null) {
            this.fConfiguration.clean();
        }
        if (this.fCategories != null) {
            this.fCategories.forEach(category -> category.clean());
            this.fCategories.clear();
        }
    }

    public static enum LibraryName {
        OVM,
        UVM;


        public static LibraryName from(String n) {
            if (n == null) {
                return null;
            }
            LibraryName[] libraryNameArray = LibraryName.values();
            int n2 = libraryNameArray.length;
            int n3 = 0;
            while (n3 < n2) {
                LibraryName name = libraryNameArray[n3];
                if (name.toString().equalsIgnoreCase(n.trim())) {
                    return name;
                }
                ++n3;
            }
            return null;
        }

        public static String valuesList() {
            return DVTStringUtil.join(Arrays.asList(LibraryName.values()), (String)",");
        }
    }
}

