/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.ruleset;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IProject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigManagerCommon;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.utils.PositionalXMLReader;
import ro.amiq.dvt.utils.XMLErrorHandler;
import ro.amiq.dvt.utils.XMLException;
import ro.amiq.dvt.utils.XMLValidator;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.ruleset.RulesetCategoryModel;
import ro.amiq.vlogdt.linter.ruleset.RulesetModel;
import ro.amiq.vlogdt.linter.ruleset.RulesetXMLParser1;
import ro.amiq.vlogdt.linter.ruleset.RulesetXMLParser2;
import ro.amiq.vlogdt.linter.utils.LintUtils;

public abstract class RulesetXMLParser {
    private final String fFilePath;
    private final File fFile;
    private final OVMProject fOVMProject;
    private URL fURL;
    private Map<RulesetXMLParser, Integer> fIncludedParsers;
    protected static Map<String, List<String>> fUnresolvedVariables = new LinkedHashMap<String, List<String>>();
    protected static final String TAG_INCLUDE = "include";
    protected static final String ATTR_FILE_PATH = "file";
    protected static final String ATTR_FILE_PATH_RELATIVE = "relative";
    protected static final String ATTR_FILE_OPTIONAL = "optional";
    protected static final String ATTR_SINCE = "since";
    protected static final String ATTR_LABEL = "label";
    protected static final String ATTR_VERSION = "version";
    public static final String LAST_VERSION = "2";

    protected RulesetXMLParser(OVMProject project, URL url) {
        this.fURL = url;
        this.fFilePath = url.getFile();
        this.fFile = new File(this.fFilePath);
        this.fOVMProject = project;
        this.fIncludedParsers = new LinkedHashMap<RulesetXMLParser, Integer>();
    }

    public abstract RulesetModel load(RulesetCategoryModel var1) throws Exception;

    public URL getURL() {
        return this.fURL;
    }

    public File getFile() {
        return this.fFile;
    }

    public String getFilePath() {
        return this.fFilePath;
    }

    public OVMProject getOVMProject() {
        return this.fOVMProject;
    }

    public Map<RulesetXMLParser, Integer> getIncludedParsers() {
        return this.fIncludedParsers;
    }

    private void addIncludedParser(RulesetXMLParser parser, Integer line) {
        this.fIncludedParsers.put(parser, line);
    }

    public static Map<String, List<String>> getUnresolvedVariables() {
        return fUnresolvedVariables;
    }

    public static void resetUnresolvedVariables() {
        fUnresolvedVariables = new LinkedHashMap<String, List<String>>();
    }

    public static RulesetXMLParser newParser(OVMProject project, URL url, boolean useLastVersion) throws Exception {
        if (useLastVersion) {
            return RulesetXMLParser.newParser(project, url, LAST_VERSION);
        }
        String version = RulesetXMLParser.detectVersion(url);
        return RulesetXMLParser.newParser(project, url, version);
    }

    private static RulesetXMLParser newParser(OVMProject project, URL url, String version) throws Exception {
        if ("1".equals(version)) {
            return new RulesetXMLParser1(project, url);
        }
        if (LAST_VERSION.equals(version)) {
            return new RulesetXMLParser2(project, url);
        }
        throw new IllegalArgumentException("Unknown ruleset file version " + version + ".");
    }

    public static RulesetXMLParser createParsers(LinkedHashMap<String, RulesetXMLParser> fFileParsersMap, OVMProject fOVMProject, String canonicalPath, String parentFilePath, Map<String, List<String>> inexistentFiles, Map<String, List<String>> invalidSinceMap) {
        return RulesetXMLParser.createParsers(fFileParsersMap, fOVMProject, canonicalPath, parentFilePath, inexistentFiles, invalidSinceMap, false);
    }

    public static RulesetXMLParser createParsers(LinkedHashMap<String, RulesetXMLParser> fFileParsersMap, OVMProject fOVMProject, String canonicalPath, String parentFilePath, Map<String, List<String>> inexistentFiles, Map<String, List<String>> invalidSinceMap, boolean isOptional) {
        if (fFileParsersMap.containsKey(canonicalPath)) {
            return null;
        }
        File file = new File(canonicalPath);
        if (!file.exists()) {
            if (!isOptional) {
                if (inexistentFiles.containsKey(parentFilePath)) {
                    inexistentFiles.get(parentFilePath).add(canonicalPath);
                } else {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add(canonicalPath);
                    inexistentFiles.put(parentFilePath, arrayList);
                }
            }
            return null;
        }
        RulesetXMLParser parser = null;
        try {
            URI uri = file.toURI();
            parser = RulesetXMLParser.newParser(fOVMProject, uri.toURL(), false);
        }
        catch (SAXException e) {
            throw new XMLException((Throwable)e, file.getAbsolutePath());
        }
        catch (IOException e) {
            throw new XMLException((Throwable)e, file.getAbsolutePath());
        }
        catch (IllegalArgumentException e) {
            throw new XMLException((Throwable)e, file.getAbsolutePath());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (parser != null && !fFileParsersMap.containsValue(parser)) {
            fFileParsersMap.put(canonicalPath, parser);
            try {
                List<String> unresolvedVariables;
                List<RulesetIncludeInfo> includes = parser.getIncludedFiles(canonicalPath);
                List<String> invalidSinces = parser.getInvalidSinces(canonicalPath);
                if (invalidSinces != null && !invalidSinces.isEmpty()) {
                    List<String> sinces = invalidSinceMap.get(canonicalPath);
                    if (sinces == null) {
                        sinces = new ArrayList<String>();
                    }
                    sinces.addAll(invalidSinces);
                    invalidSinceMap.put(canonicalPath, sinces);
                }
                if ((unresolvedVariables = parser.getUnresolvedVariables(canonicalPath)) != null && !unresolvedVariables.isEmpty()) {
                    List<String> variables = fUnresolvedVariables.get(canonicalPath);
                    if (variables == null) {
                        variables = new ArrayList<String>();
                    }
                    variables.addAll(unresolvedVariables);
                    fUnresolvedVariables.put(canonicalPath, variables);
                }
                if (includes != null && !includes.isEmpty()) {
                    for (RulesetIncludeInfo include : includes) {
                        RulesetXMLParser includedParser = RulesetXMLParser.createParsers(fFileParsersMap, fOVMProject, include.getPath(), canonicalPath, inexistentFiles, invalidSinceMap, include.isOptional());
                        if (includedParser == null) continue;
                        parser.addIncludedParser(includedParser, include.getLineNumber());
                    }
                }
            }
            catch (XMLException e) {
                throw e;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        return parser;
    }

    private List<RulesetIncludeInfo> getIncludedFiles(String parentPath) throws Exception {
        LinkedList<RulesetIncludeInfo> includes = new LinkedList<RulesetIncludeInfo>();
        URL url = new File(parentPath).toURI().toURL();
        BufferedInputStream stream = new BufferedInputStream(url.openStream());
        Document document = PositionalXMLReader.readXML((InputStream)stream);
        ((InputStream)stream).close();
        NodeList nodes = document.getElementsByTagName(TAG_INCLUDE);
        int i = 0;
        while (i < nodes.getLength()) {
            Element includeFile = (Element)nodes.item(i);
            String includeFilePathPattern = includeFile.getAttribute(ATTR_FILE_PATH);
            if ((includeFilePathPattern = DVTUtilsCommon.INSTANCE.replaceAllSystemVariables((CharSequence)includeFilePathPattern, DVTUtilsCommon.ReplaceSysvarsPolicy.LEAVE_UNREPLACED, envVarName -> BuildConfigManager.getUserDefinedEnvVar((IProject)this.getOVMProject().getProject(), (String)envVarName, (BuildConfigManagerCommon.EnvVarReplacementPriorityPolicy)BuildConfigManagerCommon.EnvVarReplacementPriorityPolicy.LAST_INVOCATION))) != null && !includeFilePathPattern.isEmpty()) {
                int line = XMLValidator.getLineFromElement((Element)includeFile);
                boolean isRelative = Boolean.parseBoolean(includeFile.getAttribute(ATTR_FILE_PATH_RELATIVE));
                boolean isOptional = Boolean.parseBoolean(includeFile.getAttribute(ATTR_FILE_OPTIONAL));
                String canonicalPath = RulesetXMLParser.resolvePath(includeFilePathPattern, parentPath, isRelative);
                includes.add(new RulesetIncludeInfo(canonicalPath, isOptional, line));
            }
            ++i;
        }
        return includes;
    }

    private List<String> getInvalidSinces(String canonicalPath) throws Exception {
        ArrayList<String> invalidSinces = new ArrayList<String>();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler((ErrorHandler)XMLErrorHandler.INSTANCE);
        Document document = builder.parse(new File(canonicalPath));
        NodeList nodes = document.getElementsByTagName(TAG_INCLUDE);
        int i = 0;
        while (i < nodes.getLength()) {
            Element includeFile = (Element)nodes.item(i);
            String since = includeFile.getAttribute(ATTR_SINCE);
            if (since != null && !since.isEmpty()) {
                if (LintUtils.DATE_PATTERN.matcher(since).matches()) {
                    try {
                        OVMProject.getDateFormat().parse(since);
                    }
                    catch (ParseException parseException) {
                        invalidSinces.add(since);
                    }
                } else if (LintUtils.VERSION_PATTERN.matcher(since).matches()) {
                    Map versionsMap = DVTUtilsCommon.INSTANCE.getVersionsMap();
                    if (!versionsMap.containsKey(since)) {
                        invalidSinces.add(since);
                    }
                } else {
                    invalidSinces.add(since);
                }
            }
            ++i;
        }
        return invalidSinces;
    }

    private List<String> getUnresolvedVariables(String canonicalPath) throws Exception {
        ArrayList<String> unresolvedVariables = new ArrayList<String>();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler((ErrorHandler)XMLErrorHandler.INSTANCE);
        Document document = builder.parse(new File(canonicalPath));
        NodeList nodes = document.getElementsByTagName(TAG_INCLUDE);
        int i = 0;
        while (i < nodes.getLength()) {
            Element includeFile = (Element)nodes.item(i);
            String includeFilePathPattern = includeFile.getAttribute(ATTR_FILE_PATH);
            String replacedString = DVTUtilsCommon.INSTANCE.replaceAllSystemVariables((CharSequence)includeFilePathPattern, DVTUtilsCommon.ReplaceSysvarsPolicy.RETURN_NULL, envVarName -> BuildConfigManager.getUserDefinedEnvVar((IProject)this.getOVMProject().getProject(), (String)envVarName, (BuildConfigManagerCommon.EnvVarReplacementPriorityPolicy)BuildConfigManagerCommon.EnvVarReplacementPriorityPolicy.LAST_INVOCATION));
            if (replacedString == null) {
                unresolvedVariables.add(includeFilePathPattern);
            }
            ++i;
        }
        return unresolvedVariables;
    }

    public static String detectVersion(URL url) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler((ErrorHandler)XMLErrorHandler.INSTANCE);
        Document document = builder.parse(url.openStream(), url.getFile());
        NodeList waiversNodes = document.getElementsByTagName("ruleset");
        if (waiversNodes.getLength() < 1) {
            return null;
        }
        Element waiversNode = (Element)waiversNodes.item(0);
        return waiversNode.getAttribute(ATTR_VERSION);
    }

    public static String resolvePath(String filePath, String parentFilePath, boolean isRelative) {
        String expandedPath;
        File parentFile;
        if (isRelative && parentFilePath != null && !parentFilePath.isEmpty() && (parentFile = new File(parentFilePath)).getParentFile() != null) {
            String absolutePath = parentFile.getParentFile().getPath();
            filePath = String.valueOf(absolutePath) + DVTFileUtils.FILE_SEPARATOR + filePath;
        }
        if ((expandedPath = DVTUtilsCommon.INSTANCE.replaceAllSystemVariables((CharSequence)filePath.trim())) == null) {
            expandedPath = filePath.trim();
        }
        File file = new File(expandedPath);
        String canonicalPath = null;
        if (file.exists()) {
            try {
                canonicalPath = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                canonicalPath = file.getAbsolutePath();
            }
        } else {
            canonicalPath = file.getAbsolutePath();
        }
        return canonicalPath;
    }

    protected static class RulesetIncludeInfo {
        String path;
        Boolean isOptional;
        Integer lineNumber;

        public RulesetIncludeInfo(String path, Boolean isOptional, Integer lineNumber) {
            this.path = path;
            this.isOptional = isOptional;
            this.lineNumber = lineNumber;
        }

        public Integer getLineNumber() {
            return this.lineNumber;
        }

        public String getPath() {
            return this.path;
        }

        public Boolean isOptional() {
            return this.isOptional;
        }
    }
}

