/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.ruleset;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;
import ro.amiq.dvt.utils.PositionalXMLReader;
import ro.amiq.dvt.utils.XMLException;
import ro.amiq.dvt.utils.XMLValidator;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.ruleset.RulesetCategoryModel;
import ro.amiq.vlogdt.linter.ruleset.RulesetDeclarationCheckModel;
import ro.amiq.vlogdt.linter.ruleset.RulesetModel;
import ro.amiq.vlogdt.linter.ruleset.RulesetXMLParser;

public class RulesetXMLParser1
extends RulesetXMLParser {
    public static final String VERSION_ID = "1";
    private static final String ATTR_LIBRARY = "library";
    private static final String ATTR_ID = "id";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_TITLE = "title";
    private static final String ATTR_DESCRIPTION = "description";
    private static final String ATTR_KEY = "key";
    private static final String ATTR_VALUE = "value";
    private static final String TAG_RULESET = "ruleset";
    private static final String TAG_CATEGORY = "category";
    private static final String TAG_RULE = "rule";
    private static final String TAG_PROPERTY = "property";

    public RulesetXMLParser1(OVMProject project, URL url) {
        super(project, url);
    }

    @Override
    public RulesetModel load(RulesetCategoryModel parentCategory) throws Exception {
        String library;
        RulesetModel.LibraryName libraryName;
        RulesetModel rulesetModel = new RulesetModel();
        ArrayList<RulesetCategoryModel> categories = new ArrayList<RulesetCategoryModel>();
        BufferedInputStream stream = new BufferedInputStream(this.getURL().openStream());
        Document document = PositionalXMLReader.readXML((InputStream)stream);
        ((InputStream)stream).close();
        String id = null;
        String name = null;
        String title = null;
        String description = null;
        String key = null;
        String value = null;
        NodeList rulesetNode = document.getElementsByTagName(TAG_RULESET);
        XMLValidator.checkUniqueRootNode((NodeList)rulesetNode, (String)TAG_RULESET, (String)this.getFilePath());
        Element rulesetElement = (Element)rulesetNode.item(0);
        XMLValidator.checkChildren((Element)rulesetElement, new HashSet<String>(Arrays.asList(TAG_CATEGORY, "include")), (String)this.getFilePath());
        XMLValidator.checkAttributes((Element)rulesetElement, new HashSet<String>(Arrays.asList("version", ATTR_NAME, ATTR_LIBRARY)), (String)this.getFilePath());
        String rulesetName = rulesetElement.getAttribute(ATTR_NAME);
        if (rulesetName != null && !rulesetName.trim().isEmpty()) {
            this.getOVMProject().setRulesetName(rulesetName.trim());
        }
        if ((libraryName = RulesetModel.LibraryName.from(library = rulesetElement.getAttribute(ATTR_LIBRARY))) == RulesetModel.LibraryName.OVM) {
            this.getOVMProject().setLibraryKind(1);
        } else if (libraryName == RulesetModel.LibraryName.UVM) {
            this.getOVMProject().setLibraryKind(2);
        }
        NodeList categoryNodes = rulesetElement.getElementsByTagName(TAG_CATEGORY);
        if (rulesetElement.getElementsByTagName("include").getLength() == 0 && categoryNodes.getLength() == 0) {
            SAXParseException exception = new SAXParseException("Element 'ruleset' must contain at least one 'category' element or at least one 'include' element", this.getFilePath(), this.getFilePath(), XMLValidator.getLineFromElement((Element)rulesetElement), 0);
            throw new XMLException((Throwable)exception, this.getFilePath());
        }
        int i = 0;
        while (i < categoryNodes.getLength()) {
            Element categoryElement = (Element)categoryNodes.item(i);
            XMLValidator.checkChildren((Element)categoryElement, new HashSet<String>(Arrays.asList(TAG_RULE)), (String)this.getFilePath());
            XMLValidator.checkAttributes((Element)categoryElement, new HashSet<String>(Arrays.asList(ATTR_NAME, ATTR_DESCRIPTION)), (String)this.getFilePath());
            name = categoryElement.getAttribute(ATTR_NAME);
            if (name == null) {
                name = "";
            }
            if ((description = categoryElement.getAttribute(ATTR_DESCRIPTION)) == null) {
                description = "";
            }
            RulesetCategoryModel category = new RulesetCategoryModel(name, description, XMLValidator.getLineFromElement((Element)categoryElement));
            categories.add(category);
            RulesetCategoryModel checkCategory = parentCategory == null ? category : parentCategory;
            NodeList ruleNodes = categoryElement.getElementsByTagName(TAG_RULE);
            int j = 0;
            while (j < ruleNodes.getLength()) {
                Element ruleElement = (Element)ruleNodes.item(j);
                XMLValidator.checkChildren((Element)ruleElement, new HashSet<String>(Arrays.asList(TAG_PROPERTY)), (String)this.getFilePath());
                XMLValidator.checkAttributes((Element)ruleElement, new HashSet<String>(Arrays.asList(ATTR_ID, ATTR_NAME, ATTR_TITLE, ATTR_DESCRIPTION)), (String)this.getFilePath());
                RulesetDeclarationCheckModel rule = new RulesetDeclarationCheckModel(ruleElement, checkCategory);
                String filePath = this.getFilePath();
                rule.setFilePath(filePath);
                int line = XMLValidator.getLineFromElement((Element)ruleElement);
                rule.setLine(line);
                id = ruleElement.getAttribute(ATTR_ID);
                if (id == null || id.isEmpty()) {
                    SAXParseException exception = new SAXParseException("There is no id attribute specified for the rule tag", this.getFilePath(), this.getFilePath(), XMLValidator.getLineFromElement((Element)ruleElement), 0);
                    throw new XMLException((Throwable)exception, this.getFilePath());
                }
                rule.setId(id);
                name = ruleElement.getAttribute(ATTR_NAME);
                if (name != null && !name.isEmpty()) {
                    rule.setName(name);
                }
                if ((title = ruleElement.getAttribute(ATTR_TITLE)) != null && !title.isEmpty()) {
                    rule.setTitle(title);
                }
                if ((description = ruleElement.getAttribute(ATTR_DESCRIPTION)) != null && !description.isEmpty()) {
                    rule.setDescription(description);
                }
                NodeList propertyNodes = ruleElement.getElementsByTagName(TAG_PROPERTY);
                int k = 0;
                while (k < propertyNodes.getLength()) {
                    Element propertyElement = (Element)propertyNodes.item(k);
                    XMLValidator.checkAttributes((Element)propertyElement, new HashSet<String>(Arrays.asList(ATTR_KEY, ATTR_VALUE)), (String)this.getFilePath());
                    key = propertyElement.getAttribute(ATTR_KEY);
                    if (key != null && !key.isEmpty()) {
                        value = propertyElement.getAttribute(ATTR_VALUE);
                        if (value == null) {
                            value = "";
                        }
                        rule.addProperty(key, value);
                    }
                    ++k;
                }
                checkCategory.addCheckModel(rule);
                ++j;
            }
            ++i;
        }
        rulesetModel.addCategories(categories);
        return rulesetModel;
    }
}

