/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.ruleset;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigManagerCommon;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.utils.PositionalXMLReader;
import ro.amiq.dvt.utils.XMLException;
import ro.amiq.dvt.utils.XMLValidator;
import ro.amiq.vlogdt.linter.CheckStatus;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckFilters;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.annotations.AnnotationCcField;
import ro.amiq.vlogdt.linter.annotations.AnnotationField;
import ro.amiq.vlogdt.linter.annotations.AnnotationFsField;
import ro.amiq.vlogdt.linter.annotations.AnnotationGitField;
import ro.amiq.vlogdt.linter.annotations.AnnotationLocation;
import ro.amiq.vlogdt.linter.annotations.AnnotationManager;
import ro.amiq.vlogdt.linter.annotations.AnnotationP4Field;
import ro.amiq.vlogdt.linter.annotations.AnnotationSvnField;
import ro.amiq.vlogdt.linter.annotations.AnnotationType;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.ruleset.DefaultRuleset;
import ro.amiq.vlogdt.linter.ruleset.RulesetArchitecture;
import ro.amiq.vlogdt.linter.ruleset.RulesetCategoryModel;
import ro.amiq.vlogdt.linter.ruleset.RulesetCheckModel;
import ro.amiq.vlogdt.linter.ruleset.RulesetComponent;
import ro.amiq.vlogdt.linter.ruleset.RulesetConfiguration;
import ro.amiq.vlogdt.linter.ruleset.RulesetDeclarationCheckModel;
import ro.amiq.vlogdt.linter.ruleset.RulesetModel;
import ro.amiq.vlogdt.linter.ruleset.RulesetOverrideCheckModel;
import ro.amiq.vlogdt.linter.ruleset.RulesetXMLParser;
import ro.amiq.vlogdt.linter.utils.LintUtils;

public class RulesetXMLParser2
extends RulesetXMLParser {
    public static final String VERSION_ID = "2";
    private static final String ATTR_LIBRARY = "library";
    private static final String ATTR_LINT_LIBRARY_CONTENTS = "lintLibraryContents";
    private static final String ATTR_ID = "id";
    private static final String ATTR_DISABLE = "disable";
    private static final String ATTR_SEVERITY = "severity";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_TITLE = "title";
    private static final String ATTR_DESCRIPTION = "description";
    private static final String ATTR_DESCRIPTION_APPEND = "description-append";
    private static final String ATTR_KEY = "key";
    private static final String ATTR_VALUE = "value";
    private static final String ATTR_VALUE_APPEND = "value-append";
    private static final String ATTR_LEVEL = "level";
    private static final String ATTR_TIME = "time";
    private static final String ATTR_TIMEOUT = "timeout";
    private static final String ATTR_EFFORT_LEVEL = "effort-level";
    private static final String ATTR_AUTO_CORRECT = "autocorrect";
    private static final String ATTR_AUTO_CORRECT_SKIP_SANITY_CHECKS = "autocorrect-skip-sanity-checks";
    private static final String ATTR_INTERVAL = "interval";
    private static final String ATTR_DELAY = "delay";
    private static final String ATTR_RULES = "rules";
    private static final String TAG_RULESET = "ruleset";
    private static final String TAG_CATEGORY = "category";
    private static final String TAG_RULE = "rule";
    private static final String TAG_PROPERTY = "property";
    private static final String TAG_AUTO_CORRECT_INPUT = "autocorrect-input";
    private static final String TAG_TAG = "tag";
    private static final String TAG_EFFORT = "effort";
    private static final String TAG_THREAD_DUMP = "thread-dump";
    private static final String TAG_HISTOGRAM_DUMP = "histogram-dump";
    private static final String TAG_ARCHITECTURE = "architecture";
    private static final String TAG_CONFIGURATION = "configuration";
    private static final String TAG_COMPONENT = "component";
    private static final String ATTR_BASE_CLASS = "base-class";
    private static final String TAG_ANNOTATION = "annotation";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_SHOW_IN = "show-in";
    private static final String ATTR_FS_FIELD = "fs-field";
    private static final String ATTR_GIT_FIELD = "git-field";
    private static final String ATTR_P4_FIELD = "p4-field";
    private static final String ATTR_SVN_FIELD = "svn-field";
    private static final String ATTR_CC_FIELD = "cc-field";
    private static final String ATTR_TAG_KEY = "tag-key";
    private static final String TAG_SKIP_FILE = "skip-file";
    private static final String ATTR_SKIP_FILE_NAME_PATTERN = "name-pattern";
    private static final String TAG_SKIP_ELEMENT = "skip-element";
    private static final String ATTR_SKIP_ELEMENT_NAME_PATTERN = "name-pattern";
    private static final String TAG_FAILED = "failed";
    private static final String TAG_INCLUDE_HTML_CODE = "include-html-code";
    private static final String TAG_INCLUDE_CREATION_DATE = "include-creation-date";
    private static final String TAG_EFFORT_LEVELS = "effort-levels";
    private static final String TAG_TIMEOUT = "timeout";
    private static final String ATTR_CHECK = "check";
    private static final String ATTR_SESSION = "session";
    private static final String ATTR_PROCESS = "process";
    private static final String TAG_PRE_WAIVER = "pre-waiver";
    private static final String ATTR_INCLUDE_PATH = "include-path";
    private static final String ATTR_EXCLUDE_PATH = "exclude-path";
    private static final String ATTR_ALLOW_OVERRIDE = "allow-override";
    private static final String TAG_OVERRIDE_RULE = "override-rule";
    private static final String TAG_OVERRIDE_CONFIGURATION = "override-configuration";
    private static final Pattern COMMA_PATTERN = Pattern.compile("\\s*,\\s*");
    private static final Set<String> VALID_CHILDREN_RULE = new HashSet<String>(Arrays.asList("tag", "property", "autocorrect-input", "pre-waiver"));
    private static final Set<String> VALID_ATTRIBUTES_RULE = new HashSet<String>(Arrays.asList("id", "disable", "severity", "name", "title", "description", "description-append", "effort-level", "timeout", "autocorrect", "autocorrect-skip-sanity-checks", "allow-override"));
    private static final Set<String> VALID_CHILDREN_OVERRIDE_RULE = new HashSet<String>(Arrays.asList("property", "autocorrect-input", "pre-waiver"));
    private static final Set<String> VALID_ATTRIBUTES_OVERRIDE_RULE = new HashSet<String>(Arrays.asList("disable", "severity", "name", "title", "description", "description-append", "effort-level", "timeout", "autocorrect", "autocorrect-skip-sanity-checks"));

    public RulesetXMLParser2(OVMProject project, URL url) {
        super(project, url);
    }

    @Override
    public RulesetModel load(RulesetCategoryModel parentCategory) throws Exception {
        String library;
        RulesetModel.LibraryName libraryName;
        RulesetModel rulesetModel = new RulesetModel();
        ArrayList<RulesetCategoryModel> categories = new ArrayList<RulesetCategoryModel>();
        BufferedInputStream stream = new BufferedInputStream(this.getURL().openStream());
        Document document = PositionalXMLReader.readXML((InputStream)stream);
        ((InputStream)stream).close();
        String name = null;
        String description = null;
        String failedSeverity = null;
        Integer defaultCheckTimeout = 0;
        HashMap<String, Integer> effortCategories = new HashMap<String, Integer>();
        int line = 0;
        NodeList rulesetNode = document.getElementsByTagName(TAG_RULESET);
        XMLValidator.checkUniqueRootNode((NodeList)rulesetNode, (String)TAG_RULESET, (String)this.getFilePath());
        Element rulesetElement = (Element)rulesetNode.item(0);
        XMLValidator.checkChildren((Element)rulesetElement, new HashSet<String>(Arrays.asList(TAG_CATEGORY, TAG_CONFIGURATION, TAG_OVERRIDE_CONFIGURATION, "include")), (String)this.getFilePath());
        XMLValidator.checkAttributes((Element)rulesetElement, new HashSet<String>(Arrays.asList("version", ATTR_NAME, ATTR_LIBRARY, ATTR_LINT_LIBRARY_CONTENTS)), (String)this.getFilePath());
        String rulesetName = rulesetElement.getAttribute(ATTR_NAME);
        if (rulesetName != null && !rulesetName.trim().isEmpty()) {
            this.getOVMProject().setRulesetName(rulesetName.trim());
        }
        if ((libraryName = RulesetModel.LibraryName.from(library = rulesetElement.getAttribute(ATTR_LIBRARY))) == RulesetModel.LibraryName.OVM) {
            this.getOVMProject().setLibraryKind(1);
        } else if (libraryName == RulesetModel.LibraryName.UVM) {
            this.getOVMProject().setLibraryKind(2);
        }
        this.getOVMProject().setLintLibraryContents(Boolean.parseBoolean(rulesetElement.getAttribute(ATTR_LINT_LIBRARY_CONTENTS)));
        String configurationTag = TAG_OVERRIDE_CONFIGURATION;
        NodeList configurationNode = rulesetElement.getElementsByTagName(configurationTag);
        XMLValidator.checkOptionalOneElement((NodeList)configurationNode, (String)configurationTag, (String)TAG_RULESET, (Element)rulesetElement, (String)this.getFilePath());
        if (configurationNode.getLength() == 0) {
            configurationTag = TAG_CONFIGURATION;
            configurationNode = rulesetElement.getElementsByTagName(configurationTag);
            XMLValidator.checkOptionalOneElement((NodeList)configurationNode, (String)configurationTag, (String)TAG_RULESET, (Element)rulesetElement, (String)this.getFilePath());
        }
        Element configurationElement = null;
        RulesetConfiguration configuration = new RulesetConfiguration();
        configuration.setIsOverrideConfig(configurationTag.equals(TAG_OVERRIDE_CONFIGURATION));
        HashMap<String, DVTPair<Integer, Integer>> threadDumpRules = new HashMap<String, DVTPair<Integer, Integer>>();
        HashSet<String> histogramDumpRules = new HashSet<String>();
        if (configurationNode.getLength() > 0) {
            configurationElement = (Element)configurationNode.item(0);
            XMLValidator.checkChildren((Element)configurationElement, new HashSet<String>(Arrays.asList(TAG_ARCHITECTURE, TAG_SKIP_FILE, TAG_SKIP_ELEMENT, TAG_FAILED, TAG_ANNOTATION, TAG_INCLUDE_HTML_CODE, TAG_INCLUDE_CREATION_DATE, TAG_EFFORT_LEVELS, "timeout", TAG_THREAD_DUMP, TAG_HISTOGRAM_DUMP)), (String)this.getFilePath());
            NodeList architectureNode = configurationElement.getElementsByTagName(TAG_ARCHITECTURE);
            XMLValidator.checkOptionalOneElement((NodeList)architectureNode, (String)TAG_ARCHITECTURE, (String)configurationTag, (Element)configurationElement, (String)this.getFilePath());
            Element architectureElement = null;
            RulesetArchitecture architecture = new RulesetArchitecture();
            if (architectureNode.getLength() > 0) {
                architectureElement = (Element)architectureNode.item(0);
                XMLValidator.checkChildren((Element)architectureElement, new HashSet<String>(Arrays.asList(TAG_COMPONENT)), (String)this.getFilePath());
                NodeList componentsList = architectureElement.getElementsByTagName(TAG_COMPONENT);
                XMLValidator.checkAtLeastOneElement((NodeList)componentsList, (String)TAG_COMPONENT, (String)TAG_ARCHITECTURE, (Element)architectureElement, (String)this.getFilePath());
                int i = 0;
                while (i < componentsList.getLength()) {
                    Element component = (Element)componentsList.item(i);
                    XMLValidator.checkAttributes((Element)component, new HashSet<String>(Arrays.asList(ATTR_BASE_CLASS, ATTR_TYPE)), (String)this.getFilePath());
                    RulesetComponent.ComponentType componentType = this.getComponentType(component);
                    if (component.hasAttribute(ATTR_BASE_CLASS)) {
                        String baseClass = null;
                        if (component.hasAttribute(ATTR_BASE_CLASS)) {
                            baseClass = component.getAttribute(ATTR_BASE_CLASS);
                        }
                        RulesetComponent rulesetComponent = new RulesetComponent();
                        rulesetComponent.setType(componentType);
                        rulesetComponent.setBaseClass(baseClass);
                        architecture.addComponent(rulesetComponent);
                    }
                    ++i;
                }
            }
            configuration.setArchitecture(architecture);
            AnnotationManager haProcessor = new AnnotationManager();
            NodeList annotationsList = configurationElement.getElementsByTagName(TAG_ANNOTATION);
            int i = 0;
            while (i < annotationsList.getLength()) {
                Element annotationElement = (Element)annotationsList.item(i);
                this.checkAnnotation(annotationElement, haProcessor);
                ++i;
            }
            configuration.setAnnotationManager(haProcessor);
            NodeList skipFileList = configurationElement.getElementsByTagName(TAG_SKIP_FILE);
            XMLValidator.checkOptionalOneElement((NodeList)skipFileList, (String)TAG_SKIP_FILE, (String)configurationTag, (Element)configurationElement, (String)this.getFilePath());
            if (skipFileList.getLength() > 0) {
                Element skipFile = (Element)skipFileList.item(0);
                XMLValidator.checkAttributes((Element)skipFile, new HashSet<String>(Arrays.asList("name-pattern")), (String)this.getFilePath());
                String skipFileNamePattern = skipFile.getAttribute("name-pattern");
                XMLValidator.checkValidRegexString((String)skipFileNamePattern, (String)"name-pattern", (String)this.getFilePath(), (int)XMLValidator.getLineFromElement((Element)skipFile));
                if (skipFileNamePattern != null && !skipFileNamePattern.isEmpty()) {
                    configuration.setSkipFiles(skipFileNamePattern);
                }
            }
            NodeList skipElementList = configurationElement.getElementsByTagName(TAG_SKIP_ELEMENT);
            XMLValidator.checkOptionalOneElement((NodeList)skipElementList, (String)TAG_SKIP_ELEMENT, (String)configurationTag, (Element)configurationElement, (String)this.getFilePath());
            if (skipElementList.getLength() > 0) {
                Element skipElement = (Element)skipElementList.item(0);
                XMLValidator.checkAttributes((Element)skipElement, new HashSet<String>(Arrays.asList("name-pattern")), (String)this.getFilePath());
                String skipElementNamePattern = skipElement.getAttribute("name-pattern");
                XMLValidator.checkValidRegexString((String)skipElementNamePattern, (String)"name-pattern", (String)this.getFilePath(), (int)XMLValidator.getLineFromElement((Element)skipElement));
                if (skipElementNamePattern != null && !skipElementNamePattern.isEmpty()) {
                    configuration.setSkipElements(skipElementNamePattern);
                }
            }
            NodeList failedSeverityList = configurationElement.getElementsByTagName(TAG_FAILED);
            XMLValidator.checkOptionalOneElement((NodeList)failedSeverityList, (String)TAG_FAILED, (String)configurationTag, (Element)configurationElement, (String)this.getFilePath());
            if (failedSeverityList.getLength() > 0) {
                Element failedSeverityElem = (Element)failedSeverityList.item(0);
                XMLValidator.checkAttributes((Element)failedSeverityElem, new HashSet<String>(Arrays.asList(ATTR_SEVERITY)), (String)this.getFilePath());
                failedSeverity = failedSeverityElem.getAttribute(ATTR_SEVERITY);
                if (failedSeverity == null || failedSeverity.equals("")) {
                    failedSeverity = null;
                }
            }
            NodeList includeHTMLCode = configurationElement.getElementsByTagName(TAG_INCLUDE_HTML_CODE);
            XMLValidator.checkOptionalOneElement((NodeList)includeHTMLCode, (String)TAG_INCLUDE_HTML_CODE, (String)configurationTag, (Element)configurationElement, (String)this.getFilePath());
            if (includeHTMLCode.getLength() > 0) {
                configuration.setIncludeHTMLCode(true);
            }
            NodeList includeCreateionDate = configurationElement.getElementsByTagName(TAG_INCLUDE_CREATION_DATE);
            XMLValidator.checkOptionalOneElement((NodeList)includeCreateionDate, (String)TAG_INCLUDE_CREATION_DATE, (String)configurationTag, (Element)configurationElement, (String)this.getFilePath());
            if (includeCreateionDate.getLength() > 0) {
                configuration.setIncludeCreationDate(true);
            }
            NodeList effortLevelsNodes = configurationElement.getElementsByTagName(TAG_EFFORT_LEVELS);
            XMLValidator.checkOptionalOneElement((NodeList)effortLevelsNodes, (String)TAG_EFFORT_LEVELS, (String)configurationTag, (Element)configurationElement, (String)this.getFilePath());
            if (effortLevelsNodes.getLength() > 0) {
                Element effortLevelsElement = (Element)effortLevelsNodes.item(0);
                NodeList effortNodes = effortLevelsElement.getElementsByTagName(TAG_EFFORT);
                int k = 0;
                while (k < effortNodes.getLength()) {
                    String time;
                    Element effortElement = (Element)effortNodes.item(k);
                    XMLValidator.checkAttributes((Element)effortElement, new HashSet<String>(Arrays.asList(ATTR_LEVEL, ATTR_TIME)), (String)this.getFilePath());
                    String level = effortElement.getAttribute(ATTR_LEVEL);
                    if (level != null && !level.trim().isEmpty() && (time = effortElement.getAttribute(ATTR_TIME)) != null && !time.trim().isEmpty()) {
                        try {
                            effortCategories.put(level.trim().toLowerCase(), RulesetXMLParser2.parseEffort(time.trim()));
                        }
                        catch (Exception exception) {}
                    }
                    ++k;
                }
            }
            configuration.setHasEffortEstimation(!effortCategories.isEmpty());
            NodeList threadDumpNode = configurationElement.getElementsByTagName(TAG_THREAD_DUMP);
            if (threadDumpNode.getLength() > 0) {
                Element threadDumpElement = (Element)threadDumpNode.item(0);
                XMLValidator.checkAttributes((Element)threadDumpElement, new HashSet<String>(Arrays.asList(ATTR_INTERVAL, ATTR_DELAY, ATTR_RULES)), (String)this.getFilePath());
                try {
                    String periodAttribute = threadDumpElement.getAttribute(ATTR_INTERVAL);
                    int defaultPeriodMS = periodAttribute.isEmpty() ? 200 : Integer.parseInt(periodAttribute);
                    String delayAttribute = threadDumpElement.getAttribute(ATTR_DELAY);
                    int defaultDelayMS = delayAttribute.isEmpty() ? 0 : Integer.parseInt(delayAttribute);
                    String[] rules = DVTStringUtil.split((Pattern)DVTStringUtil.COMMA, (String)threadDumpElement.getAttribute(ATTR_RULES));
                    int k = 0;
                    while (k < rules.length) {
                        threadDumpRules.put(rules[k].trim(), (DVTPair<Integer, Integer>)new DVTPair((Object)defaultPeriodMS, (Object)defaultDelayMS));
                        ++k;
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
            configuration.setThreadDumpRules(threadDumpRules);
            NodeList histogramDumpNode = configurationElement.getElementsByTagName(TAG_HISTOGRAM_DUMP);
            if (histogramDumpNode.getLength() > 0) {
                Element histogramDumpElement = (Element)histogramDumpNode.item(0);
                XMLValidator.checkAttributes((Element)histogramDumpElement, new HashSet<String>(Arrays.asList(ATTR_RULES)), (String)this.getFilePath());
                try {
                    String[] rules = DVTStringUtil.split((Pattern)DVTStringUtil.COMMA, (String)histogramDumpElement.getAttribute(ATTR_RULES));
                    int k = 0;
                    while (k < rules.length) {
                        histogramDumpRules.add(rules[k].trim());
                        ++k;
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
            configuration.setHistogramDumpRules(histogramDumpRules);
            NodeList timeoutElementNodes = configurationElement.getElementsByTagName("timeout");
            XMLValidator.checkOptionalOneElement((NodeList)timeoutElementNodes, (String)"timeout", (String)configurationTag, (Element)configurationElement, (String)this.getFilePath());
            if (timeoutElementNodes.getLength() > 0) {
                String processTimeoutValue;
                String sessionTimeoutValue;
                Element timeoutElement = (Element)timeoutElementNodes.item(0);
                XMLValidator.checkAttributes((Element)timeoutElement, new HashSet<String>(Arrays.asList(ATTR_CHECK, ATTR_SESSION, ATTR_PROCESS)), (String)this.getFilePath());
                String checkTimeoutValue = timeoutElement.getAttribute(ATTR_CHECK);
                if (checkTimeoutValue != null && !checkTimeoutValue.isEmpty()) {
                    try {
                        defaultCheckTimeout = Integer.parseInt(checkTimeoutValue);
                    }
                    catch (NumberFormatException numberFormatException) {
                        defaultCheckTimeout = 0;
                    }
                }
                if ((sessionTimeoutValue = timeoutElement.getAttribute(ATTR_SESSION)) != null && !sessionTimeoutValue.isEmpty()) {
                    try {
                        configuration.setSessionTimeout(Integer.parseInt(sessionTimeoutValue));
                    }
                    catch (NumberFormatException numberFormatException) {
                        configuration.setSessionTimeout(0);
                    }
                }
                if ((processTimeoutValue = timeoutElement.getAttribute(ATTR_PROCESS)) != null && !processTimeoutValue.isEmpty()) {
                    try {
                        configuration.setProcessTimeout(Integer.parseInt(processTimeoutValue));
                    }
                    catch (NumberFormatException numberFormatException) {
                        configuration.setProcessTimeout(0);
                    }
                }
            }
        }
        rulesetModel.setConfiguration(configuration);
        NodeList includeNodes = rulesetElement.getElementsByTagName("include");
        int i = 0;
        while (i < includeNodes.getLength()) {
            String[] labels;
            String attribute;
            Element includeFile = (Element)includeNodes.item(i);
            XMLValidator.checkAttributes((Element)includeFile, new HashSet<String>(Arrays.asList("since", "label", "file", "relative", "optional")), (String)this.getFilePath());
            StringBuilder categoryNameSB = new StringBuilder().append("Rules");
            EnumMap<RulesetCategoryModel.FilterField, Predicate<OVMComplianceCheck>> filtersMap = new EnumMap<RulesetCategoryModel.FilterField, Predicate<OVMComplianceCheck>>(RulesetCategoryModel.FilterField.class);
            String since = includeFile.getAttribute("since");
            if (since != null && !since.isEmpty()) {
                if (LintUtils.DATE_PATTERN.matcher(since).matches()) {
                    try {
                        categoryNameSB.append(" added since ").append(since);
                        Date sinceDate = OVMProject.getDateFormat().parse(since);
                        filtersMap.put(RulesetCategoryModel.FilterField.DATE, OVMComplianceCheckFilters.isDateBefore(sinceDate));
                    }
                    catch (ParseException e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                }
                if (LintUtils.VERSION_PATTERN.matcher(since).matches()) {
                    categoryNameSB.append(" added since ").append(since);
                    Map versionsMap = DVTUtilsCommon.INSTANCE.getVersionsMap();
                    if (versionsMap.containsKey(since)) {
                        filtersMap.put(RulesetCategoryModel.FilterField.VERSION, OVMComplianceCheckFilters.isVersionBefore(since));
                    }
                }
            }
            if ((attribute = includeFile.getAttribute("label")) != null && !attribute.isEmpty() && (labels = DVTStringUtil.split((Pattern)DVTStringUtil.COMMA, (String)attribute)) != null && labels.length != 0) {
                EnumSet<RuleLabel> ruleLabels = EnumSet.noneOf(RuleLabel.class);
                int j = 0;
                while (j < labels.length) {
                    RuleLabel ruleLabel = RuleLabel.valueOfString(labels[j].trim());
                    if (ruleLabel == null) {
                        SAXParseException exception = new SAXParseException("The specified label '" + labels[j] + "' does not exist", this.getFilePath(), this.getFilePath(), line, 0);
                        throw new XMLException((Throwable)exception, this.getFilePath());
                    }
                    ruleLabels.add(ruleLabel);
                    ++j;
                }
                filtersMap.put(RulesetCategoryModel.FilterField.LABEL, OVMComplianceCheckFilters.hasLabels(ruleLabels).negate());
                categoryNameSB.append(" labeled with ").append(attribute);
            }
            if (!filtersMap.isEmpty()) {
                RulesetCategoryModel includedCategory = new RulesetCategoryModel(categoryNameSB.toString(), "", XMLValidator.getLineFromElement((Element)includeFile), filtersMap);
                DefaultRuleset.addChecksToIncludedCategory(this.getOVMProject(), includedCategory);
                rulesetModel.addCategory(includedCategory);
            }
            ++i;
        }
        NodeList categoryNodes = rulesetElement.getElementsByTagName(TAG_CATEGORY);
        int i2 = 0;
        while (i2 < categoryNodes.getLength()) {
            Element categoryElement = (Element)categoryNodes.item(i2);
            XMLValidator.checkChildren((Element)categoryElement, new HashSet<String>(Arrays.asList(TAG_TAG, TAG_RULE, TAG_OVERRIDE_RULE)), (String)this.getFilePath());
            XMLValidator.checkAttributes((Element)categoryElement, new HashSet<String>(Arrays.asList(ATTR_NAME, ATTR_DESCRIPTION)), (String)this.getFilePath());
            name = categoryElement.getAttribute(ATTR_NAME);
            description = categoryElement.getAttribute(ATTR_DESCRIPTION);
            RulesetCategoryModel category = new RulesetCategoryModel(name, description, XMLValidator.getLineFromElement((Element)categoryElement));
            categories.add(category);
            LinkedHashMap<String, List<String>> categoryAnnotationsByTagIdMap = new LinkedHashMap<String, List<String>>();
            this.parseTagNodes(categoryElement.getElementsByTagName(TAG_TAG), categoryElement, categoryAnnotationsByTagIdMap);
            NodeList ruleNodes = categoryElement.getElementsByTagName(TAG_RULE);
            NodeList overrideRuleNodes = categoryElement.getElementsByTagName(TAG_OVERRIDE_RULE);
            TreeMap<Integer, Element> categoryChildrenMap = this.getCategoryChildrenOrderedMap(ruleNodes, overrideRuleNodes, categoryElement);
            RulesetCategoryModel checkCategory = parentCategory == null ? category : parentCategory;
            for (Map.Entry<Integer, Element> entry : categoryChildrenMap.entrySet()) {
                RulesetCheckModel ruleModel;
                line = entry.getKey();
                Element element = entry.getValue();
                if (TAG_RULE.equals(element.getTagName())) {
                    ruleModel = new RulesetDeclarationCheckModel(element, checkCategory);
                    this.populateCheckModel(ruleModel, VALID_CHILDREN_RULE, VALID_ATTRIBUTES_RULE, failedSeverity, defaultCheckTimeout, effortCategories, true);
                    String id = this.parseSimpleRuleAttribute(element, ATTR_ID);
                    if (id == null || id.isEmpty()) {
                        SAXParseException exception = new SAXParseException("There is no id attribute specified for the rule tag", this.getFilePath(), this.getFilePath(), line, 0);
                        throw new XMLException((Throwable)exception, this.getFilePath());
                    }
                    ((RulesetDeclarationCheckModel)ruleModel).setId(id);
                    ((RulesetDeclarationCheckModel)ruleModel).setAllowOverride(this.parseAllowOveride(element));
                    LinkedHashMap<String, List<String>> annotationsByTagIdMap = new LinkedHashMap<String, List<String>>(categoryAnnotationsByTagIdMap);
                    this.parseTagNodes(element.getElementsByTagName(TAG_TAG), null, annotationsByTagIdMap);
                    ((RulesetDeclarationCheckModel)ruleModel).setAnnotationsByTagIdMap(annotationsByTagIdMap);
                    checkCategory.addCheckModel(ruleModel);
                }
                if (!TAG_OVERRIDE_RULE.equals(element.getTagName())) continue;
                ruleModel = new RulesetOverrideCheckModel(element, checkCategory);
                this.populateCheckModel(ruleModel, VALID_CHILDREN_OVERRIDE_RULE, VALID_ATTRIBUTES_OVERRIDE_RULE, null, null, effortCategories, false);
                String overrideRuleName = ruleModel.getName();
                if (overrideRuleName == null || overrideRuleName.isEmpty()) {
                    SAXParseException exception = new SAXParseException("There is no name attribute specified for the override-rule tag", this.getFilePath(), this.getFilePath(), ruleModel.getLine(), 0);
                    throw new XMLException((Throwable)exception, this.getFilePath());
                }
                checkCategory.addCheckModel(ruleModel);
            }
            ++i2;
        }
        rulesetModel.addCategories(categories);
        return rulesetModel;
    }

    private TreeMap<Integer, Element> getCategoryChildrenOrderedMap(NodeList ruleNodes, NodeList overrideRuleNodes, Element categoryElement) {
        int j;
        int line = 0;
        TreeMap<Integer, Element> categoryRuleChildrenMap = new TreeMap<Integer, Element>();
        if (ruleNodes != null) {
            j = 0;
            while (j < ruleNodes.getLength()) {
                Element ruleElement = (Element)ruleNodes.item(j);
                line = XMLValidator.getLineFromElement((Element)ruleElement);
                categoryRuleChildrenMap.put(line, ruleElement);
                ++j;
            }
        }
        if (overrideRuleNodes != null) {
            j = 0;
            while (j < overrideRuleNodes.getLength()) {
                Element overrideRuleElement = (Element)overrideRuleNodes.item(j);
                line = XMLValidator.getLineFromElement((Element)overrideRuleElement);
                categoryRuleChildrenMap.put(line, overrideRuleElement);
                ++j;
            }
        }
        if (categoryRuleChildrenMap.size() == 0) {
            line = XMLValidator.getLineFromElement((Element)categoryElement);
            String tags = TAG_RULE + " or " + TAG_OVERRIDE_RULE;
            SAXParseException exception = new SAXParseException("Element '" + categoryElement + "' must contain at least one '" + tags + "' element", this.getFilePath(), this.getFilePath(), line, 0);
            throw new XMLException((Throwable)exception, this.getFilePath());
        }
        return categoryRuleChildrenMap;
    }

    private void populateCheckModel(RulesetCheckModel rulesetCheckModel, Set<String> validChildrenNames, Set<String> validAttributesNames, String failedSeverity, Integer defaultCheckTimeout, Map<String, Integer> effortCategories, boolean useDefaultEffortValue) {
        DVTPair<String, String> parsedPreWaiver;
        Element element = rulesetCheckModel.getElement();
        XMLValidator.checkChildren((Element)element, validChildrenNames, (String)this.getFilePath());
        XMLValidator.checkAttributes((Element)element, validAttributesNames, (String)this.getFilePath());
        int line = XMLValidator.getLineFromElement((Element)element);
        rulesetCheckModel.setFilePath(this.getFilePath());
        rulesetCheckModel.setLine(line);
        rulesetCheckModel.setName(this.parseSimpleRuleAttribute(element, ATTR_NAME));
        rulesetCheckModel.setTitle(this.parseSimpleRuleAttribute(element, ATTR_TITLE));
        rulesetCheckModel.setDescription(this.parseSimpleRuleAttribute(element, ATTR_DESCRIPTION));
        rulesetCheckModel.setDescriptionAppend(this.parseSimpleRuleAttribute(element, ATTR_DESCRIPTION_APPEND));
        rulesetCheckModel.setTimeout(this.parseTimeout(defaultCheckTimeout, element));
        rulesetCheckModel.setEffort(this.parseEffortValue(effortCategories, element, useDefaultEffortValue));
        rulesetCheckModel.setSeverity(this.parseSeverity(failedSeverity, element));
        rulesetCheckModel.setAutoCorrectEnabled(this.parseAutoCorrectFlag(element));
        rulesetCheckModel.setAutoCorrectSkipSanityChecksEnabled(this.parseAutoCorrectSkipSanityChecksFlag(element));
        if (this.parseDisabled(line, element)) {
            rulesetCheckModel.setSeverity(CheckStatus.DISABLED);
        }
        if ((parsedPreWaiver = this.parsePrewaiver(element)) != null) {
            rulesetCheckModel.setIncludePrewaiver((String)parsedPreWaiver.getKey());
            rulesetCheckModel.setExcludePrewaiver((String)parsedPreWaiver.getValue());
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        HashMap<String, String> propertiesAppend = new HashMap<String, String>();
        this.parseProperties(element, properties, propertiesAppend);
        rulesetCheckModel.setProperties(properties);
        rulesetCheckModel.setPropertiesAppend(propertiesAppend);
        rulesetCheckModel.setAutocorrectInputs(this.parseAutoCorrectInputs(element));
    }

    private boolean parseAllowOveride(Element ruleElement) {
        String allowOverride = ruleElement.getAttribute(ATTR_ALLOW_OVERRIDE);
        if (allowOverride == null || allowOverride.isEmpty()) {
            return true;
        }
        if (allowOverride.equalsIgnoreCase("none")) {
            return false;
        }
        SAXParseException exception = new SAXParseException("Invalid allow-override attribute: " + allowOverride + " for rule tag", this.getFilePath(), this.getFilePath(), XMLValidator.getLineFromElement((Element)ruleElement), 0);
        throw new XMLException((Throwable)exception, this.getFilePath());
    }

    private Map<String, String> parseAutoCorrectInputs(Element ruleElement) {
        HashMap<String, String> map = new HashMap<String, String>();
        NodeList autoCorrectInputNodes = ruleElement.getElementsByTagName(TAG_AUTO_CORRECT_INPUT);
        int k = 0;
        while (k < autoCorrectInputNodes.getLength()) {
            Element inputElement = (Element)autoCorrectInputNodes.item(k);
            XMLValidator.checkAttributes((Element)inputElement, new HashSet<String>(Arrays.asList(ATTR_KEY, ATTR_VALUE)), (String)this.getFilePath());
            String key = inputElement.getAttribute(ATTR_KEY);
            if (key != null && !(key = key.trim()).isEmpty()) {
                String value = inputElement.getAttribute(ATTR_VALUE);
                map.put(key, value);
            }
            ++k;
        }
        return map;
    }

    private void parseProperties(Element ruleElement, Map<String, String> properties, Map<String, String> propertiesAppend) {
        NodeList propertyNodes = ruleElement.getElementsByTagName(TAG_PROPERTY);
        int k = 0;
        while (k < propertyNodes.getLength()) {
            String valueAppend;
            Element propertyElement = (Element)propertyNodes.item(k);
            XMLValidator.checkAttributes((Element)propertyElement, new HashSet<String>(Arrays.asList(ATTR_KEY, ATTR_VALUE, ATTR_VALUE_APPEND)), (String)this.getFilePath());
            String key = XMLValidator.checkMandatoryAttribute((Element)propertyElement, (String)ATTR_KEY, (String)this.getFilePath());
            if (properties.containsKey(key)) {
                int line = XMLValidator.getLineFromElement((Element)propertyElement);
                SAXParseException exception = new SAXParseException("Element 'rule' contains the parameter '" + key + "' specified multiple times", this.getFilePath(), this.getFilePath(), line, 0);
                throw new XMLException((Throwable)exception, this.getFilePath());
            }
            String value = propertyElement.getAttribute(ATTR_VALUE);
            properties.put(key, value);
            Attr valueAppendAttr = propertyElement.getAttributeNode(ATTR_VALUE_APPEND);
            if (valueAppendAttr != null && (valueAppend = propertyElement.getAttribute(ATTR_VALUE_APPEND)) != null) {
                propertiesAppend.put(key, valueAppend);
            }
            ++k;
        }
    }

    private Boolean parseAutoCorrectFlag(Element ruleElement) {
        String autoCorrectEnabled = ruleElement.getAttribute(ATTR_AUTO_CORRECT);
        if (autoCorrectEnabled == null || autoCorrectEnabled.isEmpty()) {
            return null;
        }
        return "on".equalsIgnoreCase(autoCorrectEnabled);
    }

    private Boolean parseAutoCorrectSkipSanityChecksFlag(Element ruleElement) {
        String skipSanityChecks = ruleElement.getAttribute(ATTR_AUTO_CORRECT_SKIP_SANITY_CHECKS);
        if (skipSanityChecks == null || skipSanityChecks.isEmpty()) {
            return null;
        }
        return "true".equalsIgnoreCase(skipSanityChecks);
    }

    private Integer parseEffortValue(Map<String, Integer> effortCategories, Element ruleElement, boolean useDefaultEffortValue) {
        if (effortCategories == null || effortCategories.isEmpty()) {
            return null;
        }
        String effortLevel = ruleElement.getAttribute(ATTR_EFFORT_LEVEL);
        Integer effortValue = null;
        if (effortLevel != null && !effortLevel.trim().isEmpty()) {
            effortValue = effortCategories.get(effortLevel.trim().toLowerCase());
        }
        if (!useDefaultEffortValue) {
            return null;
        }
        if (effortValue == null) {
            effortValue = effortCategories.get("default");
        }
        if (effortValue == null) {
            effortValue = 1;
        }
        return effortValue;
    }

    private Integer parseTimeout(Integer defaultCheckTimeout, Element ruleElement) {
        String timeoutValue = ruleElement.getAttribute("timeout");
        Integer timeout = defaultCheckTimeout;
        if (timeoutValue != null && !timeoutValue.isEmpty()) {
            try {
                timeout = Integer.parseInt(timeoutValue);
            }
            catch (NumberFormatException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        return timeout;
    }

    private String parseSimpleRuleAttribute(Element ruleElement, String attribute) {
        String attributeResult = ruleElement.getAttribute(attribute);
        if (attributeResult != null && !attributeResult.isEmpty()) {
            return attributeResult;
        }
        return null;
    }

    private boolean parseDisabled(int line, Element ruleElement) {
        String disable = ruleElement.getAttribute(ATTR_DISABLE);
        if (disable != null && disable.equalsIgnoreCase("true")) {
            return true;
        }
        if (disable != null && !disable.isEmpty() && !disable.equalsIgnoreCase("false")) {
            SAXParseException exception = new SAXParseException("Invalid disable attribute: " + disable + " for rule tag", this.getFilePath(), this.getFilePath(), line, 0);
            throw new XMLException((Throwable)exception, this.getFilePath());
        }
        return false;
    }

    private CheckStatus parseSeverity(String failedSeverity, Element ruleElement) {
        String severity = ruleElement.getAttribute(ATTR_SEVERITY);
        if (!severity.isEmpty()) {
            return CheckStatus.valueOf(severity);
        }
        if (failedSeverity != null) {
            return CheckStatus.valueOf(failedSeverity);
        }
        return null;
    }

    private DVTPair<String, String> parsePrewaiver(Element ruleElement) {
        NodeList waiverNodes = ruleElement.getElementsByTagName(TAG_PRE_WAIVER);
        if (waiverNodes.getLength() > 0) {
            Element path = (Element)waiverNodes.item(0);
            XMLValidator.checkAttributes((Element)path, new HashSet<String>(Arrays.asList(ATTR_INCLUDE_PATH, ATTR_EXCLUDE_PATH)), (String)this.getFilePath());
            String include = path.getAttribute(ATTR_INCLUDE_PATH);
            XMLValidator.checkValidRegexString((String)include, (String)ATTR_INCLUDE_PATH, (String)this.getFilePath(), (int)XMLValidator.getLineFromElement((Element)path));
            String includeReplaced = DVTUtilsCommon.INSTANCE.replaceAllSystemVariables((CharSequence)include, DVTUtilsCommon.ReplaceSysvarsPolicy.RETURN_NULL, envVarName -> BuildConfigManager.getUserDefinedEnvVar((IProject)this.getOVMProject().getProject(), (String)envVarName, (BuildConfigManagerCommon.EnvVarReplacementPriorityPolicy)BuildConfigManagerCommon.EnvVarReplacementPriorityPolicy.LAST_INVOCATION));
            XMLValidator.checkUnresolvableVariable((String)includeReplaced, (String)include, (String)this.getFilePath(), (int)XMLValidator.getLineFromElement((Element)path));
            String exclude = path.getAttribute(ATTR_EXCLUDE_PATH);
            XMLValidator.checkValidRegexString((String)exclude, (String)ATTR_EXCLUDE_PATH, (String)this.getFilePath(), (int)XMLValidator.getLineFromElement((Element)path));
            String excludeReplaced = DVTUtilsCommon.INSTANCE.replaceAllSystemVariables((CharSequence)exclude, DVTUtilsCommon.ReplaceSysvarsPolicy.RETURN_NULL, envVarName -> BuildConfigManager.getUserDefinedEnvVar((IProject)this.getOVMProject().getProject(), (String)envVarName, (BuildConfigManagerCommon.EnvVarReplacementPriorityPolicy)BuildConfigManagerCommon.EnvVarReplacementPriorityPolicy.LAST_INVOCATION));
            XMLValidator.checkUnresolvableVariable((String)excludeReplaced, (String)exclude, (String)this.getFilePath(), (int)XMLValidator.getLineFromElement((Element)path));
            return new DVTPair((Object)(includeReplaced.isEmpty() ? null : includeReplaced), (Object)(excludeReplaced.isEmpty() ? null : excludeReplaced));
        }
        return null;
    }

    private RulesetComponent.ComponentType getComponentType(Element component) {
        String type = component.getAttribute(ATTR_TYPE);
        Object lineNumber = component.getUserData("lineNumber");
        int line = 0;
        if (lineNumber instanceof String) {
            line = Integer.parseInt((String)lineNumber);
        }
        if (type == null || type.equals("")) {
            SAXParseException exception = new SAXParseException("There is no type attribute specified for the component tag", this.getFilePath(), this.getFilePath(), line, 0);
            throw new XMLException((Throwable)exception, this.getFilePath());
        }
        RulesetComponent.ComponentType componentType = RulesetComponent.ComponentType.from(type);
        if (componentType == null) {
            SAXParseException exception = new SAXParseException("Invalid type attribute: " + type + " specified for the component tag", this.getFilePath(), this.getFilePath(), line, 0);
            throw new XMLException((Throwable)exception, this.getFilePath());
        }
        return componentType;
    }

    private void checkAnnotation(Element annotationElement, AnnotationManager haProcessor) {
        String haName;
        Object lineNumber = annotationElement.getUserData("lineNumber");
        int line = 0;
        if (lineNumber instanceof String) {
            line = Integer.parseInt((String)lineNumber);
        }
        if ((haName = annotationElement.getAttribute(ATTR_NAME)) == null || (haName = haName.trim()).isEmpty()) {
            SAXParseException exception = new SAXParseException("There is no name attribute specified for the annotation tag", this.getFilePath(), this.getFilePath(), line, 0);
            throw new XMLException((Throwable)exception, this.getFilePath());
        }
        String type = annotationElement.getAttribute(ATTR_TYPE);
        if (type == null || type.equals("")) {
            SAXParseException exception = new SAXParseException("There is no type attribute specified for the annotation tag", this.getFilePath(), this.getFilePath(), line, 0);
            throw new XMLException((Throwable)exception, this.getFilePath());
        }
        AnnotationType haType = AnnotationType.from(type);
        if (haType == null) {
            SAXParseException exception = new SAXParseException("Invalid type attribute: " + type + " specified for the annotation tag", this.getFilePath(), this.getFilePath(), line, 0);
            throw new XMLException((Throwable)exception, this.getFilePath());
        }
        Set<AnnotationLocation> haLocation = AnnotationLocation.from(annotationElement.getAttribute(ATTR_SHOW_IN));
        if (haLocation == null) {
            SAXParseException exception = new SAXParseException("Invalid location attribute inside: " + annotationElement.getAttribute(ATTR_SHOW_IN) + " specified for the annotation", this.getFilePath(), this.getFilePath(), line, 0);
            throw new XMLException((Throwable)exception, this.getFilePath());
        }
        if (haType == AnnotationType.FS) {
            String fsField = annotationElement.getAttribute(ATTR_FS_FIELD);
            if (fsField == null || fsField.isEmpty()) {
                SAXParseException exception = new SAXParseException("There is no fs-field attribute specified for the annotation tag", this.getFilePath(), this.getFilePath(), line, 0);
                throw new XMLException((Throwable)exception, this.getFilePath());
            }
            AnnotationFsField haFsField = AnnotationField.from(AnnotationFsField.class, fsField);
            if (haFsField == null) {
                SAXParseException exception = new SAXParseException("Invalid fs-field attribute: " + fsField + " specified for the annotation tag", this.getFilePath(), this.getFilePath(), line, 0);
                throw new XMLException((Throwable)exception, this.getFilePath());
            }
            haProcessor.addAnnotation(haName, haType, haLocation, haFsField);
        } else if (haType == AnnotationType.GIT) {
            String gitField = annotationElement.getAttribute(ATTR_GIT_FIELD);
            if (gitField == null || gitField.isEmpty()) {
                SAXParseException exception = new SAXParseException("There is no git-field attribute specified for the annotation tag", this.getFilePath(), this.getFilePath(), line, 0);
                throw new XMLException((Throwable)exception, this.getFilePath());
            }
            AnnotationGitField haGitField = AnnotationField.from(AnnotationGitField.class, gitField);
            if (haGitField == null) {
                SAXParseException exception = new SAXParseException("Invalid git-field attribute: " + gitField + " specified for the annotation tag", this.getFilePath(), this.getFilePath(), line, 0);
                throw new XMLException((Throwable)exception, this.getFilePath());
            }
            haProcessor.addAnnotation(haName, haType, haLocation, haGitField);
        } else if (haType == AnnotationType.P4) {
            String p4Field = annotationElement.getAttribute(ATTR_P4_FIELD);
            if (p4Field == null || p4Field.isEmpty()) {
                SAXParseException exception = new SAXParseException("There is no p4-field attribute specified for the annotation tag", this.getFilePath(), this.getFilePath(), line, 0);
                throw new XMLException((Throwable)exception, this.getFilePath());
            }
            AnnotationP4Field haP4Field = AnnotationField.from(AnnotationP4Field.class, p4Field);
            if (haP4Field == null) {
                SAXParseException exception = new SAXParseException("Invalid p4-field attribute: " + p4Field + " specified for the annotation tag", this.getFilePath(), this.getFilePath(), line, 0);
                throw new XMLException((Throwable)exception, this.getFilePath());
            }
            haProcessor.addAnnotation(haName, haType, haLocation, haP4Field);
        } else if (haType == AnnotationType.SVN) {
            String svnField = annotationElement.getAttribute(ATTR_SVN_FIELD);
            if (svnField == null || svnField.isEmpty()) {
                SAXParseException exception = new SAXParseException("There is no svn-field attribute specified for the annotation tag", this.getFilePath(), this.getFilePath(), line, 0);
                throw new XMLException((Throwable)exception, this.getFilePath());
            }
            AnnotationSvnField haSvnField = AnnotationField.from(AnnotationSvnField.class, svnField);
            if (haSvnField == null) {
                SAXParseException exception = new SAXParseException("Invalid svn-field attribute: " + svnField + " specified for the annotation tag", this.getFilePath(), this.getFilePath(), line, 0);
                throw new XMLException((Throwable)exception, this.getFilePath());
            }
            haProcessor.addAnnotation(haName, haType, haLocation, haSvnField);
        } else if (haType == AnnotationType.CC) {
            String ccField = annotationElement.getAttribute(ATTR_CC_FIELD);
            if (ccField == null || ccField.isEmpty()) {
                SAXParseException exception = new SAXParseException("There is no cc-field attribute specified for the annotation tag", this.getFilePath(), this.getFilePath(), line, 0);
                throw new XMLException((Throwable)exception, this.getFilePath());
            }
            AnnotationCcField haCcField = AnnotationField.from(AnnotationCcField.class, ccField);
            if (haCcField == null) {
                SAXParseException exception = new SAXParseException("Invalid cc-field attribute: " + ccField + " specified for the annotation tag", this.getFilePath(), this.getFilePath(), line, 0);
                throw new XMLException((Throwable)exception, this.getFilePath());
            }
            haProcessor.addAnnotation(haName, haType, haLocation, haCcField);
        } else if (haType == AnnotationType.TAG) {
            String tagId = annotationElement.getAttribute(ATTR_TAG_KEY);
            if (tagId == null || tagId.equals("")) {
                return;
            }
            if (haProcessor.getAnnotationOfType(AnnotationType.TAG).stream().anyMatch(x -> annotationElement.getAttribute(ATTR_NAME).equals(x.getName()))) {
                SAXParseException exception = new SAXParseException("Duplicate name: " + haName + " specified for the annotation tag", this.getFilePath(), this.getFilePath(), line, 0);
                throw new XMLException((Throwable)exception, this.getFilePath());
            }
            if (haProcessor.getAnnotationOfType(AnnotationType.TAG).stream().anyMatch(x -> tagId.equals(x.getArgs()[0]))) {
                SAXParseException exception = new SAXParseException("Duplicate tag key: " + tagId + " specified for the annotation tag key", this.getFilePath(), this.getFilePath(), line, 0);
                throw new XMLException((Throwable)exception, this.getFilePath());
            }
            haProcessor.addAnnotation(haName, haType, haLocation, tagId);
        } else if (haType == AnnotationType.LABEL) {
            if (!haProcessor.getAnnotationOfType(AnnotationType.LABEL).isEmpty()) {
                SAXParseException exception = new SAXParseException("More than one label annotation", this.getFilePath(), this.getFilePath(), line, 0);
                throw new XMLException((Throwable)exception, this.getFilePath());
            }
            haProcessor.addAnnotation(haName, haType, haLocation, new Object[0]);
        }
    }

    static int parseEffort(String value) {
        if (value.matches("[0-9]+")) {
            return Integer.parseInt(value);
        }
        Pattern pattern = Pattern.compile("\\d+[hmsHMS]");
        Matcher matcher = pattern.matcher(value.replaceAll("\\s", ""));
        int result = 0;
        while (matcher.find()) {
            String timeUnit = matcher.group();
            if (timeUnit.matches(".*[hH]")) {
                result += Integer.parseInt(timeUnit.replaceAll("[hH]", "")) * 3600;
                continue;
            }
            if (timeUnit.matches(".*[mM]")) {
                result += Integer.parseInt(timeUnit.replaceAll("[mM]", "")) * 60;
                continue;
            }
            if (!timeUnit.matches(".*[sS]")) continue;
            result += Integer.parseInt(timeUnit.replaceAll("[sS]", ""));
        }
        return result;
    }

    private void parseTagNodes(NodeList tagNodes, Element parentElem, Map<String, List<String>> annotationsByTagIdMap) throws Exception {
        int k = 0;
        while (k < tagNodes.getLength()) {
            Element innerElem = (Element)tagNodes.item(k);
            if (parentElem == null || innerElem.getParentNode().equals(parentElem)) {
                String valueAppend;
                int line = XMLValidator.getLineFromElement((Element)innerElem);
                String key = XMLValidator.checkMandatoryAttribute((Element)innerElem, (String)ATTR_KEY, (String)this.getFilePath());
                XMLValidator.checkAttributes((Element)innerElem, new HashSet<String>(Arrays.asList(ATTR_KEY, ATTR_VALUE, ATTR_VALUE_APPEND)), (String)this.getFilePath());
                ArrayList<String> customTags = new ArrayList<String>();
                String value = innerElem.getAttribute(ATTR_VALUE);
                if (value != null) {
                    value = value.trim();
                }
                if ((valueAppend = innerElem.getAttribute(ATTR_VALUE_APPEND)) != null) {
                    valueAppend = valueAppend.trim();
                }
                if ((value == null || value.isEmpty()) && (valueAppend == null || valueAppend.isEmpty())) {
                    SAXParseException exception = new SAXParseException("Tag element is either missing a value/value-append attribute or the attribute is not valid. At least one of those attributes must be set!", this.getFilePath(), this.getFilePath(), line, 0);
                    throw new XMLException((Throwable)exception, this.getFilePath());
                }
                if (value != null && !value.isEmpty()) {
                    var15_17 = splitStrings = COMMA_PATTERN.split(value);
                    var14_16 = splitStrings.length;
                    int n = 0;
                    while (n < var14_16) {
                        splitString = var15_17[n];
                        if (!(splitString = splitString.trim()).isEmpty()) {
                            customTags.add(splitString);
                        }
                        ++n;
                    }
                    annotationsByTagIdMap.put(key, customTags);
                } else if (valueAppend != null && !valueAppend.isEmpty()) {
                    var15_17 = splitStrings = COMMA_PATTERN.split(valueAppend);
                    var14_16 = splitStrings.length;
                    int n = 0;
                    while (n < var14_16) {
                        splitString = var15_17[n];
                        if (!(splitString = splitString.trim()).isEmpty()) {
                            customTags.add(splitString);
                        }
                        ++n;
                    }
                    List<String> currentAnnotations = annotationsByTagIdMap.get(key);
                    if (currentAnnotations != null) {
                        ArrayList<String> updatedList = new ArrayList<String>(currentAnnotations);
                        updatedList.addAll(customTags);
                        annotationsByTagIdMap.put(key, updatedList);
                    } else {
                        annotationsByTagIdMap.put(key, customTags);
                    }
                }
            }
            ++k;
        }
    }
}

