/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.svtb.AbstractNamePatternParametersCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

public abstract class AbstractBuildPhaseCreationCheck
extends AbstractNamePatternParametersCheck {
    @CheckParameter(defaultValue="false", description="When true, the create call is allowed in a function called from the build phase.", name="allowIndirectCallInstantiation", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowIndirectCallInstantiationValue;
    protected Set<RfField> fieldsCreated;
    protected Map<RfHidAccessArgs, RfField> pushMethodsArguments;
    private boolean indirectVisitorActive;
    protected boolean shouldSkip;

    protected AbstractBuildPhaseCreationCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        Collection<RfClass> classes = this.getClasses();
        if (classes == null || classes.isEmpty()) {
            return;
        }
        this.pushMethodsArguments = new HashMap<RfHidAccessArgs, RfField>();
        for (RfClass classs : classes) {
            if (classs.hasVirtualQualifier()) continue;
            this.notifyCheckAlive();
            if (classs.getFile() != null && this.checkPreWaivers(classs.getFile().getParserPath())) continue;
            Set<RfField> fields = this.getFields(classs);
            if (fields.isEmpty()) {
                this.addMissingFieldHit(classs);
                continue;
            }
            this.fieldsCreated = new HashSet<RfField>();
            this.searchForCreateCalls(classs, fields);
            if (!fields.isEmpty()) {
                for (RfField field : fields) {
                    RfNamedElement fieldScope = field.getEnclosingScope();
                    if (!(fieldScope instanceof RfClass) || classs.equals(fieldScope)) continue;
                    RfClass fieldClass = (RfClass)fieldScope;
                    this.searchForCreateCalls(fieldClass, fields);
                }
            }
            for (RfField env : fields) {
                this.addNotProperlyInstantiatedFieldHit(classs, env);
            }
            this.additionalHits(classs);
        }
    }

    private void searchForCreateCalls(RfClass classs, Set<RfField> fields) {
        RfFunction buildPhase = classs.getFunctionWithPrefix(this.fOVMProject.getBuildPhaseMethodName(), 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
        if (!this.shouldSkip && buildPhase != null) {
            buildPhase.visitHidObject(null, new PushMethodsVisitor(this.pushMethodsArguments, new HashSet<RfFunction>(), classs));
        }
        IndirectFunctionVisitor visitor = null;
        if (this.pAllowIndirectCallInstantiationValue && buildPhase != null) {
            this.indirectVisitorActive = true;
            HashSet<RfFunction> visited = new HashSet<RfFunction>();
            visited.add(buildPhase);
            visitor = new IndirectFunctionVisitor(fields, classs, visited, new HashSet<RfHidAccessArgs>());
            buildPhase.visitHidObject(null, visitor);
            this.indirectVisitorActive = false;
            if (fields.isEmpty()) {
                return;
            }
        }
        HashSet<RfHidAccessArgs> visitedArgs = visitor != null ? visitor.getVisitedArgs() : new HashSet<RfHidAccessArgs>();
        classs.visitHidObject(null, new FunctionVisitor(fields, classs, visitedArgs));
    }

    protected abstract Collection<RfClass> getClasses();

    protected abstract Set<RfField> getFields(RfClass var1);

    protected abstract boolean checkElementType(RfClass var1);

    public abstract void addMissingFieldHit(RfClass var1);

    public abstract void addNotProperlyInstantiatedFieldHit(RfClass var1, RfField var2);

    public abstract void addInstantiationOutsideFunctionHit(ParserPath var1, IRfNamedElement var2, RfHid var3);

    public abstract void addInstantiationOutsideBuildPhaseHit(ParserPath var1, IRfNamedElement var2, RfHid var3);

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    public void checkCreate(RfHidOperator hidOperator, Set<RfField> fields, RfClass classs, ParserPath parserPath, IHidHolder holder, Set<RfHidAccessArgs> visitedArgs) {
        RfFunction enclosingMetod;
        ListContainer right = hidOperator.getRHValues();
        if (right == null || right.isEmpty()) {
            return;
        }
        IHidObject rightHid = (IHidObject)right.get(0);
        if (!(rightHid instanceof RfHidAccessArgs)) {
            return;
        }
        RfHidAccessArgs accessArgs = (RfHidAccessArgs)rightHid;
        if (visitedArgs != null && !visitedArgs.isEmpty() && visitedArgs.contains((Object)accessArgs)) {
            return;
        }
        Hid parentHid = accessArgs.getParentHid();
        if (!(parentHid instanceof RfHid)) {
            return;
        }
        if (!parentHid.isMethodCall(false)) {
            return;
        }
        String methodName = parentHid.getName();
        if (!methodName.equals("create")) {
            return;
        }
        if (!((parentHid = parentHid.getParentHid()) instanceof RfHid)) {
            return;
        }
        String typeName = parentHid.getName();
        if (!typeName.equals("type_id")) {
            return;
        }
        if (!((parentHid = parentHid.getParentHid()) instanceof RfHid)) {
            return;
        }
        IRfNamedElement rightElement = parentHid.getElement();
        if (rightElement instanceof RfField) {
            rightElement = LintUtils.getFieldFinalClassTypeOrNull((RfField)rightElement);
        }
        if (!(rightElement instanceof RfClass)) {
            return;
        }
        if (!this.checkElementType((RfClass)rightElement)) {
            return;
        }
        if (this.pushMethodsArguments.keySet().contains((Object)accessArgs)) {
            RfField field = this.pushMethodsArguments.get((Object)accessArgs);
            fields.remove(field);
            this.fieldsCreated.add(field);
        }
        this.notifyCheckAlive();
        IHidObject left = hidOperator.getLHValue();
        if (!(left instanceof RfHid)) {
            return;
        }
        RfHid leftHid = (RfHid)left;
        IRfNamedElement leftElement = leftHid.getElement();
        if (!(leftElement instanceof RfField)) {
            return;
        }
        RfField field = (RfField)leftElement;
        RfFunction buildPhase = classs.getFunctionWithPrefix(this.fOVMProject.getBuildPhaseMethodName(), 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
        if (buildPhase == null) {
            this.addHit(classs, String.valueOf(this.fOVMProject.getBuildPhaseMethodName()) + "() not found in '" + classs.getFullName() + "'!");
        }
        if ((enclosingMetod = (RfFunction)((RfHidHolder)holder).getScope().getEnclosingScope(RfFunction.class)) == null && !this.indirectVisitorActive) {
            this.addInstantiationOutsideFunctionHit(parserPath, rightElement, leftHid);
            return;
        }
        if (!(enclosingMetod != null && enclosingMetod.getName().equals(this.fOVMProject.getBuildPhaseMethodName()) || this.indirectVisitorActive)) {
            this.addInstantiationOutsideBuildPhaseHit(parserPath, rightElement, leftHid);
            return;
        }
        if (fields.contains(field)) {
            fields.remove(field);
            this.fieldsCreated.add(field);
        }
    }

    public void additionalHits(RfClass classs) {
    }

    public void additionalCheck(RfHid hid, RfFunction function) {
    }

    private final class FunctionVisitor
    implements IHidVisitor<IHidObject> {
        private IHidHolder holder;
        private ParserPath parserPath;
        private Set<RfField> fields;
        private RfClass classs;
        private Set<RfHidAccessArgs> visitedArgs;

        public FunctionVisitor(Set<RfField> fields, RfClass classs, Set<RfHidAccessArgs> visitedArgs) {
            this.fields = fields;
            this.classs = classs;
            this.visitedArgs = visitedArgs;
        }

        public void setHolder(IHidHolder holder) {
            this.holder = holder;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public boolean visit(IHidObject hidObject) {
            if (AbstractBuildPhaseCreationCheck.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            if (hidObject instanceof RfHidOperator) {
                ListContainer rhValues;
                RfHidOperator hidOperator = (RfHidOperator)hidObject;
                if (hidOperator.getRHValues() != null && !(rhValues = hidOperator.getRHValues()).isEmpty() && AbstractBuildPhaseCreationCheck.this.pushMethodsArguments.keySet().contains(rhValues.get(0))) {
                    AbstractBuildPhaseCreationCheck.this.checkCreate(hidOperator, this.fields, this.classs, this.parserPath, this.holder, this.visitedArgs);
                    return true;
                }
                if (!hidOperator.isAssignment()) {
                    return true;
                }
                AbstractBuildPhaseCreationCheck.this.checkCreate(hidOperator, this.fields, this.classs, this.parserPath, this.holder, this.visitedArgs);
                return true;
            }
            if (hidObject instanceof RfHidAccessArgs) {
                RfHidAccessArgs hidAccessArgs = (RfHidAccessArgs)hidObject;
                Hid parentHid = hidAccessArgs.getParentHid();
                if (parentHid == null) {
                    return true;
                }
                IRfNamedElement hidElement = parentHid.getElement();
                if (!(hidElement instanceof RfFunction)) {
                    return true;
                }
                RfFunction function = (RfFunction)hidElement;
                if (function.getName().equals("push_back") || function.getName().equals("push_front")) {
                    HidUtils.flattenToObjects(hidObject2 -> {
                        if (hidObject2 instanceof RfHidOperator) {
                            RfHidOperator hidOperator = (RfHidOperator)hidObject2;
                            AbstractBuildPhaseCreationCheck.this.checkCreate(hidOperator, this.fields, this.classs, this.parserPath, this.holder, this.visitedArgs);
                            ListContainer rhValues = hidOperator.getRHValues();
                            if (rhValues != null && !rhValues.isEmpty() && rhValues.get(0) instanceof RfHidAccessArgs) {
                                this.visitedArgs.add((RfHidAccessArgs)((Object)((Object)rhValues.get(0))));
                            }
                        }
                        return true;
                    }, (IHidObject)hidObject, (Set)HidFlatteningOption.IMPLICITS_EXCLUDED);
                }
                return true;
            }
            return true;
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }
    }

    private final class IndirectFunctionVisitor
    implements IHidVisitor<IHidObject> {
        private Set<RfField> fields;
        private RfClass classs;
        private Set<RfFunction> visited;
        private ParserPath parserPath;
        private IHidHolder holder;
        private Set<RfHidAccessArgs> visitedArgs;

        public IndirectFunctionVisitor(Set<RfField> fields, RfClass classs, Set<RfFunction> visited, Set<RfHidAccessArgs> visitedArgs) {
            this.fields = fields;
            this.classs = classs;
            this.visited = visited;
            this.visitedArgs = visitedArgs;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public void setHolder(IHidHolder holder) {
            this.holder = holder;
        }

        public boolean visit(IHidObject hidObject) {
            if (AbstractBuildPhaseCreationCheck.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            if (hidObject instanceof RfHid) {
                RfFunction tempFunction;
                RfHid hid = (RfHid)hidObject;
                if (!hid.isMethodCall(false)) {
                    return true;
                }
                IRfNamedElement element = hid.getElement();
                if (!(element instanceof RfFunction)) {
                    return true;
                }
                RfFunction function = (RfFunction)element;
                if (function.isPredefined()) {
                    return true;
                }
                if (function.isVirtual() && (tempFunction = LintUtils.getValidVirtualFunction(function, hid, this.classs)) != null) {
                    function = tempFunction;
                }
                AbstractBuildPhaseCreationCheck.this.additionalCheck(hid, function);
                if (this.visited.contains(function)) {
                    return true;
                }
                this.visited.add(function);
                function.visitHidObject(null, new IndirectFunctionVisitor(this.fields, this.classs, this.visited, this.visitedArgs));
            } else if (hidObject instanceof RfHidAccessArgs) {
                RfHidAccessArgs hidAccessArgs = (RfHidAccessArgs)hidObject;
                Hid parentHid = hidAccessArgs.getParentHid();
                if (parentHid == null) {
                    return true;
                }
                IRfNamedElement hidElement = parentHid.getElement();
                if (!(hidElement instanceof RfFunction)) {
                    return true;
                }
                RfFunction function = (RfFunction)hidElement;
                if (function.getName().equals("push_back") || function.getName().equals("push_front")) {
                    HidUtils.flattenToObjects(hidObject2 -> {
                        if (hidObject2 instanceof RfHidOperator) {
                            RfHidOperator hidOperator = (RfHidOperator)hidObject2;
                            AbstractBuildPhaseCreationCheck.this.checkCreate(hidOperator, this.fields, this.classs, this.parserPath, this.holder, this.visitedArgs);
                            ListContainer rhValues = hidOperator.getRHValues();
                            if (rhValues != null && !rhValues.isEmpty() && rhValues.get(0) instanceof RfHidAccessArgs) {
                                this.visitedArgs.add((RfHidAccessArgs)((Object)((Object)rhValues.get(0))));
                            }
                        }
                        return true;
                    }, (IHidObject)hidObject, (Set)HidFlatteningOption.IMPLICITS_EXCLUDED);
                }
            } else if (hidObject instanceof RfHidOperator) {
                RfHidOperator hidOperator = (RfHidOperator)hidObject;
                if (!hidOperator.isAssignment()) {
                    return true;
                }
                AbstractBuildPhaseCreationCheck.this.checkCreate(hidOperator, this.fields, this.classs, this.parserPath, this.holder, this.visitedArgs);
                ListContainer rhValues = hidOperator.getRHValues();
                if (rhValues != null && !rhValues.isEmpty() && rhValues.get(0) instanceof RfHidAccessArgs) {
                    this.visitedArgs.add((RfHidAccessArgs)((Object)rhValues.get(0)));
                }
            }
            return true;
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }

        public Set<RfHidAccessArgs> getVisitedArgs() {
            return this.visitedArgs;
        }
    }

    private static final class PushMethodsVisitor
    extends RfHidVisitor {
        private Map<RfHidAccessArgs, RfField> pushMethodsArgs;
        private Set<RfFunction> visited;
        private RfClass classs;

        public PushMethodsVisitor(Map<RfHidAccessArgs, RfField> pushMethodsArgs, Set<RfFunction> visited, RfClass classs) {
            this.pushMethodsArgs = pushMethodsArgs;
            this.visited = visited;
            this.classs = classs;
        }

        public boolean visit(RfHid hidObject) {
            if (!hidObject.isMethodCall(false)) {
                return true;
            }
            if (!(hidObject.getElement() instanceof RfPredefinedFunction)) {
                RfFunction tempFunction;
                if (!(hidObject.getElement() instanceof RfFunction)) {
                    return true;
                }
                RfFunction calledFunction = (RfFunction)hidObject.getElement();
                if (calledFunction.isVirtual() && (tempFunction = LintUtils.getValidVirtualFunction(calledFunction, hidObject, this.classs)) != null) {
                    calledFunction = tempFunction;
                }
                if (this.visited.contains(calledFunction)) {
                    return true;
                }
                this.visited.add(calledFunction);
                PushMethodsVisitor pushMethodsVisitor = new PushMethodsVisitor(this.pushMethodsArgs, this.visited, this.classs);
                calledFunction.visitHidObject(null, pushMethodsVisitor);
                return true;
            }
            RfPredefinedFunction function = (RfPredefinedFunction)hidObject.getElement();
            if (!function.getName().equals("push_back") && !function.getName().equals("push_front")) {
                return true;
            }
            List methodCalls = MethodCallUtils.getMethodCalls((IHid)hidObject);
            for (MethodCall call : methodCalls) {
                IRfNamedElement fieldNamedElem;
                Hid fieldHid;
                HidAccess fieldAccess;
                String methodName;
                RfHidAccessArgs accessArgs;
                Hid parentHid;
                IHidObject argValue;
                Map.Entry argEntry;
                if (call.argumentValuesMapRaw == null || call.argumentValuesMap.entrySet().size() > 1 || (argEntry = call.argumentValuesMapRaw.entrySet().iterator().next()) == null || !((argValue = (IHidObject)argEntry.getValue()) instanceof RfHidAccessArgs) || !((parentHid = (accessArgs = (RfHidAccessArgs)argValue).getParentHid()) instanceof RfHid) || !parentHid.isMethodCall(false) || !(methodName = parentHid.getName()).equals("create") || !((fieldAccess = hidObject.getParentAccess()) instanceof RfHidAccess) || !((fieldHid = fieldAccess.getParentHid()) instanceof RfHid) || !((fieldNamedElem = fieldHid.getElement()) instanceof RfField)) continue;
                RfField field = (RfField)fieldNamedElem;
                this.pushMethodsArgs.put(accessArgs, field);
            }
            return true;
        }
    }
}

