/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.problems.DVTProblem;
import ro.amiq.dvt.model.problems.Severity;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.CheckStatus;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;

public abstract class AbstractCompilationErrorCheck
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="ERROR", description="Comma separated list of syntactic problem kinds: ERROR, WARNING, INFO, DISABLED.", name="show", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    public HashSet<String> pShowValueAsStrings;
    public Set<Severity> pShowValue = EnumSet.noneOf(Severity.class);
    @CheckParameter(defaultValue="true", description="When true, show each syntactic compilation problem, when false, only show that there are problems.", name="showFailureDetails", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    public boolean pShowFailureDetailsValue;
    @CheckParameter(defaultValue="0", description="Maximum number of hits to be reported. Use 0 to show all.", name="maxNofHits", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.INTEGER)
    public int pMaxNofHitsValue;

    public AbstractCompilationErrorCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    public abstract String getErrorMessage();

    public abstract List<DVTProblem> getIssues();

    @Override
    public void performCheckImpl() {
        List<DVTProblem> issues = this.getIssues();
        if (issues.isEmpty()) {
            return;
        }
        if (!this.pShowFailureDetailsValue) {
            DVTProblem issue = issues.get(0);
            this.addHit(new ParserPath("none"), 0, this.getErrorMessage(), null, false, this.getSeverity() == null ? CheckStatus.valueOf(issue.getSeverity().toString()) : this.getSeverity());
            return;
        }
        for (DVTProblem issue : issues) {
            this.addHit(new ParserPath(issue.getPath()), issue.getLine(), this.getIssueMessage(issue), null, false, this.getSeverity() == null ? CheckStatus.valueOf(issue.getSeverity().toString()) : this.getSeverity());
        }
    }

    public List<DVTProblem> filterAndSort(List<DVTProblem> problems, boolean showNonStandard) {
        ArrayList<DVTProblem> errors = new ArrayList<DVTProblem>();
        ArrayList<DVTProblem> warnings = new ArrayList<DVTProblem>();
        ArrayList<DVTProblem> infos = new ArrayList<DVTProblem>();
        ArrayList<DVTProblem> disabled = new ArrayList<DVTProblem>();
        List<Object> result = new ArrayList<DVTProblem>();
        for (DVTProblem problem : problems) {
            String problemMessage;
            Severity severity = problem.getSeverity();
            if (severity == null || showNonStandard != ((problemMessage = problem.getMessage()).startsWith("NON_STANDARD_") || problemMessage.startsWith("UNSPECIFIED_STANDARD_")) || this.fOVMProject.isOVMFile(problem.getPath())) continue;
            switch (severity) {
                case ERROR: {
                    if (!this.pShowValue.contains(Severity.ERROR)) break;
                    errors.add(problem);
                    break;
                }
                case WARNING: {
                    if (!this.pShowValue.contains(Severity.WARNING)) break;
                    warnings.add(problem);
                    break;
                }
                case INFO: {
                    if (!this.pShowValue.contains(Severity.INFO)) break;
                    infos.add(problem);
                    break;
                }
                case DISABLED: {
                    if (!this.pShowValue.contains(Severity.DISABLED)) break;
                    disabled.add(problem);
                    break;
                }
            }
        }
        errors.sort(DVTProblem.UID_COMPARATOR);
        warnings.sort(DVTProblem.UID_COMPARATOR);
        infos.sort(DVTProblem.UID_COMPARATOR);
        disabled.sort(DVTProblem.UID_COMPARATOR);
        result.addAll(errors);
        result.addAll(warnings);
        result.addAll(infos);
        result.addAll(disabled);
        if (this.pMaxNofHitsValue != 0) {
            result = result.subList(0, Math.min(this.pMaxNofHitsValue, result.size()));
        }
        return result;
    }

    public String getIssueMessage(DVTProblem issue) {
        String message = issue.getMessage();
        if (message.startsWith("NON_STANDARD_")) {
            return message.replaceFirst("NON_STANDARD_", "");
        }
        if (message.startsWith("UNSPECIFIED_STANDARD_")) {
            return message.replaceFirst("UNSPECIFIED_STANDARD_", "");
        }
        if (message.contains(": ")) {
            message = message.substring(message.indexOf(": ") + 2);
        }
        return message;
    }

    @Override
    public CheckStatus getDefaultSeverity() {
        return null;
    }
}

