/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.XVMLintUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfSpecializedClass;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

public abstract class AbstractProperlyInstantiationCheck
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="", name="allowBaseClassInstantiation", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowBaseClassInstantiationValue;
    @CheckParameter(defaultValue="false", description="When true, the create call is allowed in a function called from the build phase.", name="allowIndirectCallInstantiation", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowIndirectCallInstantiationValue;
    @CheckParameter(defaultValue="", description="Comma separated list of additional base classes that allow create calls.", name="allowInstantiationInBaseClasses", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pAllowInstantiationInBaseClassValue;
    @CheckParameter(defaultValue="false", description="", name="allowInstantiationByActiveFieldChecking", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN, isVisible=false)
    protected boolean pAllowInstantiationByActiveFieldChecking;
    private boolean indirectVisitorActive;
    private Map<String, RfClass> properlyInstantiatedClasses;
    private Set<String> unproperlyInstantiatedClasses;
    private Set<RfHidAccessArgs> pushMethodsArguments;

    protected AbstractProperlyInstantiationCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void configure() {
        super.configure();
        if (this.pAllowInstantiationInBaseClassValue == null || this.pAllowInstantiationInBaseClassValue.isEmpty()) {
            return;
        }
        for (String baseClassName : this.pAllowInstantiationInBaseClassValue) {
            RfProject rfProject = this.fOVMProject.getRfProject();
            if (rfProject == null) {
                return;
            }
            RfClass baseClass = rfProject.getClass(baseClassName, true);
            if (baseClass != null) continue;
            this.signalParamError("Class '" + baseClassName + "' not found!", true);
        }
    }

    protected void checkProperlyInstantiation(Collection<RfClass> classesToInstantiate, String msgToInstantiate, Set<ClassesHoldingInstances> wrapperClassesHoldingInstances, RfClass baseClass) {
        if (classesToInstantiate == null) {
            return;
        }
        this.properlyInstantiatedClasses = new HashMap<String, RfClass>();
        this.unproperlyInstantiatedClasses = new HashSet<String>();
        this.pushMethodsArguments = new HashSet<RfHidAccessArgs>();
        for (ClassesHoldingInstances wrapper : wrapperClassesHoldingInstances) {
            for (Map.Entry<String, RfClass> entry : wrapper.getClassHoldingInstances().entrySet()) {
                Set<RfClass> children;
                RfClass classs = entry.getValue();
                if (classs.hasVirtualQualifier() || this.checkPreWaivers(classs.getFile())) continue;
                HashMap<RfField, Map<RfClass, RfClass>> actualFieldTypes = new HashMap<RfField, Map<RfClass, RfClass>>();
                List<RfField> parameters = classs.getParametersWithPrefix("", 384, 2, 2);
                if (parameters != null) {
                    for (RfField param : parameters) {
                        RfClass fieldClassType = LintUtils.getFieldFinalClassTypeOrNull(param, RfTypesResolver.create((IRfScopeElement)classs, classs.getRfProject(), 6));
                        if (fieldClassType instanceof RfSpecializedClass) {
                            fieldClassType = ((RfSpecializedClass)fieldClassType).getGenericClass();
                        }
                        actualFieldTypes.putIfAbsent(param, new HashMap());
                        ((Map)actualFieldTypes.get(param)).put(classs, fieldClassType);
                    }
                }
                if ((children = classs.getChildren()) != null) {
                    for (RfClass child : children) {
                        List<RfField> childParameters = child.getParametersWithPrefix("", 384, 2, 2);
                        if (childParameters == null) continue;
                        for (RfField param : childParameters) {
                            RfClass fieldClassType = LintUtils.getFieldFinalClassTypeOrNull(param, RfTypesResolver.create((IRfScopeElement)child, child.getRfProject(), 6));
                            if (fieldClassType instanceof RfSpecializedClass) {
                                fieldClassType = ((RfSpecializedClass)fieldClassType).getGenericClass();
                            }
                            actualFieldTypes.putIfAbsent(param, new HashMap());
                            ((Map)actualFieldTypes.get(param)).put(child, fieldClassType);
                        }
                    }
                }
                this.searchForCreateCalls(classs, baseClass, msgToInstantiate, wrapper, actualFieldTypes);
            }
        }
        this.fOVMProject.getRfProject().visitHidObject(this.fOVMProject.getRfProject(), new OutsideScopeFunctionVisitor(wrapperClassesHoldingInstances, baseClass, msgToInstantiate));
        for (RfClass classToInstantiate : classesToInstantiate) {
            if (classToInstantiate.hasVirtualQualifier()) continue;
            if (classToInstantiate instanceof RfSpecializedClass) {
                classToInstantiate = ((RfSpecializedClass)classToInstantiate).getGenericClass();
            }
            if (this.checkPreWaivers(classToInstantiate.getFile()) || this.unproperlyInstantiatedClasses.contains(classToInstantiate.getFullName()) || this.properlyInstantiatedClasses.containsKey(classToInstantiate.getFullName())) continue;
            if (this.pAllowBaseClassInstantiationValue) {
                boolean properlyInstantiatedParent = false;
                RfClass parentClass = classToInstantiate.getParent();
                while (parentClass != null) {
                    if (this.properlyInstantiatedClasses.containsKey(parentClass.getFullName())) {
                        properlyInstantiatedParent = true;
                        break;
                    }
                    parentClass = parentClass.getParent();
                }
                if (properlyInstantiatedParent && parentClass != null) continue;
                this.addHit(classToInstantiate, String.valueOf(msgToInstantiate) + " '" + classToInstantiate.getFullName() + "' is not properly instantiated!");
                continue;
            }
            this.addHit(classToInstantiate, String.valueOf(msgToInstantiate) + " '" + classToInstantiate.getFullName() + "' is not properly instantiated!");
        }
    }

    private boolean isContainerAllowed(RfNamedElement container) {
        if (this.pAllowInstantiationInBaseClassValue == null || this.pAllowInstantiationInBaseClassValue.isEmpty()) {
            return false;
        }
        if (this.pAllowInstantiationInBaseClassValue.contains(container.getFullName())) {
            return true;
        }
        RfClass parentClass = ((RfClass)container).getParent();
        while (parentClass != null) {
            if (this.pAllowInstantiationInBaseClassValue.contains(parentClass.getFullName())) {
                return true;
            }
            parentClass = parentClass.getParent();
        }
        return false;
    }

    private void searchForCreateCalls(RfClass classs, RfClass baseClass, String msgToInstantiate, ClassesHoldingInstances wrapper, Map<RfField, Map<RfClass, RfClass>> actualFieldTypes) {
        RfFunction buildPhase = classs.getFunctionWithPrefix(this.fOVMProject.getBuildPhaseMethodName(), 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
        PushMethodsVisitor pushMethodsVisitor = new PushMethodsVisitor(this.pushMethodsArguments, new HashSet<RfFunction>(), classs);
        if (buildPhase != null) {
            buildPhase.visitHidObject(null, pushMethodsVisitor);
        }
        IndirectFunctionVisitor visitor = null;
        if (this.pAllowIndirectCallInstantiationValue && buildPhase != null) {
            this.indirectVisitorActive = true;
            HashSet<RfFunction> visited = new HashSet<RfFunction>();
            visited.add(buildPhase);
            visitor = new IndirectFunctionVisitor(classs, visited, baseClass, msgToInstantiate, wrapper, false, new HashSet<RfHidAccessArgs>(), actualFieldTypes);
            buildPhase.visitHidObject(null, visitor);
            this.indirectVisitorActive = false;
        }
        HashSet<RfHidAccessArgs> visitedArgs = visitor != null ? visitor.getVisitedArgs() : new HashSet<RfHidAccessArgs>();
        classs.visitHidObject(null, new FunctionVisitor(baseClass, msgToInstantiate, wrapper, visitedArgs, actualFieldTypes));
    }

    public void checkCreateArgs(ParserPath parserPath, RfHidAccessArgs accessArgs, RfClass baseClass, String msgToInstantiate) {
        Hid parentHid = accessArgs.getParentHid();
        if (!(parentHid instanceof RfHid)) {
            return;
        }
        if (!parentHid.isMethodCall(false)) {
            return;
        }
        String methodName = parentHid.getName();
        if (!methodName.equals("create")) {
            return;
        }
        if (!((parentHid = parentHid.getParentHid()) instanceof RfHid)) {
            return;
        }
        String typeName = parentHid.getName();
        if (!typeName.equals("type_id")) {
            return;
        }
        if (!((parentHid = parentHid.getParentHid()) instanceof RfHid)) {
            return;
        }
        IRfNamedElement rightElement = parentHid.getElement();
        if (rightElement instanceof RfField) {
            rightElement = LintUtils.getFieldFinalClassTypeOrNull((RfField)rightElement);
        }
        if (!(rightElement instanceof RfClass)) {
            return;
        }
        if (!LintUtils.isSubClassOf((RfClass)rightElement, baseClass)) {
            return;
        }
        if (this.pushMethodsArguments.contains((Object)accessArgs)) {
            return;
        }
        this.addHit(parserPath, (RfHid)parentHid, String.valueOf(msgToInstantiate) + " '" + ((RfClass)rightElement).getFullName() + "' instance is not assigned to a class variable!");
        this.unproperlyInstantiatedClasses.add(((RfClass)rightElement).getFullName());
    }

    public void checkCreate(RfHidOperator hidOperator, ParserPath parserPath, IHidHolder holder, RfClass baseClass, String msgToInstantiate, ClassesHoldingInstances wrapper, boolean isInConditional, Set<RfHidAccessArgs> visitedArgs, Map<RfField, Map<RfClass, RfClass>> actualFieldTypes) {
        Map<RfClass, RfClass> fieldParamTypeMap;
        IRfNamedElement translatedType;
        ListContainer right = hidOperator.getRHValues();
        if (right == null || right.isEmpty()) {
            return;
        }
        IHidObject rightHid = (IHidObject)right.get(0);
        if (!(rightHid instanceof RfHidAccessArgs)) {
            return;
        }
        RfHidAccessArgs accessArgs = (RfHidAccessArgs)rightHid;
        if (visitedArgs != null && !visitedArgs.isEmpty() && visitedArgs.contains((Object)accessArgs)) {
            return;
        }
        Hid parentHid = accessArgs.getParentHid();
        if (!(parentHid instanceof RfHid)) {
            return;
        }
        String methodName = parentHid.getName();
        if (!methodName.equals("create")) {
            return;
        }
        if (!((parentHid = parentHid.getParentHid()) instanceof RfHid)) {
            return;
        }
        String typeName = parentHid.getName();
        if (!typeName.equals("type_id")) {
            return;
        }
        if (!((parentHid = parentHid.getParentHid()) instanceof RfHid)) {
            return;
        }
        IRfNamedElement rightElement = parentHid.getElement();
        RfClass rightType = null;
        HashSet<IRfNamedElement> potentialElements = new HashSet<IRfNamedElement>();
        if (rightElement instanceof RfTypeAlias && (translatedType = ((RfTypeAlias)rightElement).getTranslatedType()) instanceof RfNamedElement) {
            rightElement = translatedType;
        }
        if (rightElement instanceof RfClass) {
            rightType = (RfClass)rightElement;
        } else if (rightElement instanceof RfField && (rightType = LintUtils.getFieldFinalClassTypeOrNull((RfField)rightElement)) instanceof RfSpecializedClass) {
            rightType = ((RfSpecializedClass)rightType).getGenericClass();
        }
        if (rightType != null) {
            potentialElements.add(rightType);
        }
        if ((fieldParamTypeMap = actualFieldTypes.get(rightElement)) != null && !fieldParamTypeMap.isEmpty()) {
            for (Map.Entry entry : fieldParamTypeMap.entrySet()) {
                if (entry.getValue() == null) continue;
                potentialElements.add((IRfNamedElement)entry.getValue());
            }
        }
        for (IRfNamedElement iRfNamedElement : potentialElements) {
            if (!LintUtils.isSubClassOf((RfClass)iRfNamedElement, baseClass)) continue;
            this.properlyInstantiatedClasses.put(((RfClass)iRfNamedElement).getFullName(), (RfClass)iRfNamedElement);
            this.notifyCheckAlive();
            IHidObject left = hidOperator.getLHValue();
            if (!this.pushMethodsArguments.contains((Object)accessArgs) && !this.checkField(left, wrapper)) {
                this.addHit(parserPath, (RfHid)parentHid, String.valueOf(msgToInstantiate) + " '" + ((RfClass)iRfNamedElement).getFullName() + "' instance is not assigned to a class variable!");
                continue;
            }
            if (left instanceof RfHidAccess) {
                left = ((RfHidAccess)left).getParentHid();
            }
            RfHid leftHid = (RfHid)left;
            RfFunction enclosingMetod = (RfFunction)((RfHidHolder)holder).getScope().getEnclosingScope(RfFunction.class);
            if (enclosingMetod == null && !this.indirectVisitorActive) {
                this.addHit(parserPath, leftHid, String.valueOf(msgToInstantiate) + " '" + ((RfClass)iRfNamedElement).getFullName() + "' is instantiated outside a function!");
                this.unproperlyInstantiatedClasses.add(((RfClass)iRfNamedElement).getFullName());
                continue;
            }
            if (!(enclosingMetod != null && enclosingMetod.getName().equals(this.fOVMProject.getBuildPhaseMethodName()) || this.indirectVisitorActive)) {
                this.addHit(parserPath, leftHid, String.valueOf(msgToInstantiate) + " '" + ((RfClass)iRfNamedElement).getFullName() + "' is instantiated out of " + this.fOVMProject.getBuildPhaseMethodName() + "()!");
                this.unproperlyInstantiatedClasses.add(((RfClass)iRfNamedElement).getFullName());
                continue;
            }
            RfNamedElement container = ((RfNamedElement)((RfHidHolder)holder).getScope()).getClosestTypeContainer();
            boolean containerAllowed = this.isContainerAllowed(container);
            if (!containerAllowed && (wrapper.getClassHoldingInstances() == null || !wrapper.getClassHoldingInstances().containsKey(container.getFullName())) || !wrapper.fCheckActive || isInConditional) continue;
            if (this.pAllowInstantiationByActiveFieldChecking) {
                this.addHit(parserPath, leftHid, String.valueOf(msgToInstantiate) + " '" + ((RfClass)iRfNamedElement).getFullName() + "' creation is not guarded by \"is active\" condition or \"uvm_active_passive_enum\" field!");
            } else {
                this.addHit(parserPath, leftHid, String.valueOf(msgToInstantiate) + " '" + ((RfClass)iRfNamedElement).getFullName() + "' creation is not guarded by \"is active\" condition!");
            }
            this.unproperlyInstantiatedClasses.add(((RfClass)iRfNamedElement).getFullName());
        }
    }

    private boolean checkField(IHidObject left, ClassesHoldingInstances wrapper) {
        if (left instanceof RfHidAccess) {
            left = ((RfHidAccess)left).getParentHid();
        }
        if (!(left instanceof RfHid)) {
            return false;
        }
        RfHid leftHid = (RfHid)left;
        IRfNamedElement leftElement = leftHid.getElement();
        if (!(leftElement instanceof RfField)) {
            return false;
        }
        RfField field = (RfField)leftElement;
        RfNamedElement fieldScope = field.getEnclosingScope();
        if (!(fieldScope instanceof RfClass)) {
            return false;
        }
        return wrapper.fClassHoldingInstances.containsKey(fieldScope.getFullName());
    }

    /*
     * Unable to fully structure code
     */
    public boolean checkHolderIsActive(IHidHolder holder) {
        if (!(holder instanceof RfHidHolder)) {
            return false;
        }
        scope = ((RfHidHolder)holder).getScope();
        if (scope != null && scope instanceof RfNamedElement) ** GOTO lbl9
        return false;
lbl-1000:
        // 1 sources

        {
            if (((RfActionBlock)scope).isConditional() && XVMLintUtils.isActiveConditionalBlock(this.fOVMProject, block = (RfActionBlock)scope, this.pAllowInstantiationByActiveFieldChecking)) {
                return true;
            }
            scope = ((RfNamedElement)scope).getEnclosingScope();
lbl9:
            // 2 sources

            ** while (scope != null && scope instanceof RfActionBlock)
        }
lbl10:
        // 1 sources

        return false;
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.checkPreWaivers(fileDef.getParserPath());
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    public static class ClassesHoldingInstances {
        private Map<String, RfClass> fClassHoldingInstances;
        private String fMsgHoldingInstances;
        private boolean fCheckActive;

        public ClassesHoldingInstances(Map<String, RfClass> classHoldingInstances, String mesageHoldingInstances, boolean checkActive) {
            this.fClassHoldingInstances = classHoldingInstances;
            this.fMsgHoldingInstances = mesageHoldingInstances;
            this.fCheckActive = checkActive;
        }

        public Map<String, RfClass> getClassHoldingInstances() {
            return this.fClassHoldingInstances;
        }

        public void setClassHoldingInstances(Map<String, RfClass> classHoldingInstances) {
            this.fClassHoldingInstances = classHoldingInstances;
        }

        public String getMsgHoldingInstances() {
            return this.fMsgHoldingInstances;
        }

        public void setMsgHoldingInstances(String msgHoldingInstances) {
            this.fMsgHoldingInstances = msgHoldingInstances;
        }

        public boolean isCheckActive() {
            return this.fCheckActive;
        }

        public void setCheckActive(boolean checkActive) {
            this.fCheckActive = checkActive;
        }
    }

    private final class FunctionVisitor
    implements IHidVisitor<IHidObject> {
        private IHidHolder holder;
        private ParserPath parserPath;
        private RfClass baseClass;
        private String msgToInstantiate;
        private ClassesHoldingInstances wrapper;
        private Set<RfHidAccessArgs> visitedArgs;
        private Map<RfField, Map<RfClass, RfClass>> actualFieldTypes;

        public FunctionVisitor(RfClass baseClass, String msgToInstantiate, ClassesHoldingInstances wrapper, Set<RfHidAccessArgs> visitedArgs, Map<RfField, Map<RfClass, RfClass>> actualFieldTypes) {
            this.baseClass = baseClass;
            this.msgToInstantiate = msgToInstantiate;
            this.wrapper = wrapper;
            this.visitedArgs = visitedArgs;
            this.actualFieldTypes = actualFieldTypes;
        }

        public void setHolder(IHidHolder holder) {
            this.holder = holder;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public boolean visit(IHidObject hidObject) {
            if (AbstractProperlyInstantiationCheck.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            if (hidObject instanceof RfHidOperator) {
                RfHidOperator hidOperator = (RfHidOperator)hidObject;
                if (!hidOperator.isAssignment()) {
                    return true;
                }
                boolean tempIsInConditional = false;
                if (this.wrapper.fCheckActive && !tempIsInConditional) {
                    tempIsInConditional = AbstractProperlyInstantiationCheck.this.checkHolderIsActive(this.holder);
                }
                AbstractProperlyInstantiationCheck.this.checkCreate(hidOperator, this.parserPath, this.holder, this.baseClass, this.msgToInstantiate, this.wrapper, tempIsInConditional, this.visitedArgs, this.actualFieldTypes);
                ListContainer rhValues = hidOperator.getRHValues();
                if (rhValues != null && !rhValues.isEmpty() && rhValues.get(0) instanceof RfHidAccessArgs) {
                    this.visitedArgs.add((RfHidAccessArgs)((Object)rhValues.get(0)));
                }
            } else if (hidObject instanceof RfHidAccessArgs) {
                RfHidAccessArgs hidAccessArgs = (RfHidAccessArgs)hidObject;
                Hid parentHid = hidAccessArgs.getParentHid();
                if (parentHid == null) {
                    return true;
                }
                IRfNamedElement hidElement = parentHid.getElement();
                if (!(hidElement instanceof RfFunction)) {
                    return true;
                }
                RfFunction function = (RfFunction)hidElement;
                if (function.isPredefined() && (function.getName().equals("push_back") || function.getName().equals("push_front"))) {
                    HidUtils.flattenToObjects(hidObject2 -> {
                        if (hidObject2 instanceof RfHidOperator) {
                            RfHidOperator hidOperator = (RfHidOperator)hidObject2;
                            boolean tempIsInConditional = false;
                            if (this.wrapper.fCheckActive && !tempIsInConditional) {
                                tempIsInConditional = AbstractProperlyInstantiationCheck.this.checkHolderIsActive(this.holder);
                            }
                            AbstractProperlyInstantiationCheck.this.checkCreate(hidOperator, this.parserPath, this.holder, this.baseClass, this.msgToInstantiate, this.wrapper, tempIsInConditional, this.visitedArgs, this.actualFieldTypes);
                            ListContainer rhValues = hidOperator.getRHValues();
                            if (rhValues != null && !rhValues.isEmpty() && rhValues.get(0) instanceof RfHidAccessArgs) {
                                this.visitedArgs.add((RfHidAccessArgs)((Object)((Object)rhValues.get(0))));
                            }
                        }
                        return true;
                    }, (IHidObject)hidObject, (Set)HidFlatteningOption.IMPLICITS_EXCLUDED);
                } else {
                    if (this.visitedArgs.contains((Object)hidAccessArgs)) {
                        return true;
                    }
                    AbstractProperlyInstantiationCheck.this.checkCreateArgs(this.parserPath, hidAccessArgs, this.baseClass, this.msgToInstantiate);
                }
                return true;
            }
            return true;
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }
    }

    private final class IndirectFunctionVisitor
    implements IHidVisitor<IHidObject> {
        private RfClass classs;
        private Set<RfFunction> visited;
        private ParserPath parserPath;
        private IHidHolder holder;
        private RfClass baseClass;
        private String msgToInstantiate;
        private ClassesHoldingInstances wrapper;
        private boolean isInConditional;
        private Set<RfHidAccessArgs> visitedArgs;
        Map<RfField, Map<RfClass, RfClass>> actualFieldTypes;

        public IndirectFunctionVisitor(RfClass classs, Set<RfFunction> visited, RfClass baseClass, String msgToInstantiate, ClassesHoldingInstances wrapper, boolean isInConditional, Set<RfHidAccessArgs> visitedArgs, Map<RfField, Map<RfClass, RfClass>> actualFieldTypes) {
            this.classs = classs;
            this.visited = visited;
            this.baseClass = baseClass;
            this.msgToInstantiate = msgToInstantiate;
            this.wrapper = wrapper;
            this.isInConditional = isInConditional;
            this.visitedArgs = visitedArgs;
            this.actualFieldTypes = actualFieldTypes;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public void setHolder(IHidHolder holder) {
            this.holder = holder;
        }

        public boolean visit(IHidObject hidObject) {
            if (AbstractProperlyInstantiationCheck.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            if (hidObject instanceof RfHid) {
                RfFunction tempFunction;
                RfHid hid = (RfHid)hidObject;
                if (!hid.isMethodCall(false)) {
                    return true;
                }
                IRfNamedElement element = hid.getElement();
                if (!(element instanceof RfFunction)) {
                    return true;
                }
                RfFunction function = (RfFunction)element;
                if (function.isPredefined()) {
                    return true;
                }
                if (function.isVirtual() && (tempFunction = LintUtils.getValidVirtualFunction(function, hid, this.classs)) != null) {
                    function = tempFunction;
                }
                if (this.visited.contains(function)) {
                    return true;
                }
                this.visited.add(function);
                boolean tempIsInConditional = this.isInConditional;
                if (this.wrapper.fCheckActive && !tempIsInConditional) {
                    tempIsInConditional = AbstractProperlyInstantiationCheck.this.checkHolderIsActive(this.holder);
                }
                function.visitHidObject(null, new IndirectFunctionVisitor(this.classs, this.visited, this.baseClass, this.msgToInstantiate, this.wrapper, tempIsInConditional, this.getVisitedArgs(), this.actualFieldTypes));
            } else if (hidObject instanceof RfHidAccessArgs) {
                RfHidAccessArgs hidAccessArgs = (RfHidAccessArgs)hidObject;
                Hid parentHid = hidAccessArgs.getParentHid();
                if (parentHid == null) {
                    return true;
                }
                IRfNamedElement hidElement = parentHid.getElement();
                if (!(hidElement instanceof RfFunction)) {
                    return true;
                }
                RfFunction function = (RfFunction)hidElement;
                if (function.getName().equals("push_back") || function.getName().equals("push_front")) {
                    HidUtils.flattenToObjects(hidObject2 -> {
                        if (hidObject2 instanceof RfHidOperator) {
                            RfHidOperator hidOperator = (RfHidOperator)hidObject2;
                            boolean tempIsInConditional = false;
                            if (this.wrapper.fCheckActive && !tempIsInConditional) {
                                tempIsInConditional = AbstractProperlyInstantiationCheck.this.checkHolderIsActive(this.holder);
                            }
                            AbstractProperlyInstantiationCheck.this.checkCreate(hidOperator, this.parserPath, this.holder, this.baseClass, this.msgToInstantiate, this.wrapper, tempIsInConditional, this.visitedArgs, this.actualFieldTypes);
                            ListContainer rhValues = hidOperator.getRHValues();
                            if (rhValues != null && !rhValues.isEmpty() && rhValues.get(0) instanceof RfHidAccessArgs) {
                                this.visitedArgs.add((RfHidAccessArgs)((Object)((Object)rhValues.get(0))));
                            }
                        }
                        return true;
                    }, (IHidObject)hidObject, (Set)HidFlatteningOption.IMPLICITS_EXCLUDED);
                }
            } else if (hidObject instanceof RfHidOperator) {
                RfHidOperator hidOperator = (RfHidOperator)hidObject;
                if (!hidOperator.isAssignment()) {
                    return true;
                }
                boolean tempIsInConditional = this.isInConditional;
                if (this.wrapper.fCheckActive && !tempIsInConditional) {
                    tempIsInConditional = AbstractProperlyInstantiationCheck.this.checkHolderIsActive(this.holder);
                }
                AbstractProperlyInstantiationCheck.this.checkCreate(hidOperator, this.parserPath, this.holder, this.baseClass, this.msgToInstantiate, this.wrapper, tempIsInConditional, null, this.actualFieldTypes);
                ListContainer rhValues = hidOperator.getRHValues();
                if (rhValues != null && !rhValues.isEmpty() && rhValues.get(0) instanceof RfHidAccessArgs) {
                    this.visitedArgs.add((RfHidAccessArgs)((Object)rhValues.get(0)));
                }
            }
            return true;
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }

        public Set<RfHidAccessArgs> getVisitedArgs() {
            return this.visitedArgs;
        }
    }

    private final class OutsideScopeFunctionVisitor
    implements IHidVisitor<IHidObject> {
        private IHidHolder holder;
        private ParserPath parserPath;
        private Set<ClassesHoldingInstances> wrapperClassesHoldingInstances;
        private RfClass baseClass;
        private String msgToInstantiate;
        private Map<HidOccurrence, RfHidAccessArgs> assignedCreateArgs;

        public OutsideScopeFunctionVisitor(Set<ClassesHoldingInstances> wrapperClassesHoldingInstances, RfClass baseClass, String msgToInstantiate) {
            this.wrapperClassesHoldingInstances = wrapperClassesHoldingInstances;
            this.baseClass = baseClass;
            this.msgToInstantiate = msgToInstantiate;
            this.assignedCreateArgs = new HashMap<HidOccurrence, RfHidAccessArgs>();
        }

        public void setHolder(IHidHolder holder) {
            this.holder = holder;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public boolean visit(IHidObject hidObject) {
            if (AbstractProperlyInstantiationCheck.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            IRfNamedElement scope = ((RfHidHolder)this.holder).getScope();
            if (!(scope instanceof RfNamedElement)) {
                return true;
            }
            RfNamedElement typeContainer = ((RfNamedElement)scope).getClosestTypeContainer();
            for (ClassesHoldingInstances wrapper : this.wrapperClassesHoldingInstances) {
                if (!wrapper.getClassHoldingInstances().containsValue(typeContainer)) continue;
                return false;
            }
            if (hidObject instanceof RfHidOperator) {
                RfHidOperator hidOperator = (RfHidOperator)hidObject;
                if (!hidOperator.isAssignment()) {
                    return true;
                }
                ListContainer rightHidObj = hidOperator.getRHValues();
                if (rightHidObj == null || rightHidObj.isEmpty()) {
                    return true;
                }
                IHidObject rightHid = (IHidObject)rightHidObj.get(0);
                if (!(rightHid instanceof RfHidAccessArgs)) {
                    return true;
                }
                RfHidAccessArgs accessArgs = (RfHidAccessArgs)rightHid;
                IHidObject leftHidObj = hidOperator.getLHValue();
                if (leftHidObj instanceof RfHidAccess) {
                    leftHidObj = ((RfHidAccess)leftHidObj).getParentHid();
                }
                if (!(leftHidObj instanceof RfHid)) {
                    return true;
                }
                RfHid leftHid = (RfHid)leftHidObj;
                IRfNamedElement element = leftHid.getElement();
                if (!(element instanceof RfField)) {
                    return true;
                }
                if (!((RfField)element).isField()) {
                    return true;
                }
                this.assignedCreateArgs.put(accessArgs.getOccurrence(), accessArgs);
            } else if (hidObject instanceof RfHidAccessArgs) {
                IRfNamedElement translatedType;
                RfHidAccessArgs accessArgs = (RfHidAccessArgs)hidObject;
                Hid parentHid = accessArgs.getParentHid();
                if (!(parentHid instanceof RfHid)) {
                    return true;
                }
                String methodName = parentHid.getName();
                if (!methodName.equals("create")) {
                    return true;
                }
                if (!((parentHid = parentHid.getParentHid()) instanceof RfHid)) {
                    return true;
                }
                String typeName = parentHid.getName();
                if (!typeName.equals("type_id")) {
                    return true;
                }
                if (!((parentHid = parentHid.getParentHid()) instanceof RfHid)) {
                    return true;
                }
                RfHid parentRfHid = (RfHid)parentHid;
                IRfNamedElement rightElement = parentHid.getElement();
                if (rightElement instanceof RfTypeAlias && (translatedType = ((RfTypeAlias)rightElement).getTranslatedType()) instanceof RfNamedElement) {
                    rightElement = translatedType;
                }
                if (rightElement instanceof RfField && (rightElement = LintUtils.getFieldFinalClassTypeOrNull((RfField)rightElement)) instanceof RfSpecializedClass) {
                    rightElement = ((RfSpecializedClass)rightElement).getGenericClass();
                }
                if (!(rightElement instanceof RfClass)) {
                    return true;
                }
                RfClass classs = (RfClass)rightElement;
                if (!LintUtils.isSubClassOf((RfClass)rightElement, this.baseClass)) {
                    return true;
                }
                if (typeContainer instanceof RfClass && AbstractProperlyInstantiationCheck.this.isContainerAllowed(typeContainer)) {
                    RfFunction enclosingMetod = (RfFunction)((RfHidHolder)this.holder).getScope().getEnclosingScope(RfFunction.class);
                    if (enclosingMetod == null && !AbstractProperlyInstantiationCheck.this.indirectVisitorActive) {
                        AbstractProperlyInstantiationCheck.this.addHit(this.parserPath, parentRfHid, String.valueOf(this.msgToInstantiate) + " '" + classs.getFullName() + "' is instantiated outside a function!");
                        AbstractProperlyInstantiationCheck.this.unproperlyInstantiatedClasses.add(classs.getFullName());
                        return true;
                    }
                    if (!(enclosingMetod != null && enclosingMetod.getName().equals(AbstractProperlyInstantiationCheck.this.fOVMProject.getBuildPhaseMethodName()) || AbstractProperlyInstantiationCheck.this.indirectVisitorActive)) {
                        AbstractProperlyInstantiationCheck.this.addHit(this.parserPath, parentRfHid, String.valueOf(this.msgToInstantiate) + " '" + classs.getFullName() + "' is instantiated out of " + AbstractProperlyInstantiationCheck.this.fOVMProject.getBuildPhaseMethodName() + "()!");
                        AbstractProperlyInstantiationCheck.this.unproperlyInstantiatedClasses.add(classs.getFullName());
                        return true;
                    }
                    if (!this.assignedCreateArgs.containsKey(accessArgs.getOccurrence()) || !this.assignedCreateArgs.get(accessArgs.getOccurrence()).equals((Object)accessArgs)) {
                        AbstractProperlyInstantiationCheck.this.addHit(this.parserPath, (RfHid)parentHid, String.valueOf(this.msgToInstantiate) + " '" + ((RfClass)rightElement).getFullName() + "' instance is not assigned to a class variable!");
                        AbstractProperlyInstantiationCheck.this.unproperlyInstantiatedClasses.add(((RfClass)rightElement).getFullName());
                    }
                    AbstractProperlyInstantiationCheck.this.properlyInstantiatedClasses.put(classs.getFullName(), (RfClass)rightElement);
                    return true;
                }
                StringBuilder holdingInstancesSB = new StringBuilder();
                for (ClassesHoldingInstances wrapper : this.wrapperClassesHoldingInstances) {
                    holdingInstancesSB.append(wrapper.getMsgHoldingInstances()).append(", ");
                }
                String holdingInstances = holdingInstancesSB.toString();
                holdingInstances = holdingInstances.substring(0, holdingInstances.length() - 2);
                if (AbstractProperlyInstantiationCheck.this.pAllowInstantiationInBaseClassValue.isEmpty() && holdingInstances.contains(",")) {
                    holdingInstances = String.valueOf(holdingInstances.substring(0, holdingInstances.lastIndexOf(","))) + " or" + holdingInstances.substring(holdingInstances.lastIndexOf(",") + 1);
                }
                AbstractProperlyInstantiationCheck.this.addHit(this.parserPath, parentRfHid, String.valueOf(this.msgToInstantiate) + " '" + ((RfClass)rightElement).getFullName() + "' is instantiated out of " + holdingInstances + (AbstractProperlyInstantiationCheck.this.pAllowInstantiationInBaseClassValue.isEmpty() ? "!" : " or one of the specified base classes!"));
                AbstractProperlyInstantiationCheck.this.unproperlyInstantiatedClasses.add(((RfClass)rightElement).getFullName());
            }
            return true;
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }
    }

    private static final class PushMethodsVisitor
    extends RfHidVisitor {
        private Set<RfHidAccessArgs> pushMethodsArgs;
        private Set<RfFunction> visited;
        private RfClass classs;

        public PushMethodsVisitor(Set<RfHidAccessArgs> pushMethodsArgs, Set<RfFunction> visited, RfClass classs) {
            this.pushMethodsArgs = pushMethodsArgs;
            this.visited = visited;
            this.classs = classs;
        }

        public boolean visit(RfHid hidObject) {
            if (!hidObject.isMethodCall(false)) {
                return true;
            }
            if (!(hidObject.getElement() instanceof RfPredefinedFunction)) {
                RfFunction tempFunction;
                if (!(hidObject.getElement() instanceof RfFunction)) {
                    return true;
                }
                RfFunction calledFunction = (RfFunction)hidObject.getElement();
                if (calledFunction.isVirtual() && (tempFunction = LintUtils.getValidVirtualFunction(calledFunction, hidObject, this.classs)) != null) {
                    calledFunction = tempFunction;
                }
                if (this.visited.contains(calledFunction)) {
                    return true;
                }
                this.visited.add(calledFunction);
                PushMethodsVisitor pushMethodsVisitor = new PushMethodsVisitor(this.pushMethodsArgs, this.visited, this.classs);
                calledFunction.visitHidObject(null, pushMethodsVisitor);
                return true;
            }
            RfPredefinedFunction function = (RfPredefinedFunction)hidObject.getElement();
            if (!function.getName().equals("push_back") && !function.getName().equals("push_front")) {
                return true;
            }
            List methodCalls = MethodCallUtils.getMethodCalls((IHid)hidObject);
            for (MethodCall call : methodCalls) {
                String methodName;
                RfHidAccessArgs accessArgs;
                Hid parentHid;
                IHidObject argValue;
                Map.Entry argEntry;
                if (call.argumentValuesMapRaw == null || call.argumentValuesMap.entrySet().size() > 1 || (argEntry = call.argumentValuesMapRaw.entrySet().iterator().next()) == null || !((argValue = (IHidObject)argEntry.getValue()) instanceof RfHidAccessArgs) || !((parentHid = (accessArgs = (RfHidAccessArgs)argValue).getParentHid()) instanceof RfHid) || !parentHid.isMethodCall(false) || !(methodName = parentHid.getName()).equals("create")) continue;
                this.pushMethodsArgs.add(accessArgs);
            }
            return true;
        }
    }
}

