/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;

public abstract class AbstractTestDirectiveOrFunctionCall
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="When true the check will not fail if the directive or method call is missing but only when the method is called after start_of_simulation phase.", name="allowMissingDirectiveOrMethodCall", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowMissingDirectiveOrMethodCallValue;
    private Set<RfFunction> visitedFunctions;
    private Set<RfFunction> validFunctions;
    private static final Set<String> CHECKED_METHODS = new HashSet<String>(Arrays.asList("new", "build_phase", "connect_phase", "end_of_elaboration_phase", "start_of_simulation_phase"));

    protected AbstractTestDirectiveOrFunctionCall(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.checkDirective()) {
            return;
        }
        this.visitedFunctions = new HashSet<RfFunction>();
        this.validFunctions = new HashSet<RfFunction>();
        RfClass xvmTestClass = this.fOVMProject.fOvmTest;
        if (xvmTestClass == null) {
            return;
        }
        Set<RfClass> children = xvmTestClass.getChildren();
        if (children == null) {
            return;
        }
        HashSet<RfClass> visitedChildrenWithParentMethods = new HashSet<RfClass>();
        HashSet<RfClass> visitedChildrenWithChildMethods = new HashSet<RfClass>();
        visitedChildrenWithChildMethods.addAll(children);
        visitedChildrenWithParentMethods.addAll(children);
        for (RfClass child : children) {
            this.checkChild(child, new HashMap<String, RfFunction>(), visitedChildrenWithParentMethods, visitedChildrenWithChildMethods);
        }
    }

    private void checkChild(RfClass test, Map<String, RfFunction> parentMethods, Set<RfClass> visitedChildrenWithParentMethods, Set<RfClass> visitedChildrenWithChildMethods) {
        Set<RfClass> set;
        Set<RfClass> children2;
        if (test == null) {
            return;
        }
        RfFileDef file = test.getFile();
        if ((file == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(file.getParserPath(), this)) && (children2 = test.getChildren()) != null) {
            for (RfClass child : children2) {
                if (visitedChildrenWithParentMethods.contains(child)) continue;
                visitedChildrenWithParentMethods.add(child);
                this.checkChild(child, parentMethods, visitedChildrenWithParentMethods, visitedChildrenWithChildMethods);
            }
        }
        this.notifyCheckAlive();
        boolean directiveIsSet = false;
        HashMap<String, RfFunction> childMethods = new HashMap<String, RfFunction>();
        Collection<RfNamedElement> members = test.getMembers();
        if (members != null) {
            for (RfNamedElement rfNamedElement : members) {
                if (!(rfNamedElement instanceof RfFunction) || !CHECKED_METHODS.contains(rfNamedElement.getName())) continue;
                childMethods.put(rfNamedElement.getName(), (RfFunction)rfNamedElement);
            }
        }
        if (parentMethods != null) {
            for (Map.Entry entry : parentMethods.entrySet()) {
                childMethods.putIfAbsent((String)entry.getKey(), (RfFunction)entry.getValue());
            }
        }
        for (RfFunction rfFunction : childMethods.values()) {
            if (!this.checkFunction(rfFunction)) continue;
            directiveIsSet = true;
            break;
        }
        if (!directiveIsSet && !this.pAllowMissingDirectiveOrMethodCallValue) {
            this.addHit(test, this.getFailMessage(test));
        }
        if (!directiveIsSet && this.pAllowMissingDirectiveOrMethodCallValue) {
            List<RfFunction> list = test.getFunctionsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            list.addAll(test.getFunctionsWithPrefix("", 2, 2, IRfNamedElement.AccessModifier.SHOW_PROTECTED));
            list.addAll(test.getTasksWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE));
            list.addAll(test.getTasksWithPrefix("", 2, 2, IRfNamedElement.AccessModifier.SHOW_PROTECTED));
            for (RfFunction function : list) {
                if (!this.checkFunction(function)) continue;
                directiveIsSet = true;
                break;
            }
            if (directiveIsSet) {
                this.addHit(test, this.getFailMessage(test));
            }
        }
        if ((set = test.getChildren()) != null) {
            for (RfClass child : set) {
                if (visitedChildrenWithChildMethods.contains(child)) continue;
                visitedChildrenWithChildMethods.add(child);
                this.checkChild(child, childMethods, visitedChildrenWithParentMethods, visitedChildrenWithChildMethods);
            }
        }
    }

    private boolean checkFunction(RfFunction function) {
        if (this.validFunctions.contains(function)) {
            return true;
        }
        if (function == null || this.visitedFunctions.contains(function) || this.fOVMProject.isOVMElement(function)) {
            return false;
        }
        this.visitedFunctions.add(function);
        LocalHidVisitor visitor = new LocalHidVisitor();
        function.visitHidObject(this.fOVMProject.getRfProject(), visitor);
        if (visitor.isFoundCall()) {
            this.validFunctions.add(function);
            return true;
        }
        Set<RfFunction> functionsToBeChecked = visitor.getFunctionsToBeChecked();
        if (functionsToBeChecked != null) {
            for (RfFunction functionToBeChecked : functionsToBeChecked) {
                if (!this.checkFunction(functionToBeChecked)) continue;
                this.validFunctions.add(function);
                return true;
            }
        }
        return false;
    }

    private boolean checkDirective() {
        String directiveValue = this.getDirectiveValue();
        if (directiveValue == null || directiveValue.isEmpty()) {
            return false;
        }
        Long value = this.parseDirectiveValue(directiveValue);
        if (value == null) {
            return false;
        }
        if (value == 0L) {
            this.addHit(new ParserPath("none"), 0, this.getDirectiveValueFailMessage(), null);
        }
        return true;
    }

    protected Long parseDirectiveValue(String value) {
        String[] parts = value.split(",");
        if (parts.length < 1 || parts.length > 2) {
            return null;
        }
        if (!LintUtils.isIntegralNumber(parts[0])) {
            return null;
        }
        Number number = DVTStringUtil.parseNumberVLOG((String)parts[0], null, (boolean)false);
        if (number == null) {
            return null;
        }
        return number.longValue();
    }

    protected abstract boolean isValidFunction(RfFunction var1);

    protected abstract String getDirectiveValue();

    protected abstract String getFailMessage(RfClass var1);

    protected abstract String getDirectiveValueFailMessage();

    protected abstract String getArgumentValueFailMessage(String var1);

    private final class LocalHidVisitor
    implements IHidVisitor<RfHid> {
        private ParserPath parserPath;
        private boolean foundCall = false;
        private Set<RfFunction> functionsToBeChecked = new HashSet<RfFunction>();

        private LocalHidVisitor() {
        }

        public boolean isFoundCall() {
            return this.foundCall;
        }

        public Set<RfFunction> getFunctionsToBeChecked() {
            return this.functionsToBeChecked;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public boolean visit(RfHid hid) {
            if (!hid.isMethodCall(false)) {
                return true;
            }
            IRfNamedElement element = hid.getElement();
            if (!(element instanceof RfFunction) || element.isPredefined()) {
                return true;
            }
            RfFunction calledFunction = (RfFunction)element;
            if (AbstractTestDirectiveOrFunctionCall.this.isValidFunction(calledFunction)) {
                this.checkArgumentValue(hid, calledFunction);
                this.foundCall = true;
                return false;
            }
            if (!this.foundCall) {
                this.functionsToBeChecked.add(calledFunction);
            }
            return true;
        }

        private void checkArgumentValue(RfHid hid, RfFunction calledFunction) {
            List methodCalls = MethodCallUtils.getMethodCalls((IHid)hid);
            for (MethodCall methodCall : methodCalls) {
                Number number;
                String firstArgument;
                Map.Entry entry;
                IHidObject hidArgument;
                Iterator iterator = methodCall.argumentValuesMapRaw.entrySet().iterator();
                if (!iterator.hasNext() || !((hidArgument = (IHidObject)(entry = iterator.next()).getValue()) instanceof RfHidImplicit) || !LintUtils.isIntegralNumber(firstArgument = ((RfHidImplicit)hidArgument).getName()) || (number = DVTStringUtil.parseNumberVLOG((String)firstArgument, null, (boolean)false)) == null || number.longValue() != 0L) continue;
                AbstractTestDirectiveOrFunctionCall.this.addHit(this.parserPath, methodCall.occurrence, AbstractTestDirectiveOrFunctionCall.this.getArgumentValueFailMessage(calledFunction.getFullName()));
            }
        }

        public Class<RfHid> getType() {
            return RfHid.class;
        }
    }
}

