/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.util.HashSet;
import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;

@CheckVersion(value="3.1")
@CheckID(value="ARAA")
@CheckName(value="ARAD")
@CheckLabel(labels={RuleLabel.ARCHITECTURE, RuleLabel.AGENT, RuleLabel.FIELD, RuleLabel.VERIFICATION})
@CheckTitle(value="Agent Has Driver")
@CheckDescription(value="Verify that all agents have a driver field. A driver is a class that inherits from xvm_driver.\nException 1: Agents that contain other agents are not required to have a driver field.\nException 2: Virtual agents are skipped.\n\nRelated checks: ARAI, ARMI, ARDI, ARSI, ARAS, XVM28, XVM46, XVM49, XVM51, XVM52, XVM60.\n\nImplementation details:\nFor each agent (skips virtual agents):\n1) Checks that agent has at least a driver or agent field (including inheritance)\n\nCheck supports pre-waiving.")
public class CheckARAA
extends OVMComplianceCheck {
    public CheckARAA(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        HashSet<RfClass> agentInterfaces = new HashSet<RfClass>();
        HashSet<RfClass> nonAgentInterfaces = new HashSet<RfClass>();
        for (RfNamedElement element : this.fOVMProject.getAllNonXVMClasses()) {
            RfClass classElem;
            List<RfClass> parentInterfaces;
            if (!(element instanceof RfClass) || (parentInterfaces = (classElem = (RfClass)element).getParentInterfaces()) == null) continue;
            if (this.fOVMProject.isAgent(classElem)) {
                agentInterfaces.addAll(parentInterfaces);
                continue;
            }
            nonAgentInterfaces.addAll(parentInterfaces);
        }
        agentInterfaces.removeAll(nonAgentInterfaces);
        for (RfClass agent : this.fOVMProject.fAgents.values()) {
            if (agent.hasVirtualQualifier()) continue;
            this.notifyCheckAlive();
            if (this.checkPreWaivers(agent.getFile())) continue;
            List<RfField> fields = agent.getFieldsWithPrefix("", 2, 2, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            boolean ok = false;
            if (fields != null && !fields.isEmpty()) {
                for (RfField field : fields) {
                    RfClass fieldType = LintUtils.getFieldFinalClassTypeOrNull(field, RfTypesResolver.create((IRfScopeElement)agent, agent.getRfProject(), 6));
                    if (fieldType == null || !this.fOVMProject.isAgent(fieldType) && !this.fOVMProject.isDriver(fieldType) && !agentInterfaces.contains(fieldType)) continue;
                    ok = true;
                    break;
                }
            }
            if (ok) continue;
            this.addHit(agent, "'" + agent.getName() + "' doesn't contain other agents or drivers!");
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

