/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;

@CheckVersion(value="3.1")
@CheckID(value="ARAF")
@CheckName(value="ARAF")
@CheckLabel(labels={RuleLabel.ARCHITECTURE, RuleLabel.AGENT, RuleLabel.FIELD, RuleLabel.VERIFICATION})
@CheckTitle(value="Agent Has Active Field")
@CheckDescription(value="Verify that all agents have exactly one field of type xvm_active_passive_enum.\n\nCheck supports pre-waiving.")
public class CheckARAF
extends OVMComplianceCheck {
    public CheckARAF(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    public void performCheckImpl() {
        String libActivePassiveEnumName = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_active_passive_enum");
        for (RfClass agent : this.fOVMProject.fAgents.values()) {
            this.notifyCheckAlive();
            if (this.checkPreWaivers(agent.getFile())) continue;
            List<RfField> fields = agent.getFieldsWithPrefix("", 2, 2, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            if (fields == null || fields.isEmpty()) {
                this.addHit(agent, "'" + agent.getName() + "' does not contain an " + libActivePassiveEnumName + " field");
                continue;
            }
            RfField activeField = null;
            for (RfField field : fields) {
                if (field.getDataType() == null || !libActivePassiveEnumName.equals(field.getDataType().getType())) continue;
                if (activeField == null) {
                    activeField = field;
                    continue;
                }
                this.addHit(agent, "'" + agent.getName() + "' has duplicate " + libActivePassiveEnumName + " field");
            }
            if (activeField == null) {
                this.addHit(agent, "'" + agent.getName() + "' does not contain an " + libActivePassiveEnumName + " field");
                continue;
            }
            this.addPassedHit(agent, "'" + agent.getName() + "' contains one " + libActivePassiveEnumName + " field: '" + activeField.getFullName() + "'.");
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

