/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.util.LinkedHashSet;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckParametersOverrides;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.standard.checks.AbstractProperlyInstantiationCheck;

@CheckVersion(value="3.1")
@CheckID(value="ARBF")
@CheckLabel(labels={RuleLabel.ARCHITECTURE, RuleLabel.AGENT, RuleLabel.DRIVER, RuleLabel.FACTORY_CREATE, RuleLabel.VERIFICATION, RuleLabel.ENVIRONMENT, RuleLabel.BUILD_PHASE})
@CheckName(value="ARDI")
@CheckTitle(value="Driver Instantiation")
@CheckDescription(value="Verify that all drivers are properly instantiated in agents (or envs iff allowInstantiationInEnv is set).\nProperly instantiated means that they should be created using class_name::type_id::create() method inside the build phase. See the example in rule XVM51.\n\nRelated checks: ARAD, ARAI, ARDI, ARSI, ARAS, XVM28, XVM46, XVM49, XVM51, XVM52, XVM60.\n\nImplementation details:\nFor each driver (skips virtual drivers):\n1) Checks that there is at least one create() call for the driver. The create() call is \"driver type\"::type_id::create().\n2) Checks that the create() call:\n - is inside an env or agent\n - is inside build phase\n - is assigned to a field\n - is guarded by an \"if(get_is_active())\" or \"if(get_is_active() == XVM_ACTIVE)\" or \"if(XVM_ACTIVE == get_is_active())\" or \"if(<expr of active_passive_enum type>)\n\nUnlike XVM28, this rule checks that each driver is properly instantiated. You should use both of them to be on the safe side, even if there is some redundancy.\n\nCheck supports pre-waiving.")
@CheckParametersOverrides(value={@CheckParameterOverride(name="allowBaseClassInstantiation", description="When true, it passes if a parent driver is properly instantiated."), @CheckParameterOverride(name="allowInstantiationByActiveFieldChecking", description="When true, a driver can be instantiated if it is guarded by conditional code that checks if a field is of type xvm_active_passive_enum", isVisible=true)})
@CheckReapplyDisable
public class CheckARBF
extends AbstractProperlyInstantiationCheck {
    @CheckParameter(defaultValue="false", description="When true, a driver can be instantiated in an env. Is active is not checked.", name="allowInstantiationInEnv", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowInstantiationInEnvValue;

    public CheckARBF(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.fDrivers.isEmpty()) {
            return;
        }
        LinkedHashSet<AbstractProperlyInstantiationCheck.ClassesHoldingInstances> wrappers = new LinkedHashSet<AbstractProperlyInstantiationCheck.ClassesHoldingInstances>();
        wrappers.add(new AbstractProperlyInstantiationCheck.ClassesHoldingInstances(this.fOVMProject.fAgents, "an agent", true));
        if (this.pAllowInstantiationInEnvValue) {
            wrappers.add(new AbstractProperlyInstantiationCheck.ClassesHoldingInstances(this.fOVMProject.fEnvs, "an env", false));
        }
        this.checkProperlyInstantiation(this.fOVMProject.fDrivers.values(), "Driver", wrappers, this.fOVMProject.fOvmDriver);
    }
}

