/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.util.LinkedHashSet;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.standard.checks.AbstractProperlyInstantiationCheck;

@CheckVersion(value="3.1")
@CheckID(value="ARIN")
@CheckLabel(labels={RuleLabel.ARCHITECTURE, RuleLabel.AGENT, RuleLabel.ENVIRONMENT, RuleLabel.FACTORY_CREATE, RuleLabel.TEST, RuleLabel.BUILD_PHASE, RuleLabel.VERIFICATION})
@CheckName(value="ARAI")
@CheckTitle(value="Agent Instantiation")
@CheckDescription(value="Verify that all agents are properly instantiated in envs or agents (or tests iff allowInstantiationInTest is set).\nProperly instantiated means that they should be created using class_name::type_id::create() method inside the build phase. See the example in rule XVM51.\n\nRelated checks: ARAD, ARMI, ARDI, ARSI, ARAS, XVM28, XVM46, XVM49, XVM51, XVM52, XVM60.\n\nImplementation details:\nFor each agent (skips virtual agents):\n1) Checks that there is at least one create() call for the agent. The create() call is \"agent type\"::type_id::create().\n2) Checks that the create() call:\n - is inside an env or agent\n - is inside build phase\n - is assigned to a field\n\nCheck supports pre-waiving.")
@CheckParameterOverride(name="allowBaseClassInstantiation", description="When true, it passes if a parent agent is properly instantiated.")
@CheckReapplyDisable
public class CheckARIN
extends AbstractProperlyInstantiationCheck {
    @CheckParameter(defaultValue="false", description="When true, an agent can be instantiated in a test.", name="allowInstantiationInTest", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowInstantiationInTestValue;

    public CheckARIN(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.fAgents.isEmpty()) {
            return;
        }
        LinkedHashSet<AbstractProperlyInstantiationCheck.ClassesHoldingInstances> wrappers = new LinkedHashSet<AbstractProperlyInstantiationCheck.ClassesHoldingInstances>();
        wrappers.add(new AbstractProperlyInstantiationCheck.ClassesHoldingInstances(this.fOVMProject.fEnvs, "an env", false));
        wrappers.add(new AbstractProperlyInstantiationCheck.ClassesHoldingInstances(this.fOVMProject.fAgents, "another agent", false));
        if (this.pAllowInstantiationInTestValue) {
            wrappers.add(new AbstractProperlyInstantiationCheck.ClassesHoldingInstances(this.fOVMProject.fTests, "a test", false));
        }
        this.checkProperlyInstantiation(this.fOVMProject.fAgents.values(), "Agent", wrappers, this.fOVMProject.fOvmAgent);
    }
}

