/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.util.Map;
import java.util.regex.Pattern;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParametersOverrides;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractNamePatternParametersCheck;
import ro.amiq.vlogdt.model.reflection.RfClass;

@CheckVersion(value="3.1")
@CheckID(value="ARIO")
@CheckName(value="ARIO")
@CheckLabel(labels={RuleLabel.ARCHITECTURE, RuleLabel.COMPONENT, RuleLabel.VERIFICATION})
@CheckTitle(value="Active and Reactive Components")
@CheckDescription(value="Interface OVC should be complete and include both the \"active\" and \"reactive\" components.For example the same UVC should be able to emulate both master and slave.\nIf due to time pressure some logic is not implemented, it is encouraged to create empty sub-components for the missing logic and document it.\nWe identify \"active\" (e.g. master) and \"reactive\" (e.g. slave) agents based on some patterns in their names.\n\nImplementation details:\nYou can tune the patterns, for example to include tx for \"active\" and rx for \"reactive\" agents.\nYou need to have in your package at least one from each active/reactive x agent/driver/sequencer/monitor.")
@CheckReapplyDisable
@CheckParametersOverrides(value={@CheckParameterOverride(name="activeComponentClassNamePattern", isVisible=true), @CheckParameterOverride(name="reactiveComponentNamePattern", isVisible=true)})
public class CheckARIO
extends AbstractNamePatternParametersCheck {
    public CheckARIO(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    public void performCheckImpl() {
        Pattern activeNamePattern = this.pActiveComponentNamePattern;
        Pattern reactiveNamePattern = this.pReactiveComponentNamePattern;
        if (activeNamePattern == null || activeNamePattern.toString().equals("")) {
            this.addHit(null, "Active components names are empty");
        }
        if (reactiveNamePattern == null || reactiveNamePattern.toString().equals("")) {
            this.addHit(null, "Reactive components names are empty");
        }
        this.checkActiveReactiveComponent(this.fOVMProject.fAgents, "agent", activeNamePattern, reactiveNamePattern);
        this.checkActiveReactiveComponent(this.fOVMProject.fDrivers, "driver", activeNamePattern, reactiveNamePattern);
        this.checkActiveReactiveComponent(this.fOVMProject.fSequencers, "sequencer", activeNamePattern, reactiveNamePattern);
        this.checkActiveReactiveComponent(this.fOVMProject.fMonitors, "monitor", activeNamePattern, reactiveNamePattern);
    }

    private void checkActiveReactiveComponent(Map<String, RfClass> components, String componentName, Pattern activeNamePattern, Pattern reactiveNamePattern) {
        boolean activeFound = false;
        boolean reactiveFound = false;
        if (components != null) {
            for (RfClass elm : components.values()) {
                this.notifyCheckAlive();
                if (activeNamePattern.matcher(elm.getName()).matches()) {
                    this.addPassedHit(elm, "Active " + componentName);
                    activeFound = true;
                }
                if (!reactiveNamePattern.matcher(elm.getName()).matches()) continue;
                this.addPassedHit(elm, "Reactive " + componentName);
                reactiveFound = true;
            }
            if (!activeFound) {
                this.addHit(null, "No active " + componentName + " was found");
            }
            if (!reactiveFound) {
                this.addHit(null, "No reactive " + componentName + " was found");
            }
        }
    }
}

