/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.util.LinkedHashSet;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.standard.checks.AbstractProperlyInstantiationCheck;

@CheckVersion(value="3.1")
@CheckID(value="ARMN")
@CheckName(value="ARMI")
@CheckLabel(labels={RuleLabel.ARCHITECTURE, RuleLabel.MONITOR, RuleLabel.ENVIRONMENT, RuleLabel.AGENT, RuleLabel.FACTORY_CREATE, RuleLabel.BUILD_PHASE, RuleLabel.VERIFICATION})
@CheckTitle(value="Monitor Instantiation")
@CheckDescription(value="Verify that all monitors are properly instantiated in envs or agents.\nProperly instantiated means that they should be created using class_name::type_id::create() method inside the build phase. See the example in rule XVM51.\n\nRelated checks: ARAD, ARAI, ARDI, ARSI, ARAS, XVM28, XVM46, XVM49, XVM51, XVM52, XVM60.\n\nImplementation details:\nFor each monitor (skips virtual monitors):\n1) Checks that there is at least one create() call for the monitor. The create() call is \"monitor type\"::type_id::create().\n2) Checks that the create() call:\n - is inside an env or agent\n - is inside build phase\n - is assigned to a field\n\nCheck supports pre-waiving.")
@CheckParameterOverride(name="allowBaseClassInstantiation", description="When true, it passes if a parent monitor is properly instantiated.")
@CheckReapplyDisable
public class CheckARMN
extends AbstractProperlyInstantiationCheck {
    public CheckARMN(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.fMonitors.isEmpty()) {
            return;
        }
        LinkedHashSet<AbstractProperlyInstantiationCheck.ClassesHoldingInstances> wrappers = new LinkedHashSet<AbstractProperlyInstantiationCheck.ClassesHoldingInstances>();
        wrappers.add(new AbstractProperlyInstantiationCheck.ClassesHoldingInstances(this.fOVMProject.fEnvs, "an env", false));
        wrappers.add(new AbstractProperlyInstantiationCheck.ClassesHoldingInstances(this.fOVMProject.fAgents, "an agent", false));
        this.checkProperlyInstantiation(this.fOVMProject.fMonitors.values(), "Monitor", wrappers, this.fOVMProject.fOvmMonitor);
    }
}

