/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="3.1")
@CheckID(value="CHCAa")
@CheckName(value="CHCAa")
@CheckLabel(labels={RuleLabel.CHECKING, RuleLabel.INTERFACE, RuleLabel.ASSERTION, RuleLabel.VERIFICATION})
@CheckTitle(value="Declarative Protocol Assertions in Interfaces")
@CheckDescription(value="Declarative protocol assertions should be placed within the SystemVerilog interfaces.\n\nCheck supports pre-waiving.")
public class CheckCHCAa
extends OVMComplianceCheck {
    public CheckCHCAa(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement elm : this.fOVMProject.getAllAssertsExpects()) {
            RfAssertExpect assertExpect;
            if (this.checkPreWaivers(elm.getFile()) || !(assertExpect = (RfAssertExpect)elm).isConcurrentAssert()) continue;
            this.notifyCheckAlive();
            RfNamedElement container = assertExpect.getClosestTypeContainer();
            String name = null;
            name = assertExpect.getName().length() > 0 ? "'" + assertExpect.getName() + "' - " : "";
            if (container instanceof RfInterface) {
                this.addPassedHit(assertExpect, String.valueOf(name) + "assertion found in interface '" + container.getName() + "'");
                continue;
            }
            this.addHit(assertExpect, String.valueOf(name) + "assertion found outside of an interface '" + container.getName() + "'");
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

