/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPropertySequence;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="3.1")
@CheckID(value="CHCAb")
@CheckName(value="CHCAb")
@CheckLabel(labels={RuleLabel.CHECKING, RuleLabel.ASSERTION, RuleLabel.VERIFICATION})
@CheckTitle(value="Declarative Protocol Assertions Enabling")
@CheckDescription(value="Should be able to control the enabling/disabling for declarative protocol assertions using the standard checking configuration attributes.\n\nImplementation Notes:\nThis rule verifies the existence of a 'disable iff' construct.\n\nCheck supports pre-waiving.")
public class CheckCHCAb
extends OVMComplianceCheck {
    public CheckCHCAb(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement elm : this.fOVMProject.getAllAssertsExpects()) {
            RfAssertExpect assertExpect;
            if (this.checkPreWaivers(elm.getFile()) || !(assertExpect = (RfAssertExpect)elm).isConcurrentAssert()) continue;
            this.notifyCheckAlive();
            String name = assertExpect.getName().length() > 0 ? "'" + assertExpect.getName() + "' " : "";
            if (assertExpect.hasDisabledIff() || this.validExpression(assertExpect.getExpression())) continue;
            this.addHit(assertExpect, String.valueOf(name) + "assertion cannot be enabled/disabled!");
        }
    }

    private boolean validExpression(IHidObject expression) {
        if (expression instanceof RfHidAccessArgs) {
            expression = ((RfHidAccessArgs)expression).getParentHid();
        }
        if (expression instanceof RfHid) {
            final boolean[] hasDisabledIff = new boolean[1];
            IRfNamedElement element = ((RfHid)expression).getElement();
            if (element instanceof RfPropertySequence) {
                IHidHolder hidHolder = element.getHidHolder();
                if (hidHolder == null) {
                    return false;
                }
                hidHolder.visitHidObject(null, (IHidVisitor)new IHidVisitor<RfHidOperator>(){

                    public boolean visit(RfHidOperator hidOperator) {
                        if (!hidOperator.isDisableIffExpr()) {
                            return true;
                        }
                        IHidObject lhValue = hidOperator.getLHValue();
                        if (!(lhValue instanceof RfHidOperator)) {
                            return true;
                        }
                        if (!((RfHidOperator)lhValue).isIffExpression()) {
                            return true;
                        }
                        hasDisabledIff[0] = true;
                        return false;
                    }

                    public Class<RfHidOperator> getType() {
                        return RfHidOperator.class;
                    }
                });
            }
            return hasDisabledIff[0];
        }
        if (expression instanceof RfHidOperator) {
            if (!this.validExpression(((RfHidOperator)expression).getLHValue())) {
                return false;
            }
            ListContainer rhValues = ((RfHidOperator)expression).getRHValues();
            if (rhValues == null || rhValues.isEmpty()) {
                return true;
            }
            for (IHidObject rhValue : rhValues) {
                if (this.validExpression(rhValue)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

