/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="3.1")
@CheckID(value="CHEX")
@CheckName(value="CHEX")
@CheckLabel(labels={RuleLabel.CHECKING, RuleLabel.NAME, RuleLabel.STYLING, RuleLabel.ASSERTION, RuleLabel.VERIFICATION})
@CheckTitle(value="All checks should be named")
@CheckDescription(value="Verify that all checks are named.\n\nImplementation Notes:\nOnly concurrent asserts (assert property) and expects are checked to be named.\n\nCheck supports pre-waiving.")
public class CheckCHEX
extends OVMComplianceCheck {
    public CheckCHEX(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement elm : this.fOVMProject.getAllAssertsExpects()) {
            RfAssertExpect assertExpect;
            this.notifyCheckAlive();
            if (this.checkPreWaivers(elm.getFile()) || !(assertExpect = (RfAssertExpect)elm).isConcurrentAssert() && !assertExpect.isExpect() || !assertExpect.isAnonymous()) continue;
            this.addHit(elm, "Anonymous concurrent assert");
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

