/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfClass;

@CheckVersion(value="3.1")
@CheckID(value="CHSC")
@CheckName(value="CHSC")
@CheckLabel(labels={RuleLabel.CHECKING, RuleLabel.SCOREBOARD, RuleLabel.PACKAGE, RuleLabel.VERIFICATION})
@CheckTitle(value="Scoreboard Support")
@CheckDescription(value="Verify that the package contains a class that inherits from xvm_scoreboard.")
public class CheckCHSC
extends OVMComplianceCheck {
    public CheckCHSC(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        boolean found = false;
        if (this.fOVMProject.fScoreboards != null) {
            for (RfClass elm : this.fOVMProject.fScoreboards.values()) {
                this.addPassedHit(elm, "Scoreboard present");
                found = true;
            }
        }
        if (!found) {
            this.addHit(null, "Scoreboard is missing");
        }
    }
}

