/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfEventTrigger;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionCall;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;

@CheckVersion(value="3.1")
@CheckID(value="CVED")
@CheckName(value="CVED")
@CheckLabel(labels={RuleLabel.COVERAGE, RuleLabel.COVERGROUP, RuleLabel.CONDITIONAL, RuleLabel.VERIFICATION})
@CheckTitle(value="Disabling Coverage")
@CheckDescription(value="This check verifies that coverage collection by calling the sample method of the covergroup or by trigerring the covergroup event is done in a conditional block.\n\nCheck supports pre-waiving.")
public class CheckCVED
extends OVMComplianceCheck {
    public CheckCVED(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement elem : this.fOVMProject.getAllCovergroups()) {
            ParserPath elemParserPath;
            RfFileDef elemFile = elem.getFile();
            if (elemFile == null || (elemParserPath = elemFile.getParserPath()) == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(elemParserPath, this)) continue;
            this.notifyCheckAlive();
            RfNamedElement cvgScope = elem.getEnclosingScope();
            NullProtectedList<RfFunction> allScopeFctTsk = new NullProtectedList<RfFunction>();
            allScopeFctTsk.addAll(cvgScope.getFunctionsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE));
            allScopeFctTsk.addAll(cvgScope.getTasksWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE));
            RfCovergroup covergroup = (RfCovergroup)elem;
            String covergroupEvent = covergroup.getEventName();
            NullProtectedList<RfEventTrigger> eventTriggers = new NullProtectedList<RfEventTrigger>();
            NullProtectedList<RfFunctionCall> sampleCalls = new NullProtectedList<RfFunctionCall>();
            for (RfFunction function : allScopeFctTsk) {
                String covergroupName = covergroup.getName();
                sampleCalls.addAll(function.getFunctionCallsWithPrefix(String.valueOf(covergroupName) + "." + "sample", 1));
                if (covergroupEvent == null) continue;
                eventTriggers.addAll(function.getEventTriggersWithPrefix(covergroupEvent, 1));
            }
            for (RfFunctionCall sampleCall : sampleCalls) {
                if (LintUtils.isConditionalCode(sampleCall, allScopeFctTsk)) continue;
                this.addHit(sampleCall, "sample() call cannot be disabled as not being in a conditional code");
            }
            for (RfEventTrigger eventTrigger : eventTriggers) {
                if (LintUtils.isConditionalCode(eventTrigger, allScopeFctTsk)) continue;
                this.addHit(eventTrigger, "covergroup's event trigger cannot be disabled as not being in a conditional code");
            }
        }
    }
}

