/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.util.List;
import java.util.Set;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionCall;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="3.1")
@CheckID(value="CVVN")
@CheckName(value="CVVN")
@CheckLabel(labels={RuleLabel.MESSAGING, RuleLabel.REPORTING_MACRO, RuleLabel.VERIFICATION})
@CheckTitle(value="Always use XVM_NONE verbosity for xvm_report_fatal(), xvm_report_error() and xvm_report_warning()")
@CheckDescription(value="Always use verbosity XVM_NONE for xvm_report_fatal(), xvm_report_error() and xvm_report_warning(). This ensures that bugs are not being overlooked due to command-line verbosity changes.\n\nCheck supports pre-waiving.")
public class CheckCVVN
extends OVMComplianceCheck {
    public CheckCVVN(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    public void performCheckImpl() {
        String libOvmNoneName = String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "").toUpperCase()) + "_NONE";
        Set<RfNamedElement> containers = this.fOVMProject.getAllNonXVMFunctionCallContainers();
        if (containers == null || containers.isEmpty()) {
            return;
        }
        this.checkCalls(containers, OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_report_warning"), libOvmNoneName);
        this.checkCalls(containers, OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_report_error"), libOvmNoneName);
        this.checkCalls(containers, OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_report_fatal"), libOvmNoneName);
    }

    private void checkCalls(Set<RfNamedElement> containers, String functionName, String libOvmNoneName) {
        for (RfNamedElement container : containers) {
            List<RfFunctionCall> functionCalls;
            if (this.checkPreWaivers(container.getFile()) || (functionCalls = container.getFunctionCallsWithPrefix(functionName, 1)) == null || functionCalls.isEmpty()) continue;
            this.notifyCheckAlive();
            for (RfFunctionCall call : functionCalls) {
                String verbosityArg = call.getArgumentValue(2);
                if (verbosityArg != null) {
                    if (verbosityArg.equals(libOvmNoneName)) {
                        this.addPassedHit(call, "'" + call.getFunctionName() + "()' call uses " + libOvmNoneName + " verbosity");
                        continue;
                    }
                    this.addHit(call, "'" + call.getFunctionName() + "()' call doesn't use " + libOvmNoneName + " verbosity");
                    continue;
                }
                RfFunction function = call.getFunction();
                if (function == null) {
                    this.addHit(call, "'" + call.getFunctionName() + "()' - function not visible from the call scope");
                    continue;
                }
                List<RfField> args = function.getArgumentsWithPrefix("verbosity", 1);
                if (args == null || args.isEmpty()) continue;
                if (libOvmNoneName.equals(args.get(0).getInitialValue(false))) {
                    this.addPassedHit(call, "'" + call.getFunctionName() + "()' call uses " + libOvmNoneName + " verbosity");
                    continue;
                }
                this.addHit(call, "'" + call.getFunctionName() + "()' call doesn't use " + libOvmNoneName + " verbosity");
            }
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

