/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.io.File;
import java.util.HashSet;
import java.util.Optional;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.OVMUtils;

@CheckVersion(value="3.1")
@CheckID(value="DCDC")
@CheckName(value="DCDC")
@CheckLabel(labels={RuleLabel.DOCUMENTATION, RuleLabel.FILE})
@CheckTitle(value="Docs Directory Contents")
@CheckDescription(value="Verify that documentation files exist in the \"docs\" directory. Check the docs directory for .txt, .doc, .pdf, .fm, .html, .htm.")
public class CheckDCDC
extends OVMComplianceCheck {
    @CheckParameter(defaultValue=".txt, .doc, .pdf, .fm, .html, .htm, .TXT, .DOC, .PDF, .FM, .HTML, .HTM", description="Comma separated list of valid file extensions.", name="fileExtensions", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    HashSet<String> pFileExtensions;
    @CheckParameter(defaultValue="docs", description="Specify the directory path, relative to the current project, for the location of the documentation files.", name="documentationDirectory", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.STRING)
    String pDocumentationDirectory;

    public CheckDCDC(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        File projectDirectory = OVMUtils.getProjectPath(this.fOVMProject.getProject());
        if (projectDirectory == null || !projectDirectory.exists() || !projectDirectory.isDirectory()) {
            return;
        }
        File docs = new File(projectDirectory, this.pDocumentationDirectory);
        if (!docs.isDirectory()) {
            this.addHit(null, "'" + this.pDocumentationDirectory + "' directory doesn't exist!");
            return;
        }
        this.notifyCheckAlive();
        File[] fileList = docs.listFiles();
        boolean anyDocFile = false;
        if (fileList != null && fileList.length != 0) {
            int i = 0;
            while (i < fileList.length) {
                File file = fileList[i];
                Optional<String> findFirst = this.pFileExtensions.stream().filter(ext -> file.getName().endsWith((String)ext)).findFirst();
                if (findFirst.isPresent()) {
                    anyDocFile = true;
                }
                ++i;
            }
        }
        if (!anyDocFile) {
            this.addHit(new ParserPath(docs.getAbsolutePath()), 0, "'" + this.pDocumentationDirectory + "' directory doesn't contain any documentation files", null);
        }
    }
}

