/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.io.File;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.OVMUtils;

@CheckVersion(value="3.1")
@CheckID(value="DCRN")
@CheckName(value="DCRN")
@CheckLabel(labels={RuleLabel.DOCUMENTATION, RuleLabel.FILE})
@CheckTitle(value="Release Notes")
@CheckDescription(value="Verify that release notes are provided in the \"docs\" directory. Check the existence of RELEASE_NOTES.TXT, release_notes.txt or release-notes.txt.")
public class CheckDCRN
extends OVMComplianceCheck {
    String[] releaseNotesFiles = new String[]{"RELEASE_NOTES.TXT", "release_notes.txt", "release-notes.txt"};

    public CheckDCRN(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        File projectDirectory = OVMUtils.getProjectPath(this.fOVMProject.getProject());
        if (projectDirectory == null || !projectDirectory.exists() || !projectDirectory.isDirectory()) {
            return;
        }
        File docs = new File(projectDirectory, "docs");
        if (!docs.isDirectory()) {
            this.addHit(null, "'docs' directory doesn't exist!");
            return;
        }
        this.notifyCheckAlive();
        File[] fileList = docs.listFiles();
        boolean anyDocFile = false;
        if (fileList != null && fileList.length != 0) {
            int i = 0;
            while (i < fileList.length) {
                int j = 0;
                while (j < this.releaseNotesFiles.length) {
                    if (fileList[i].getName().equals(this.releaseNotesFiles[j])) {
                        this.addPassedHit(new ParserPath(fileList[i].getAbsolutePath()), 0, "docs directory contains release notes file: " + fileList[i].getName(), null);
                        anyDocFile = true;
                        return;
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (!anyDocFile) {
            this.addHit(new ParserPath(docs.getAbsolutePath()), 0, "docs directory doesn't contain release notes file", null);
        }
    }
}

