/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.util.List;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionCall;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="3.1")
@CheckID(value="MSUA")
@CheckName(value="MSUA")
@CheckLabel(labels={RuleLabel.MESSAGING, RuleLabel.VERIFICATION})
@CheckTitle(value="Use Print() for Printing")
@CheckDescription(value="It is recommended to use the field macro automation for class printing (print() and sprint()). This allows environment integrators to quickly read and understand log files of OVCs coming from different resources.If a user decides to manually implement the print() and sprint(). it is recommended to produce a similar output to what the automated print method introduce.\n\nCheck supports pre-waiving.")
public class CheckMSUA
extends OVMComplianceCheck {
    public CheckMSUA(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    public void performCheckImpl() {
        String libObjectName = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_object");
        String libFactoryName = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_factory");
        String libReportMessageName = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_report_message_element_base");
        for (RfNamedElement container : this.fOVMProject.getAllNonXVMFunctionCallContainers()) {
            List<RfFunctionCall> calls;
            if (this.checkPreWaivers(container.getFile()) || (calls = container.getFunctionCallsWithPrefix("", 2)) == null || calls.isEmpty()) continue;
            this.notifyCheckAlive();
            for (RfFunctionCall call : calls) {
                RfFunction fun;
                if (!call.getName().equals("print") && !call.getName().equals("sprint") && !call.getName().endsWith(".print") && !call.getName().endsWith(".sprint") && !call.getName().endsWith("::print") && !call.getName().endsWith("::sprint") || (fun = call.getFunction()) == null) continue;
                RfNamedElement functionScope = fun.getEnclosingScope();
                if (!(functionScope instanceof RfClass)) {
                    this.addHit(call, "Use of some other print/sprint function");
                    continue;
                }
                if (functionScope.getName().equals(libObjectName) || functionScope.getName().equals(libFactoryName) || functionScope.getName().equals(libReportMessageName)) {
                    this.addPassedHit(call, "Required print/sprint function call found");
                    continue;
                }
                if (((RfClass)functionScope).isSubClass(libObjectName, true) || ((RfClass)functionScope).isSubClass(libFactoryName, true) || ((RfClass)functionScope).isSubClass(libReportMessageName, true)) {
                    this.addPassedHit(call, "Overridden print/sprint function call found");
                    continue;
                }
                this.addHit(call, "Use of some other print/sprint function");
            }
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

