/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionCall;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="3.1")
@CheckID(value="MSUM")
@CheckName(value="MSUM")
@CheckLabel(labels={RuleLabel.MESSAGING, RuleLabel.CONDITIONAL, RuleLabel.PERFORMANCE, RuleLabel.VERIFICATION})
@CheckTitle(value="Conditional Printing")
@CheckDescription(value="For performance reasons, it is recommended to conditionally execute printing informational messages when data items are being printed.\n\nExample\nfunction func();\n  item.print();      // not allowed\n  if (condition) begin\n    item.print();    // allowed\n  end\nendfunction")
public class CheckMSUM
extends OVMComplianceCheck {
    public CheckMSUM(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement container : this.fOVMProject.getAllNonXVMFunctionCallContainers()) {
            List<RfFunctionCall> calls = container.getFunctionCallsWithPrefix("", 2);
            if (calls == null) continue;
            this.notifyCheckAlive();
            for (RfFunctionCall call : calls) {
                RfNamedElement callOf;
                String callName = call.getName();
                if (callName == null || !callName.equals("print") && !callName.equals("sprint") && !callName.endsWith(".print") && !callName.endsWith(".sprint") && !callName.endsWith("::print") && !callName.endsWith("::sprint") || (callOf = LintUtils.getCallOfPhysicalType(call)) == null || !(callOf instanceof RfClass) || !this.fOVMProject.isSequenceItem((RfClass)callOf)) continue;
                RfNamedElement calledIn = LintUtils.getCalledInPhysicalType(call);
                List<RfFunction> allFctTsks = calledIn.getFunctionsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
                allFctTsks.addAll(calledIn.getTasksWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE));
                boolean isConditional = LintUtils.isConditionalCode(call, allFctTsks);
                if (isConditional) {
                    this.addPassedHit(call, "'" + call.getFunctionName() + "()' is called in conditional code in " + calledIn.getName());
                    continue;
                }
                this.addHit(call, "'" + call.getFunctionName() + "()' is not called in conditional code in " + calledIn.getName());
            }
        }
    }
}

