/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractNamePatternParametersCheck;
import ro.amiq.vlogdt.model.reflection.RfClass;

@CheckVersion(value="3.1")
@CheckID(value="XVM1")
@CheckName(value="XVM1")
@CheckLabel(labels={RuleLabel.BASE_CLASS, RuleLabel.SEQUENCE_ITEM, RuleLabel.VERIFICATION})
@CheckTitle(value="Sequence Item Inherits from xvm_sequence_item")
@CheckDescription(value="Verify that every data item class declaration is extending from xvm_sequence_item or a derivative of xvm_sequence_item.")
@CheckParameterOverride(name="sequenceItemClassNamePattern", isVisible=true)
public class CheckOVM1
extends AbstractNamePatternParametersCheck {
    public CheckOVM1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.getClassesWithPatterns("sequenceItemClassNamePattern").isEmpty()) {
            return;
        }
        if (this.fOVMProject.fOvmSequenceItem == null) {
            return;
        }
        for (RfClass dataItem : this.getClassesWithPatterns("sequenceItemClassNamePattern").values()) {
            this.notifyCheckAlive();
            if (dataItem.isSubClass(this.fOVMProject.fOvmSequenceItem)) {
                this.addPassedHit(dataItem, "'" + dataItem.getName() + "' extends '" + this.fOVMProject.fOvmSequenceItem.getName() + "'");
                continue;
            }
            this.addHit(dataItem, "'" + dataItem.getName() + "' does not extend '" + this.fOVMProject.fOvmSequenceItem.getName() + "'");
        }
    }
}

