/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.svtb.AbstractMacroUseCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;

@CheckVersion(value="3.1")
@CheckID(value="XVM11")
@CheckName(value="XVM11")
@CheckTitle(value="`xvm_update_sequence_lib, `xvm_update_sequence_lib_and_item")
@CheckDescription(value="Sequencer classes derived from xvm_sequencer must include the proper macro in the new() method.\nSequencers must have `xvm_update_sequence_lib_and_item() or `xvm_update_sequence_lib in new(). Please refer to example in XVM10.\n\nNote: The `xvm_update_sequence_lib macro should be used when defining a virtual sequencer while `xvm_update_sequence_lib_and_item macro should be used for driver sequencers.\n\nCheck supports pre-waiving.")
public class CheckOVM11
extends AbstractMacroUseCheck {
    @CheckParameter(defaultValue="false", description="When true, virtual sequencers will be considered as sequencers with default parameters. All non-virtual sequencers are considered driver sequencers.", name="allowVirtualSequencersWithDefaultParameters", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowVirtualSequencersWithDefaultParameters;

    public CheckOVM11(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        HashSet<String> relevantMacros = new HashSet<String>();
        relevantMacros.add("`ovm_update_sequence_lib_and_item");
        relevantMacros.add("`ovm_update_sequence_lib");
        relevantMacros.add("`uvm_update_sequence_lib_and_item");
        relevantMacros.add("`uvm_update_sequence_lib");
        aRfProject.lintTrackMacrosByNames("constructor", relevantMacros);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.fSequencers.isEmpty()) {
            return;
        }
        boolean isOVMLib = this.fOVMProject.getLibraryKind() == 1;
        String libUpdateSequenceLibItem = isOVMLib ? "`ovm_update_sequence_lib_and_item" : "`uvm_update_sequence_lib_and_item";
        String libUpdateSequenceLib = isOVMLib ? "`ovm_update_sequence_lib" : "`uvm_update_sequence_lib";
        NullProtectedList<RfClass> driverSequencers = new NullProtectedList();
        Collection<Object> virtualSequencers = new NullProtectedList();
        if (this.pAllowVirtualSequencersWithDefaultParameters) {
            for (RfNamedElement clazz : this.fOVMProject.getAllNonXVMClasses()) {
                if (!(clazz instanceof RfClass)) continue;
                if (LintUtils.isVirtualSequencer((RfClass)clazz, this.fOVMProject.fOvmSequencer, this.fOVMProject.fOvmSequenceItem)) {
                    virtualSequencers.add((RfClass)clazz);
                    continue;
                }
                driverSequencers.add((RfClass)clazz);
            }
        } else {
            driverSequencers = this.fOVMProject.getDriverSequencers().values();
            virtualSequencers = this.fOVMProject.getVirtualSequencers().values();
        }
        this.checkMacrosInClassesAndFunction(driverSequencers, "new", new HashSet<String>(Arrays.asList(libUpdateSequenceLibItem)), libUpdateSequenceLibItem);
        this.checkMacrosInClassesAndFunction(virtualSequencers, "new", new HashSet<String>(Arrays.asList(libUpdateSequenceLib)), libUpdateSequenceLib);
    }
}

