/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFunction;

@CheckVersion(value="3.1")
@CheckID(value="XVM15a")
@CheckName(value="XVM15a")
@CheckLabel(labels={RuleLabel.RUN_PHASE, RuleLabel.DRIVER, RuleLabel.METHOD, RuleLabel.VERIFICATION})
@CheckTitle(value="Mandatory Driver Run Phase")
@CheckDescription(value="Inside a driver the run phase method must exist.")
public class CheckOVM15a
extends OVMComplianceCheck {
    public CheckOVM15a(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.fDrivers.isEmpty()) {
            return;
        }
        for (RfClass driver : this.fOVMProject.fDrivers.values()) {
            if (driver.hasVirtualQualifier()) {
                this.addPassedHit(driver, "'" + driver.getName() + "' is virtual, skipped");
                continue;
            }
            this.notifyCheckAlive();
            List<RfFunction> candidates = driver.getFunctionsWithPrefix(this.fOVMProject.getRunPhaseMethodName(), 1, 2, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            if (candidates == null || candidates.isEmpty()) {
                candidates = driver.getTasksWithPrefix(this.fOVMProject.getRunPhaseMethodName(), 1, 2, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            }
            if (candidates == null || candidates.isEmpty() || this.fOVMProject.isOVMElement(candidates.get(0).getEnclosingScope())) {
                this.addHit(driver, String.valueOf(this.fOVMProject.getRunPhaseMethodName()) + "() method was not found in driver '" + driver.getName() + "'");
                continue;
            }
            this.addPassedHit(candidates.get(0), String.valueOf(this.fOVMProject.getRunPhaseMethodName()) + "() method was found in driver '" + driver.getName() + "'");
        }
    }
}

