/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.standard.checks;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionCall;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedScalarType;

@CheckVersion(value="3.1")
@CheckID(value="XVM15b")
@CheckName(value="XVM15b")
@CheckLabel(labels={RuleLabel.RUN_PHASE, RuleLabel.DRIVER, RuleLabel.METHOD, RuleLabel.VERIFICATION})
@CheckTitle(value="Mandatory get_next_item(), item_done() calls in Driver Run Phase")
@CheckDescription(value="Inside the run phase method of a driver get_next_item() and item_done() should be called.\n\nCheck supports pre-waiving.")
public class CheckOVM15b
extends OVMComplianceCheck {
    public CheckOVM15b(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.fDrivers.isEmpty()) {
            return;
        }
        for (RfClass driver : this.fOVMProject.fDrivers.values()) {
            RfFunction runFct;
            this.notifyCheckAlive();
            if (this.checkPreWaivers(driver.getFile()) || (runFct = driver.getLocalMember(RfFunction.class, this.fOVMProject.getRunPhaseMethodName(), true)) == null) continue;
            List<RfField> fields = driver.getFieldsWithPrefix("", 2, 2, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            boolean[] foundMethods = new boolean[2];
            List<Object> filteredFields = new ArrayList();
            for (RfField field : fields) {
                RfNamedElement at = LintUtils.getAssociatedFinalType(field);
                if (at == null || at instanceof RfPredefinedScalarType) continue;
                RfFunction gniTask = at.getTaskWithPrefix("get_next_item", 1, 2, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
                if (gniTask != null) {
                    filteredFields.add(field);
                    continue;
                }
                RfFunction idFunction = at.getFunctionWithPrefix("item_done", 1, 2, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
                if (idFunction == null) continue;
                filteredFields.add(field);
            }
            filteredFields = fields;
            if (filteredFields.isEmpty()) continue;
            HashSet<RfFunction> visited = new HashSet<RfFunction>();
            visited.add(runFct);
            this.checkFunctionCalls(driver, runFct, foundMethods, visited, filteredFields);
            if (!foundMethods[0] && !foundMethods[1]) {
                this.addHit(runFct, "get_next_item() and item_done() are not called from " + this.fOVMProject.getRunPhaseMethodName() + "() in driver '" + driver.getName() + "'");
                continue;
            }
            if (!foundMethods[0]) {
                this.addHit(runFct, "get_next_item() is not called from  " + this.fOVMProject.getRunPhaseMethodName() + "() in driver '" + driver.getName() + "'");
                continue;
            }
            if (foundMethods[1]) continue;
            this.addHit(runFct, "item_done() is not called from  " + this.fOVMProject.getRunPhaseMethodName() + "() in driver '" + driver.getName() + "'");
        }
    }

    private void checkFunctionCalls(RfClass driver, RfFunction rfFunction, boolean[] foundMethods, Set<RfFunction> visited, List<RfField> filteredFields) {
        if (rfFunction == null) {
            return;
        }
        if (foundMethods[0] && foundMethods[1]) {
            return;
        }
        List<RfFunctionCall> functionCalls = rfFunction.getFunctionCallsWithPrefix("", 2);
        if (functionCalls == null || functionCalls.isEmpty()) {
            return;
        }
        block0: for (RfFunctionCall functionCall : functionCalls) {
            if (foundMethods[0] && foundMethods[1]) {
                return;
            }
            if (functionCall == null) continue;
            if (!foundMethods[0] && functionCall.getName().endsWith(".get_next_item")) {
                for (RfField field : filteredFields) {
                    if (!functionCall.getName().equals(String.valueOf(field.getName()) + ".get_next_item")) continue;
                    foundMethods[0] = true;
                    continue block0;
                }
                continue;
            }
            if (foundMethods[1] || !functionCall.getName().endsWith(".item_done")) continue;
            for (RfField field : filteredFields) {
                if (!functionCall.getName().equals(String.valueOf(field.getName()) + ".item_done")) continue;
                foundMethods[1] = true;
                continue block0;
            }
        }
        if (foundMethods[0] && foundMethods[1]) {
            return;
        }
        for (RfFunctionCall functionCall : functionCalls) {
            RfFunction calledFunction;
            if (functionCall == null || functionCall.getFunction() == null || visited.contains(calledFunction = functionCall.getFunction())) continue;
            visited.add(calledFunction);
            this.checkFunctionCalls(driver, calledFunction, foundMethods, visited, filteredFields);
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

